/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.finitestates;

import com.atomikos.finitestates.FSM;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.finitestates.FSMTransitionEvent;
import com.atomikos.finitestates.FSMTransitionListener;
import com.atomikos.finitestates.Transition;
import com.atomikos.recovery.TxState;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class FSMImp
implements FSM {
    private TxState state_ = null;
    private final Hashtable<TxState, Set<FSMEnterListener>> enterlisteners_ = new Hashtable();
    private final Hashtable<Transition, Set<FSMTransitionListener>> transitionlisteners_ = new Hashtable();
    private Object eventsource_ = null;
    private final Object stateLatch_ = new Object();

    public FSMImp(TxState initialstate) {
        this(null, initialstate);
        this.eventsource_ = this;
    }

    public FSMImp(Object eventsource, TxState initialstate) {
        this.state_ = initialstate;
        this.eventsource_ = eventsource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(TxState state, boolean pre) {
        Set<FSMEnterListener> lstnrs = null;
        FSMEnterEvent event = new FSMEnterEvent(this.eventsource_, state);
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            lstnrs = this.enterlisteners_.get((Object)state);
            if (lstnrs == null) {
                return;
            }
            lstnrs = new HashSet<FSMEnterListener>(lstnrs);
        }
        for (FSMEnterListener listener : lstnrs) {
            if (pre) {
                listener.preEnter(event);
                continue;
            }
            listener.entered(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(Transition transition, boolean pre) {
        FSMTransitionEvent event = new FSMTransitionEvent(this.eventsource_, transition);
        Set<FSMTransitionListener> lstnrs = null;
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            lstnrs = this.transitionlisteners_.get(transition);
            if (lstnrs == null) {
                return;
            }
            lstnrs = new HashSet<FSMTransitionListener>(lstnrs);
        }
        for (FSMTransitionListener listener : lstnrs) {
            if (pre) {
                listener.beforeTransition(event);
                continue;
            }
            listener.transitionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxState getState() {
        TxState ret = null;
        Object object = this.stateLatch_;
        synchronized (object) {
            ret = this.state_;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStateObject(TxState state) {
        Object object = this.stateLatch_;
        synchronized (object) {
            this.state_ = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(TxState state) throws IllegalStateException {
        TxState oldstate = null;
        Transition transition = null;
        FSMImp fSMImp = this;
        synchronized (fSMImp) {
            if (!this.state_.transitionAllowedTo(state)) {
                throw new IllegalStateException("Transition not allowed: " + (Object)((Object)this.state_) + " to " + (Object)((Object)state));
            }
            oldstate = this.state_;
            transition = new Transition(oldstate, state);
            this.notifyListeners(state, true);
            this.notifyListeners(transition, true);
            this.setStateObject(state);
        }
        this.notifyListeners(state, false);
        this.notifyListeners(transition, false);
    }

    @Override
    public synchronized void addFSMEnterListener(FSMEnterListener lstnr, TxState state) {
        Set<FSMEnterListener> lstnrs = this.enterlisteners_.get((Object)state);
        if (lstnrs == null) {
            lstnrs = new HashSet<FSMEnterListener>();
            this.enterlisteners_.put(state, lstnrs);
        }
        if (!lstnrs.contains(lstnr)) {
            lstnrs.add(lstnr);
        }
    }

    @Override
    public synchronized void addFSMTransitionListener(FSMTransitionListener listener, TxState from, TxState to) {
        Transition transition = new Transition(from, to);
        Set<FSMTransitionListener> lstnrs = this.transitionlisteners_.get(transition);
        if (lstnrs == null) {
            lstnrs = new HashSet<FSMTransitionListener>();
            this.transitionlisteners_.put(transition, lstnrs);
        }
        if (!lstnrs.contains(listener)) {
            lstnrs.add(listener);
        }
    }
}

