/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionServicePlugin;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.ConditionalWaiter;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.RecoveryDomainService;
import com.atomikos.icatch.imp.SubTransactionRecoveryCoordinator;
import com.atomikos.icatch.provider.TransactionServiceProvider;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.fs.RecoveryLogImp;
import com.atomikos.thread.InterruptedExceptionHelper;
import com.atomikos.thread.TaskManager;
import com.atomikos.util.UniqueIdMgr;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public class TransactionServiceImp
implements TransactionServiceProvider,
FSMEnterListener,
SubTxAwareParticipant,
RecoveryService {
    private static final Logger LOGGER = LoggerFactory.createLogger(TransactionServiceImp.class);
    private static final int NUMLATCHES = 97;
    private static final Object shutdownSynchronizer = new Object();
    private long maxTimeout_;
    private Object[] rootLatches_ = null;
    private Hashtable<String, CompositeTransaction> tidToTransactionMap_ = null;
    private Map<String, CoordinatorImp> recreatedCoordinatorsByRootId = new HashMap<String, CoordinatorImp>();
    private Map<String, CoordinatorImp> allCoordinatorsByCoordinatorId = new HashMap<String, CoordinatorImp>();
    private boolean shutdownInProgress_ = false;
    private UniqueIdMgr tidmgr_ = null;
    private StateRecoveryManager recoverymanager_ = null;
    private boolean initialized_ = false;
    private Set<TransactionServicePlugin> tsListeners = new HashSet<TransactionServicePlugin>();
    private int maxNumberOfActiveTransactions_;
    private String tmUniqueName_;
    private boolean single_threaded_2pc_;
    private RecoveryLog recoveryLog;
    private RecoveryDomainService recoveryDomainService;

    public TransactionServiceImp(String name, StateRecoveryManager recoverymanager, UniqueIdMgr tidmgr, long maxtimeout, int maxActives, boolean single_threaded_2pc, RecoveryLog recoveryLog) {
        this.maxNumberOfActiveTransactions_ = maxActives;
        this.initialized_ = false;
        this.recoverymanager_ = recoverymanager;
        this.tidmgr_ = tidmgr;
        this.tidToTransactionMap_ = new Hashtable();
        this.rootLatches_ = new Object[97];
        for (int i = 0; i < 97; ++i) {
            this.rootLatches_[i] = new Object();
        }
        this.maxTimeout_ = maxtimeout;
        this.tmUniqueName_ = name;
        this.single_threaded_2pc_ = single_threaded_2pc;
        this.recoveryLog = recoveryLog;
        this.recoveryDomainService = new RecoveryDomainService(recoveryLog);
    }

    private Object getLatch(String root) {
        return this.rootLatches_[Math.abs(root.toString().hashCode() % 97)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTidToTx(String tid, CompositeTransaction ct) throws IllegalStateException {
        Hashtable<String, CompositeTransaction> hashtable = this.tidToTransactionMap_;
        synchronized (hashtable) {
            if (this.tidToTransactionMap_.containsKey(tid.intern())) {
                throw new IllegalStateException("Already mapped: " + tid);
            }
            this.tidToTransactionMap_.put(tid.intern(), ct);
            ct.addSubTxAwareParticipant(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCoordinator(CompositeCoordinator coord) {
        Object object = shutdownSynchronizer;
        synchronized (object) {
            Object object2 = this.getLatch(coord.getRootId());
            synchronized (object2) {
                this.recreatedCoordinatorsByRootId.remove(coord.getRootId());
                this.allCoordinatorsByCoordinatorId.remove(coord.getCoordinatorId());
            }
            if (this.allCoordinatorsByCoordinatorId.isEmpty()) {
                shutdownSynchronizer.notifyAll();
            }
        }
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        this.tidToTransactionMap_.remove(ct.getTid().intern());
    }

    private CompositeTransactionImp createCT(String tid, CoordinatorImp coordinator, Stack<CompositeTransaction> lineage, boolean serial) throws SysException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Creating composite transaction: " + tid);
        }
        CompositeTransactionImp ct = new CompositeTransactionImp(this, lineage, tid, serial, coordinator);
        this.setTidToTx(ct.getTid(), ct);
        coordinator.incLocalSiblingsStarted();
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp createCC(String recoveryDomainName, RecoveryCoordinator adaptor, String root, long timeout) {
        CoordinatorImp cc = null;
        if (this.maxTimeout_ > 0L && timeout > this.maxTimeout_) {
            timeout = this.maxTimeout_;
            LOGGER.logWarning("Attempt to create a transaction with a timeout that exceeds maximum - truncating to: " + this.maxTimeout_);
        }
        Object object = shutdownSynchronizer;
        synchronized (object) {
            boolean subTransaction;
            if (this.shutdownInProgress_) {
                throw new IllegalStateException("Server is shutting down...");
            }
            String coordinatorId = root;
            boolean bl = subTransaction = adaptor != null;
            if (subTransaction) {
                coordinatorId = this.tidmgr_.get();
            }
            cc = new CoordinatorImp(recoveryDomainName, coordinatorId, root, adaptor, timeout, this.single_threaded_2pc_);
            this.recoverymanager_.register(cc);
            Object object2 = this.getLatch(root);
            synchronized (object2) {
                CoordinatorImp entryForRoot = this.recreatedCoordinatorsByRootId.get(root);
                if (entryForRoot == null) {
                    this.recreatedCoordinatorsByRootId.put(root, cc);
                }
                this.allCoordinatorsByCoordinatorId.put(coordinatorId, cc);
            }
            this.startlistening(cc);
        }
        return cc;
    }

    private void startlistening(CoordinatorImp coordinator) {
        HashSet<TxState> forgetStates = new HashSet<TxState>();
        for (TxState txState : TxState.values()) {
            if (!txState.isFinalStateForOltp()) continue;
            forgetStates.add(txState);
        }
        for (TxState txState : forgetStates) {
            coordinator.addFSMEnterListener(this, txState);
        }
        if (forgetStates.contains((Object)coordinator.getState())) {
            this.removeCoordinator(coordinator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp getCoordinatorImpForRoot(String root) throws SysException {
        root = root.intern();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CoordinatorImp cc = null;
        Object object = shutdownSynchronizer;
        synchronized (object) {
            Object object2 = this.getLatch(root);
            synchronized (object2) {
                cc = this.recreatedCoordinatorsByRootId.get(root);
            }
        }
        return cc;
    }

    @Override
    public String getName() {
        return this.tmUniqueName_;
    }

    @Override
    public CompositeCoordinator getCompositeCoordinator(String root) throws SysException {
        return this.getCoordinatorImpForRoot(root);
    }

    @Override
    public void addTSListener(TransactionServicePlugin listener) throws IllegalStateException {
        this.tsListeners.add(listener);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Added TSListener: " + listener);
        }
    }

    @Override
    public void removeTSListener(TransactionServicePlugin listener) {
        this.tsListeners.remove(listener);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("Removed TSListener: " + listener);
        }
    }

    @Override
    public synchronized void init(Properties properties) throws SysException {
        this.shutdownInProgress_ = false;
        this.recoveryDomainService.init();
        this.initialized_ = true;
    }

    @Override
    public Participant getParticipant(String root) throws SysException {
        return this.getCoordinatorImpForRoot(root);
    }

    @Override
    public void entered(FSMEnterEvent event) {
        CoordinatorImp cc = (CoordinatorImp)event.getSource();
        this.removeCoordinator(cc);
    }

    @Override
    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    @Override
    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeTransaction getCompositeTransaction(String tid) {
        CompositeTransaction ret = null;
        Hashtable<String, CompositeTransaction> hashtable = this.tidToTransactionMap_;
        synchronized (hashtable) {
            ret = this.tidToTransactionMap_.get(tid.intern());
        }
        return ret;
    }

    CompositeTransaction createSubTransaction(CompositeTransaction parent) {
        if (Configuration.getConfigProperties().getAllowSubTransactions()) {
            CompositeTransactionImp ret = null;
            Stack lineage = (Stack)parent.getLineage().clone();
            lineage.push(parent);
            String tid = this.tidmgr_.get();
            CoordinatorImp ccParent = (CoordinatorImp)parent.getCompositeCoordinator();
            SubTransactionRecoveryCoordinator rc = new SubTransactionRecoveryCoordinator(ccParent.getCoordinatorId(), this.tmUniqueName_);
            CoordinatorImp cc = this.createCC(this.tmUniqueName_, rc, parent.getCompositeCoordinator().getRootId(), parent.getTimeout());
            ret = this.createCT(tid, cc, lineage, parent.isSerial());
            ret.noLocalAncestors = false;
            return ret;
        }
        throw new SysException("Subtransactions not allowed - set config property com.atomikos.icatch.allow_subtransactions=true to enable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompositeTransaction recreateCompositeTransaction(Propagation context) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (!this.tmUniqueName_.equals(context.getRecoveryDomainName()) && !this.usesDefaultRecovery()) {
            throw new IllegalArgumentException("Cannot import a transaction from a different recovery domain: " + context.getRecoveryDomainName() + ".\nOnly transactions within the same domain (a.k.a. LogCloud) are allowed!");
        }
        if (this.maxNumberOfActiveTransactions_ >= 0 && this.tidToTransactionMap_.size() >= this.maxNumberOfActiveTransactions_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxNumberOfActiveTransactions_);
        }
        CoordinatorImp cc = null;
        CompositeTransactionImp ct = null;
        try {
            String tid = this.tidmgr_.get();
            boolean serial = context.isSerial();
            CompositeTransaction root = context.getRootTransaction();
            CompositeTransaction parent = context.getParentTransaction();
            Object object = shutdownSynchronizer;
            synchronized (object) {
                Object object2 = this.getLatch(root.getTid());
                synchronized (object2) {
                    cc = this.getCoordinatorImpForRoot(root.getTid());
                    if (cc == null) {
                        RecoveryCoordinator coord = parent.getCompositeCoordinator().getRecoveryCoordinator();
                        cc = this.createCC(context.getRecoveryDomainName(), coord, root.getTid(), context.getTimeout());
                    }
                }
            }
            ct = this.createCT(tid, cc, context.getLineage(), serial);
        }
        catch (Exception e) {
            throw new SysException("Error in recreate.", e);
        }
        return ct;
    }

    private boolean usesDefaultRecovery() {
        return Configuration.getRecoveryLog() instanceof RecoveryLogImp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean force) {
        boolean wasShuttingDown = false;
        LOGGER.logInfo("Entering shutdown (" + force + ")...");
        if (!wasShuttingDown && force) {
            for (String next : this.allCoordinatorsByCoordinatorId.keySet()) {
                LOGGER.logTrace("Stopping thread for coordinatorId " + next + "...");
                CoordinatorImp c = this.allCoordinatorsByCoordinatorId.get(next);
                if (c != null) {
                    c.dispose();
                }
                LOGGER.logTrace("Thread stopped.");
            }
        }
        Iterator<String> iterator = shutdownSynchronizer;
        synchronized (iterator) {
            LOGGER.logTrace("Shutdown acquired lock on waiter.");
            wasShuttingDown = this.shutdownInProgress_;
            this.shutdownInProgress_ = true;
            if (!force) {
                boolean timeout = this.waitForActiveCoordinatorsToFinish();
                if (!timeout) {
                    this.performRecoveryPass();
                }
                if (this.usesDefaultRecovery()) {
                    if (timeout || this.recoveryDomainService.hasPendingParticipantsFromLastRecoveryScan()) {
                        LOGGER.logWarning("Shutdown leaves pending transactions in log - do NOT delete logfiles!");
                    } else {
                        LOGGER.logInfo("Shutdown leaves no pending transactions - ok to delete logfiles");
                    }
                } else {
                    this.recoveryLog.closing();
                }
            }
            this.initialized_ = false;
            if (!wasShuttingDown) {
                try {
                    this.recoverymanager_.close();
                }
                catch (LogException le) {
                    throw new SysException("Error in shutdown: " + le.getMessage(), le);
                }
                this.recoveryDomainService.stop();
                this.recoveryLog.closed();
            }
        }
        this.shutdownSystemExecutors();
    }

    private boolean waitForActiveCoordinatorsToFinish() {
        ConditionalWaiter waiter = new ConditionalWaiter(this.maxTimeout_);
        boolean timeout = waiter.waitWhile(() -> {
            boolean allCoordinatorsDone = this.allCoordinatorsByCoordinatorId.isEmpty();
            if (!allCoordinatorsDone) {
                LOGGER.logWarning("Shutdown; waiting for all active transactions to finish...");
            }
            return !allCoordinatorsDone;
        });
        return timeout;
    }

    private void shutdownSystemExecutors() {
        TaskManager exec = TaskManager.SINGLETON;
        if (exec != null) {
            exec.shutdown();
        }
    }

    public synchronized void finalize() throws Throwable {
        try {
            if (!this.shutdownInProgress_ && this.initialized_) {
                this.shutdown(true);
            }
        }
        catch (Exception e) {
            LOGGER.logWarning("Error in GC of TransactionServiceImp", e);
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.maxNumberOfActiveTransactions_ >= 0 && this.tidToTransactionMap_.size() >= this.maxNumberOfActiveTransactions_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxNumberOfActiveTransactions_);
        }
        String tid = this.tidmgr_.get();
        Stack<CompositeTransaction> lineage = new Stack<CompositeTransaction>();
        CoordinatorImp cc = this.createCC(this.tmUniqueName_, null, tid, timeout);
        CompositeTransactionImp ct = this.createCT(tid, cc, lineage, false);
        return ct;
    }

    @Override
    public RecoveryService getRecoveryService() {
        return this;
    }

    @Override
    public RecoveryLog getRecoveryLog() {
        return this.recoveryLog;
    }

    @Override
    public boolean performRecovery() {
        boolean perform = this.performRecoveryPass();
        if (perform) {
            try {
                Thread.currentThread();
                Thread.sleep(this.maxTimeout_ + 1000L);
            }
            catch (InterruptedException e) {
                InterruptedExceptionHelper.handleInterruptedException(e);
            }
            this.performRecoveryPass();
        }
        return perform;
    }

    protected boolean performRecoveryPass() {
        boolean ret = false;
        RecoveryDomainService rds = this.recoveryDomainService;
        if (rds != null) {
            ret = rds.performRecovery();
        }
        return ret;
    }

    @Override
    public boolean performRecovery(boolean lax) {
        return this.performRecovery();
    }

    @Override
    public void preEnter(FSMEnterEvent e) throws IllegalStateException {
    }
}

