/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.internal;

import com.atomikos.datasource.pool.AbstractXPooledConnection;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jms.internal.AtomikosJmsConnectionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;

public class AtomikosPooledJmsConnection
extends AbstractXPooledConnection<Connection>
implements SessionHandleStateChangeListener {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosPooledJmsConnection.class);
    private XAConnection xaConnection;
    private XATransactionalResource jmsTransactionalResource;
    private Connection currentProxy;
    private ConnectionPoolProperties props;
    private boolean erroneous;
    private int sessionCreationMode;

    public AtomikosPooledJmsConnection(int sessionCreationMode, XAConnection xac, XATransactionalResource jmsTransactionalResource, ConnectionPoolProperties props) {
        super(props);
        this.jmsTransactionalResource = jmsTransactionalResource;
        this.xaConnection = xac;
        this.props = props;
        this.erroneous = false;
        this.sessionCreationMode = sessionCreationMode;
    }

    @Override
    protected Connection doCreateConnectionProxy() throws CreateConnectionException {
        this.currentProxy = AtomikosJmsConnectionProxy.newInstance(this.sessionCreationMode, this.xaConnection, this.jmsTransactionalResource, this, this.props);
        return this.currentProxy;
    }

    @Override
    protected void testUnderlyingConnection() throws CreateConnectionException {
        if (this.isErroneous()) {
            throw new CreateConnectionException(this + ": connection is erroneous");
        }
        if (this.maxLifetimeExceeded()) {
            throw new CreateConnectionException(this + ": connection too old - will be replaced");
        }
    }

    @Override
    public void doDestroy() {
        if (this.xaConnection != null) {
            try {
                this.xaConnection.close();
            }
            catch (JMSException ex) {
                LOGGER.logWarning(this + ": error closing XAConnection: ", ex);
            }
        }
        this.xaConnection = null;
    }

    @Override
    public synchronized boolean isAvailable() {
        boolean ret = true;
        if (this.currentProxy != null) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)Proxy.getInvocationHandler(this.currentProxy);
            ret = proxy.isAvailable();
        }
        return ret;
    }

    @Override
    public synchronized boolean isErroneous() {
        boolean ret = this.erroneous;
        if (this.currentProxy != null) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)Proxy.getInvocationHandler(this.currentProxy);
            ret = ret || proxy.isErroneous();
        }
        return ret;
    }

    public synchronized boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        if (this.currentProxy != null) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)Proxy.getInvocationHandler(this.currentProxy);
            ret = proxy.isInTransaction(ct);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTerminated() {
        boolean fireTerminatedEvent = false;
        AtomikosJmsConnectionProxy proxy = null;
        AtomikosPooledJmsConnection atomikosPooledJmsConnection = this;
        synchronized (atomikosPooledJmsConnection) {
            fireTerminatedEvent = this.isAvailable();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": a session has terminated, is connection now available ? " + fireTerminatedEvent);
            }
            if (this.currentProxy != null && (proxy = (AtomikosJmsConnectionProxy)Proxy.getInvocationHandler(this.currentProxy)).isErroneous()) {
                this.erroneous = true;
            }
        }
        if (fireTerminatedEvent) {
            if (proxy != null) {
                proxy.closeAllPendingSessions();
            }
            this.fireOnXPooledConnectionTerminated();
        }
    }

    @Override
    public boolean canBeRecycledForCallingThread() {
        CompositeTransactionManager tm;
        CompositeTransaction current;
        boolean ret = false;
        if (this.currentProxy != null && (current = (tm = Configuration.getCompositeTransactionManager()).getCompositeTransaction()) != null && TransactionManagerImp.isJtaTransaction(current)) {
            AtomikosJmsConnectionProxy proxy = (AtomikosJmsConnectionProxy)Proxy.getInvocationHandler(this.currentProxy);
            ret = proxy.isInactiveInTransaction(current);
        }
        return ret;
    }

    public String toString() {
        return "atomikosPooledJmsConnection for resource " + this.jmsTransactionalResource.getName();
    }
}

