/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.persistence.RecoverableCoordinator;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.OltpLog;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.TxState;
import com.atomikos.util.Assert;

public class StateRecoveryManagerImp
implements StateRecoveryManager,
FSMEnterListener {
    private OltpLog oltpLog;

    @Override
    public void register(RecoverableCoordinator staterecoverable) {
        TxState[] states;
        Assert.notNull("illegal attempt to register null staterecoverable", staterecoverable);
        for (TxState txState : states = TxState.values()) {
            if (!txState.isRecoverableState()) continue;
            staterecoverable.addFSMEnterListener(this, txState);
        }
    }

    @Override
    public void preEnter(FSMEnterEvent event) throws IllegalStateException {
        TxState state = event.getState();
        RecoverableCoordinator source = (RecoverableCoordinator)event.getSource();
        PendingTransactionRecord pendingTransactionRecord = source.getPendingTransactionRecord(state);
        if (pendingTransactionRecord != null) {
            try {
                this.oltpLog.write(pendingTransactionRecord);
            }
            catch (Exception le) {
                throw new IllegalStateException("could not flush state image " + le.getMessage() + " " + le.getClass().getName(), le);
            }
        }
    }

    @Override
    public void close() throws LogException {
        this.oltpLog.close();
    }

    public void setOltpLog(OltpLog oltpLog) {
        this.oltpLog = oltpLog;
    }

    @Override
    public void entered(FSMEnterEvent e) {
    }
}

