/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.XAExceptionHelper;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XID;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import com.atomikos.util.Assert;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceTransaction
implements ResourceTransaction,
Participant {
    private static final Logger LOGGER = LoggerFactory.createLogger(XAResourceTransaction.class);
    static final long serialVersionUID = -8227293322090019196L;
    private String tid;
    private String root;
    private boolean isXaSuspended;
    private TxState state;
    private String resourcename;
    private transient XID xid;
    private transient String toString;
    private final transient XATransactionalResource resource;
    private transient XAResource xaresource;
    private transient boolean knownInResource;
    private transient int timeout;

    private static String interpretErrorCode(String resourceName, String opCode, Xid xid, int errorCode) {
        String msg = XAExceptionHelper.convertErrorCodeToVerboseMessage(errorCode);
        return "XA resource '" + resourceName + "': " + opCode + " for XID '" + xid + "' raised " + errorCode + ": " + msg;
    }

    private void setXid(XID xid) {
        this.xid = xid;
        this.toString = "XAResourceTransaction: " + xid;
    }

    XAResourceTransaction(XATransactionalResource resource, CompositeTransaction transaction, String root) {
        Assert.notNull("resource cannot be null", resource);
        this.resource = resource;
        this.timeout = (int)transaction.getTimeout() / 1000;
        this.tid = transaction.getCompositeCoordinator().getCoordinatorId();
        this.root = root;
        this.resourcename = resource.getName();
        this.setXid(this.resource.createXid(this.tid));
        this.setState(TxState.ACTIVE);
        this.isXaSuspended = false;
        this.knownInResource = false;
    }

    void setState(TxState state) {
        if (state.isHeuristic()) {
            LOGGER.logWarning("Heuristic termination of " + this.toString() + " with state " + (Object)((Object)state));
        }
        this.state = state;
    }

    protected void testOrRefreshXAResourceFor2PC() throws XAException {
        try {
            if (this.state == TxState.HEUR_HAZARD) {
                this.forceRefreshXAConnection();
            } else if (this.xaresource != null) {
                this.assertConnectionIsStillAlive();
            }
        }
        catch (XAException xa) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this.resourcename + ": XAResource needs refresh", xa);
            }
            this.xaresource = this.resource.getXAResource();
        }
    }

    private void assertConnectionIsStillAlive() throws XAException {
        this.xaresource.isSameRM(this.xaresource);
    }

    private void forceRefreshXAConnection() throws XAException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this.resourcename + ": forcing refresh of XAConnection...");
        }
        try {
            this.xaresource = this.resource.refreshXAConnection();
        }
        catch (ResourceException re) {
            LOGGER.logWarning(this.resourcename + ": could not refresh XAConnection", re);
        }
    }

    private void terminateInResource() {
        if (this.resource != null) {
            this.resource.removeSiblingMap(this.root);
        }
    }

    public String getTid() {
        return this.tid;
    }

    @Override
    public synchronized void suspend() throws ResourceException {
        if (this.state.equals((Object)TxState.ACTIVE)) {
            block4: {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug("XAResource.end ( " + this.xid + " , XAResource.TMSUCCESS ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                    }
                    this.xaresource.end(this.xid, 0x4000000);
                }
                catch (XAException xaerr) {
                    String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "end", this.xid, xaerr.errorCode);
                    if (!LOGGER.isTraceEnabled()) break block4;
                    LOGGER.logTrace(msg, xaerr);
                }
            }
            this.setState(TxState.LOCALLY_DONE);
        }
    }

    boolean supportsTmJoin() {
        return !this.isActive();
    }

    @Override
    public synchronized void resume() throws ResourceException {
        int flag = 0;
        String logFlag = "";
        if (this.state.equals((Object)TxState.LOCALLY_DONE)) {
            flag = 0x200000;
            logFlag = "XAResource.TMJOIN";
        } else if (!this.knownInResource) {
            flag = 0;
            logFlag = "XAResource.TMNOFLAGS";
        } else {
            throw new IllegalStateException("Wrong state for resume: " + (Object)((Object)this.state));
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.start ( " + this.xid + " , " + logFlag + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, flag);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, xaerr);
            throw new ResourceException(msg, xaerr);
        }
        this.setState(TxState.ACTIVE);
        this.knownInResource = true;
    }

    @Override
    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
    }

    public Object getState() {
        return this.state;
    }

    private boolean beforePrepare() {
        return TxState.ACTIVE.equals((Object)this.state) || TxState.LOCALLY_DONE.equals((Object)this.state);
    }

    @Override
    public void setGlobalSiblingCount(int count) {
    }

    @Override
    public synchronized void forget() {
        this.terminateInResource();
        try {
            if (this.xaresource != null) {
                this.xaresource.forget(this.xid);
            }
        }
        catch (Exception err) {
            LOGGER.logTrace("Error forgetting xid: " + this.xid, err);
        }
        this.setState(TxState.TERMINATED);
    }

    @Override
    public synchronized int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        int ret = 0;
        this.terminateInResource();
        if (TxState.ACTIVE == this.state) {
            this.suspend();
        }
        if (this.state == TxState.IN_DOUBT) {
            return 0;
        }
        if (this.state != TxState.LOCALLY_DONE) {
            throw new SysException("Wrong state for prepare: " + (Object)((Object)this.state));
        }
        try {
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("About to call prepare on XAResource instance: " + this.xaresource);
            }
            ret = this.xaresource.prepare(this.xid);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "prepare", this.xid, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                LOGGER.logWarning(msg, xaerr);
                throw new RollbackException(msg, xaerr);
            }
            LOGGER.logError(msg, xaerr);
            throw new SysException(msg, xaerr);
        }
        this.setState(TxState.IN_DOUBT);
        if (ret == 3) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.prepare ( " + this.xid + " ) returning XAResource.XA_RDONLY on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            return 0;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("XAResource.prepare ( " + this.xid + " ) returning OK on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
        }
        return 1;
    }

    @Override
    public synchronized void rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        this.terminateInResource();
        if (this.rollbackShouldDoNothing()) {
            return;
        }
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return;
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException();
        }
        if (this.state.equals((Object)TxState.HEUR_COMMITTED)) {
            throw new HeurCommitException();
        }
        if (this.xaresource == null) {
            throw new HeurHazardException("XAResourceTransaction " + this.getXid() + ": no XAResource to rollback?");
        }
        try {
            if (this.state.equals((Object)TxState.ACTIVE)) {
                this.suspend();
            }
            this.testOrRefreshXAResourceFor2PC();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.rollback ( " + this.xid + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.rollback(this.xid);
        }
        catch (ResourceException resErr) {
            throw new SysException("Error in rollback: " + resErr.getMessage(), resErr);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "rollback", this.xid, xaerr.errorCode);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(msg);
                }
            }
            LOGGER.logWarning(msg, xaerr);
            switch (xaerr.errorCode) {
                case 8: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
                case 5: {
                    this.setState(TxState.HEUR_MIXED);
                    throw new HeurMixedException();
                }
                case 7: {
                    this.setState(TxState.HEUR_COMMITTED);
                    throw new HeurCommitException();
                }
                case 6: {
                    this.forget();
                    break;
                }
                case -4: {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTrace("XAResource.rollback: invalid Xid - already rolled back in resource?");
                    }
                    this.setState(TxState.TERMINATED);
                    break;
                }
                default: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new SysException(msg, xaerr);
                }
            }
        }
        this.setState(TxState.TERMINATED);
    }

    private boolean rollbackShouldDoNothing() {
        return !this.knownInResource && this.beforePrepare();
    }

    @Override
    public synchronized void commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        this.terminateInResource();
        if (this.state.equals((Object)TxState.TERMINATED)) {
            return;
        }
        if (this.state.equals((Object)TxState.HEUR_MIXED)) {
            throw new HeurMixedException();
        }
        if (this.state.equals((Object)TxState.HEUR_ABORTED)) {
            throw new HeurRollbackException();
        }
        if (this.xaresource == null) {
            String msg = this.toString + ": no XAResource to commit - recovery will handle this in the background...";
            LOGGER.logWarning(msg);
            throw new HeurHazardException(msg);
        }
        try {
            if (TxState.ACTIVE.equals((Object)this.state)) {
                this.suspend();
            }
        }
        catch (ResourceException re) {
            throw new RollbackException(re.getMessage());
        }
        if (!this.state.isOneOf(TxState.LOCALLY_DONE, TxState.IN_DOUBT, TxState.HEUR_HAZARD)) {
            throw new SysException("Wrong state for commit: " + (Object)((Object)this.state));
        }
        try {
            if (!onePhase) {
                this.testOrRefreshXAResourceFor2PC();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.commit ( " + this.xid + " , " + onePhase + " ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.commit(this.xid, onePhase);
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "commit", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, xaerr);
            if (100 <= xaerr.errorCode && xaerr.errorCode <= 107) {
                if (!onePhase) {
                    throw new SysException(msg, xaerr);
                }
                throw new RollbackException("Already rolled back in resource.", xaerr);
            }
            switch (xaerr.errorCode) {
                case 8: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new HeurHazardException();
                }
                case 5: {
                    this.setState(TxState.HEUR_MIXED);
                    throw new HeurMixedException();
                }
                case 7: {
                    this.forget();
                    break;
                }
                case 6: {
                    this.setState(TxState.HEUR_ABORTED);
                    throw new HeurRollbackException();
                }
                case -4: {
                    if (!onePhase) {
                        LOGGER.logWarning("XAResource.commit: invalid Xid - transaction already committed in resource?");
                        this.setState(TxState.TERMINATED);
                        break;
                    }
                }
                default: {
                    this.setState(TxState.HEUR_HAZARD);
                    throw new SysException(msg, xaerr);
                }
            }
        }
        this.setState(TxState.TERMINATED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XAResourceTransaction)) {
            return false;
        }
        XAResourceTransaction other = (XAResourceTransaction)o;
        return this.xid.equals(other.xid);
    }

    public int hashCode() {
        return this.xid.hashCode();
    }

    public String toString() {
        return this.toString;
    }

    public Xid getXid() {
        return this.xid;
    }

    public void setXAResource(XAResource xaresource) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": about to switch to XAResource " + xaresource);
        }
        this.xaresource = xaresource;
        try {
            this.xaresource.setTransactionTimeout(this.timeout);
        }
        catch (XAException e) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "setTransactionTimeout", this.xid, e.errorCode);
            LOGGER.logWarning(msg, e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("XAResourceTransaction " + this.getXid() + ": switched to XAResource " + xaresource);
        }
    }

    public void xaSuspend() throws XAException {
        if (!this.isXaSuspended) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("XAResource.suspend ( " + this.xid + " , XAResource.TMSUSPEND ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
                }
                this.xaresource.end(this.xid, 0x2000000);
                this.isXaSuspended = true;
            }
            catch (XAException xaerr) {
                String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "suspend", this.xid, xaerr.errorCode);
                LOGGER.logWarning(msg, xaerr);
                throw xaerr;
            }
        }
    }

    public void xaResume() throws XAException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("XAResource.start ( " + this.xid + " , XAResource.TMRESUME ) on resource " + this.resourcename + " represented by XAResource instance " + this.xaresource);
            }
            this.xaresource.start(this.xid, 0x8000000);
            this.isXaSuspended = false;
        }
        catch (XAException xaerr) {
            String msg = XAResourceTransaction.interpretErrorCode(this.resourcename, "resume", this.xid, xaerr.errorCode);
            LOGGER.logWarning(msg, xaerr);
            throw xaerr;
        }
    }

    public boolean isXaSuspended() {
        return this.isXaSuspended;
    }

    public boolean isActive() {
        return this.state.equals((Object)TxState.ACTIVE);
    }

    @Override
    public String getURI() {
        return this.xid.getBranchQualifierAsString();
    }

    @Override
    public String getResourceName() {
        return this.resourcename;
    }
}

