/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms.internal;

import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.SessionHandleStateChangeListener;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jms.internal.AbstractJmsSessionProxy;
import com.atomikos.jms.internal.AtomikosJmsNonXaSessionProxy;
import com.atomikos.jms.internal.AtomikosJmsXaSessionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.DynamicProxySupport;
import com.atomikos.util.Proxied;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;

public class AtomikosJmsConnectionProxy
extends DynamicProxySupport<XAConnection>
implements SessionHandleStateChangeListener {
    private static Logger LOGGER = LoggerFactory.createLogger(AtomikosJmsConnectionProxy.class);
    private List<Session> sessions = new ArrayList<Session>();
    private XATransactionalResource jmsTransactionalResource;
    private boolean ignoreSessionTransactedFlag;
    private ConnectionPoolProperties props;
    private SessionHandleStateChangeListener owner;
    private boolean erroneous;

    public AtomikosJmsConnectionProxy(XAConnection delegate, boolean ignoreSessionTransactedFlag, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener owner, ConnectionPoolProperties props) {
        super(delegate);
        this.jmsTransactionalResource = jmsTransactionalResource;
        this.closed = false;
        this.owner = owner;
        this.props = props;
        this.ignoreSessionTransactedFlag = ignoreSessionTransactedFlag;
    }

    @Override
    protected void throwInvocationAfterClose(String methodName) throws Exception {
        String msg = "Connection is closed already - calling method " + methodName + " no longer allowed.";
        LOGGER.logWarning(this + ": " + msg);
        throw new IllegalStateException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTerminated() {
        List<Session> sessionsToCheck = this.cloneSessionsToAvoidDeadlock();
        ArrayList<Session> sessionsToRemove = new ArrayList<Session>();
        for (Session handle : sessionsToCheck) {
            AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)Proxy.getInvocationHandler(handle);
            if (!session.isAvailable()) continue;
            sessionsToRemove.add(handle);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": removing " + sessionsToRemove.size() + " session(s)...");
        }
        List<Session> list = this.sessions;
        synchronized (list) {
            for (Session s : sessionsToRemove) {
                Iterator<Session> pendingIt = this.sessions.iterator();
                while (pendingIt.hasNext()) {
                    Session pending = pendingIt.next();
                    if (pending != s) continue;
                    pendingIt.remove();
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": keeping " + this.sessions.size() + " sessions...");
        }
    }

    @Proxied
    public Session createSession(int sessionMode) throws JMSException {
        if (sessionMode == 0) {
            return this.createSession(true, 0);
        }
        return this.createSession(false, sessionMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Proxied
    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Session session = null;
        List<Session> list = this.sessions;
        synchronized (list) {
            if (this.closed) {
                throw new JMSException("Connection was closed already - creating new sessions is no longer allowed.");
            }
            if (this.createXaSession(transacted)) {
                session = this.recycleSession();
                if (session == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": creating XA-capable session...");
                    }
                    AtomikosJmsConnectionProxy.forceConnectionIntoXaMode((Connection)this.delegate);
                    XASession wrapped = ((XAConnection)this.delegate).createXASession();
                    session = AtomikosJmsXaSessionProxy.newInstance(wrapped, this.jmsTransactionalResource, this.owner, this);
                    this.addSession(session);
                }
            } else {
                CompositeTransaction ct = null;
                CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
                if (ctm != null) {
                    ct = ctm.getCompositeTransaction();
                }
                if (ct != null && TransactionManagerImp.isJtaTransaction(ct) && LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": creating NON-XA session - the resulting JMS work will NOT be part of the JTA transaction!");
                }
                Session wrapped = ((XAConnection)this.delegate).createSession(transacted, acknowledgeMode);
                session = AtomikosJmsNonXaSessionProxy.newInstance(wrapped, this.owner, this);
                this.addSession(session);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(Session session) {
        List<Session> list = this.sessions;
        synchronized (list) {
            this.sessions.add(session);
        }
    }

    private static void forceConnectionIntoXaMode(Connection c) {
        Session s = null;
        try {
            s = c.createSession(true, 1);
            s.rollback();
        }
        catch (Exception e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("JMS: driver complains while enforcing XA mode - ignore if no later errors:", e);
            }
        }
        finally {
            block14: {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (JMSException e) {
                        if (!LOGGER.isTraceEnabled()) break block14;
                        LOGGER.logTrace("JMS: driver complains while enforcing XA mode - ignore if no later errors:", e);
                    }
                }
            }
        }
    }

    private boolean createXaSession(boolean sessionTransactedFlag) {
        if (this.ignoreSessionTransactedFlag) {
            return !this.props.getLocalTransactionMode();
        }
        return sessionTransactedFlag && !this.props.getLocalTransactionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Session recycleSession() {
        CompositeTransactionManager tm = Configuration.getCompositeTransactionManager();
        if (tm == null) {
            return null;
        }
        CompositeTransaction current = tm.getCompositeTransaction();
        if (current != null && TransactionManagerImp.isJtaTransaction(current)) {
            List<Session> list = this.sessions;
            synchronized (list) {
                for (int i = 0; i < this.sessions.size(); ++i) {
                    Session session = this.sessions.get(i);
                    AbstractJmsSessionProxy proxy = (AbstractJmsSessionProxy)Proxy.getInvocationHandler(session);
                    if (!proxy.isInactiveTransaction(current) && !proxy.isInTransaction(current)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.logDebug(this + ": recycling session " + proxy);
                    }
                    proxy.recycle();
                    return session;
                }
            }
        }
        return null;
    }

    public boolean isErroneous() {
        boolean ret = this.erroneous;
        if (!ret) {
            List<Session> sessionsToCheck = this.cloneSessionsToAvoidDeadlock();
            Iterator<Session> it = sessionsToCheck.iterator();
            while (it.hasNext() && !ret) {
                Session handle = it.next();
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)Proxy.getInvocationHandler(handle);
                if (!session.isErroneous()) continue;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInTransaction(CompositeTransaction ct) {
        boolean ret = false;
        List<Session> list = this.sessions;
        synchronized (list) {
            Iterator<Session> it = this.sessions.iterator();
            while (it.hasNext() && !ret) {
                Session handle = it.next();
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)Proxy.getInvocationHandler(handle);
                if (!session.isInTransaction(ct)) continue;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInactiveInTransaction(CompositeTransaction ct) {
        if (!this.closed) {
            return false;
        }
        boolean ret = false;
        List<Session> list = this.sessions;
        synchronized (list) {
            Iterator<Session> it = this.sessions.iterator();
            while (it.hasNext() && !ret) {
                Session handle = it.next();
                AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)Proxy.getInvocationHandler(handle);
                if (!session.isInactiveTransaction(ct)) continue;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        boolean ret = false;
        List<Object> sessionsToCheck = new ArrayList();
        List<Session> list = this.sessions;
        synchronized (list) {
            if (this.closed) {
                ret = true;
                sessionsToCheck = this.cloneSessionsToAvoidDeadlock();
            }
        }
        Iterator it = sessionsToCheck.iterator();
        while (it.hasNext() && ret) {
            Object handle = it.next();
            AbstractJmsSessionProxy session = (AbstractJmsSessionProxy)Proxy.getInvocationHandler(handle);
            if (session.isAvailable()) continue;
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void destroy() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": closing connection and all " + this.sessions.size() + " session(s)");
        }
        List<Session> list = this.sessions;
        synchronized (list) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                Session session = this.sessions.get(i);
                try {
                    session.close();
                    continue;
                }
                catch (JMSException ex) {
                    LOGGER.logWarning(this + ": error closing session " + session, ex);
                }
            }
        }
        this.sessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Proxied
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": closing " + this.sessions.size() + " session(s)");
        }
        if (!this.closed) {
            List<Session> sessionsToClose;
            List<Session> list = this.sessions;
            synchronized (list) {
                this.markClosed();
                sessionsToClose = this.cloneSessionsToAvoidDeadlock();
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": closing " + sessionsToClose.size() + " session(s)");
            }
            for (int i = 0; i < sessionsToClose.size(); ++i) {
                Session session = sessionsToClose.get(i);
                try {
                    session.close();
                    continue;
                }
                catch (JMSException ex) {
                    LOGGER.logWarning(this + ": error closing session " + session, ex);
                }
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(this + ": is available ? " + this.isAvailable());
            }
            if (this.isAvailable()) {
                this.owner.onTerminated();
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": closed.");
        }
    }

    public static Connection newInstance(boolean ignoreSessionTransactedFlag, XAConnection xaConnection, XATransactionalResource jmsTransactionalResource, SessionHandleStateChangeListener sessionHandleStateChangeListener, ConnectionPoolProperties props) {
        AtomikosJmsConnectionProxy proxy = new AtomikosJmsConnectionProxy(xaConnection, ignoreSessionTransactedFlag, jmsTransactionalResource, sessionHandleStateChangeListener, props);
        return (Connection)proxy.createDynamicProxy();
    }

    @Override
    protected void handleInvocationException(Throwable e) throws Throwable {
        this.erroneous = true;
        throw e;
    }

    public String toString() {
        return "atomikosJmsConnectionProxy (isAvailable = " + this.isAvailable() + ")  for vendor instance " + this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Session> cloneSessionsToAvoidDeadlock() {
        ArrayList<Session> sessionsToReturn = null;
        List<Session> list = this.sessions;
        synchronized (list) {
            sessionsToReturn = new ArrayList<Session>(this.sessions);
        }
        return sessionsToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllPendingSessions() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": closing connection and all " + this.sessions.size() + " session(s)");
        }
        List<Session> sessionsToClose = this.cloneSessionsToAvoidDeadlock();
        for (Session session : sessionsToClose) {
            try {
                session.close();
            }
            catch (JMSException ex) {
                LOGGER.logWarning(this + ": error closing session " + session, ex);
            }
        }
        List<Session> list = this.sessions;
        synchronized (list) {
            this.sessions.removeAll(sessionsToClose);
        }
    }

    @Override
    protected Class<XAConnection> getRequiredInterfaceType() {
        return XAConnection.class;
    }
}

