/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.config.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TSListener;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.config.TSInitInfo;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.util.IOHelper;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class AbstractUserTransactionService
implements UserTransactionService {
    private TSInitInfo info_;

    private static void echoProperties(Properties properties) {
        Configuration.logInfo("USING core version: 3.6.4");
        if (properties != null) {
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = properties.getProperty(name);
                Configuration.logInfo("USING " + name + " = " + value);
            }
        }
    }

    public static String getTrimmedProperty(String name, Properties p) {
        String ret = null;
        ret = p.getProperty(name);
        if (ret != null) {
            ret = ret.trim();
        }
        return ret;
    }

    protected static String getDefaultName() {
        String ret = "tm";
        try {
            ret = InetAddress.getLocalHost().getHostAddress() + ".tm";
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ret;
    }

    protected static String getHostAddress() {
        String ret = "localhost";
        try {
            ret = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ret;
    }

    protected static String findOrCreateFolder(String path) {
        String result;
        File ret = new File(".");
        if (path != null) {
            File tmp = new File(path);
            if (tmp.exists()) {
                if (tmp.isDirectory()) {
                    ret = tmp;
                } else {
                    String msg = path + " is not a directory - using default";
                    System.err.println(msg);
                }
            } else {
                String msg = path + " could not be created - using default";
                try {
                    if (IOHelper.createPathTo((File)tmp, (boolean)true)) {
                        ret = tmp;
                    } else {
                        System.err.println(msg);
                    }
                }
                catch (IOException e) {
                    System.err.println(msg);
                }
            }
        }
        if (!(result = ret.getAbsolutePath()).endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    public void shutdown(boolean force) throws IllegalStateException {
        boolean errors = false;
        Configuration.removeShutdownHooks();
        Enumeration resources = Configuration.getResources();
        while (resources.hasMoreElements()) {
            RecoverableResource res = (RecoverableResource)resources.nextElement();
            Configuration.removeResource(res.getName());
            try {
                res.close();
            }
            catch (ResourceException re) {
                if (!force) {
                    String msg = "WARNING: error closing resource: " + re.getMessage();
                    System.err.println(msg);
                    re.printStackTrace();
                }
                errors = true;
            }
        }
        Configuration.removeConsoles();
        Enumeration logAdmins = Configuration.getLogAdministrators();
        while (logAdmins.hasMoreElements()) {
            LogAdministrator admin = (LogAdministrator)logAdmins.nextElement();
            Configuration.removeLogAdministrator(admin);
        }
        Configuration.installCompositeTransactionManager(null);
        Configuration.installExportingTransactionManager(null);
        Configuration.installImportingTransactionManager(null);
        Configuration.installRecoveryService(null);
        Configuration.installTransactionService(null);
        Configuration.installLogControl(null);
        if (errors && !force) {
            throw new RuntimeException("Error(s) during shutdown.");
        }
    }

    public void init(TSInitInfo info) throws SysException {
        this.info_ = info;
        AbstractUserTransactionService.echoProperties(info.getProperties());
        String hookAsString = AbstractUserTransactionService.getTrimmedProperty("com.atomikos.icatch.force_shutdown_on_vm_exit", info.getProperties());
        boolean register = false;
        if (hookAsString != null) {
            register = "true".equals(hookAsString.toLowerCase());
        }
        if (register) {
            Configuration.addShutdownHook(new ShutdownHook(this));
        }
    }

    public CompositeTransactionManager getCompositeTransactionManager() {
        return Configuration.getCompositeTransactionManager();
    }

    public ImportingTransactionManager getImportingTransactionManager() {
        return Configuration.getImportingTransactionManager();
    }

    public ExportingTransactionManager getExportingTransactionManager() {
        return Configuration.getExportingTransactionManager();
    }

    public void registerResource(RecoverableResource res) {
        Configuration.addResource(res);
    }

    public void registerLogAdministrator(LogAdministrator admin) {
        Configuration.addLogAdministrator(admin);
    }

    public Enumeration getResources() {
        return Configuration.getResources();
    }

    public Enumeration getLogAdministrators() {
        return Configuration.getLogAdministrators();
    }

    public void removeResource(RecoverableResource res) {
        if (res == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.removeResource(res.getName());
    }

    public void removeLogAdministrator(LogAdministrator admin) {
        if (admin == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.removeLogAdministrator(admin);
    }

    public void registerTSListener(TSListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.addTSListener(listener);
    }

    public void removeTSListener(TSListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null not allowed");
        }
        Configuration.removeTSListener(listener);
    }

    public void init(Properties properties) throws SysException {
        TSInitInfo info = this.createTSInitInfo();
        info.setProperties(properties);
        this.init(info);
    }

    private static class ShutdownHook
    extends Thread {
        private UserTransactionService uts_;

        private ShutdownHook(UserTransactionService uts) {
            this.uts_ = uts;
        }

        public void run() {
            this.uts_.shutdown(true);
        }
    }
}

