/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.imp.PropagationMessage;
import com.atomikos.icatch.imp.thread.TaskManager;
import com.atomikos.icatch.system.Configuration;

class Propagator {
    static long RETRY_INTERVAL = 10000L;
    private boolean threaded_ = true;

    Propagator(boolean threaded) {
        this.threaded_ = threaded;
    }

    public synchronized void submitPropagationMessage(PropagationMessage msg) {
        PropagatorThread t = new PropagatorThread(msg);
        if (this.threaded_) {
            TaskManager.getInstance().executeTask(t);
        } else {
            t.run();
        }
    }

    private static class PropagatorThread
    implements Runnable {
        private PropagationMessage msg;

        PropagatorThread(PropagationMessage msg) {
            this.msg = msg;
        }

        public void run() {
            try {
                boolean tryAgain = true;
                do {
                    if (!(tryAgain = this.msg.submit())) continue;
                    Thread.sleep(RETRY_INTERVAL);
                    if (!Configuration.isDebugLoggingEnabled()) continue;
                    Configuration.logDebug("Propagator: retrying message: " + this.msg);
                } while (tryAgain);
            }
            catch (Exception e) {
                Configuration.logWarning("ERROR in propagator: " + e.getMessage() + (this.msg != null ? " while sending message: " + this.msg : ""), e);
            }
        }
    }
}

