/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp.thread;

import com.atomikos.icatch.imp.thread.ExecutorFactory;
import com.atomikos.icatch.imp.thread.InternalSystemExecutor;
import com.atomikos.icatch.imp.thread.ThreadFactory;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class Java15ExecutorFactory
implements ExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.createLogger(Java15ExecutorFactory.class);
    public static final String MAIN_CLASS = "java.util.concurrent.ThreadPoolExecutor";
    public static final String IQUEUE_CLASS = "java.util.concurrent.BlockingQueue";
    public static final String QUEUE_CLASS = "java.util.concurrent.SynchronousQueue";
    public static final String TIMEUNIT_CLASS = "java.util.concurrent.TimeUnit";
    public static final String IFACTORY_CLASS = "java.util.concurrent.ThreadFactory";
    private Class mainClass;
    private Constructor constructor;
    private Method submit;
    private Method shutdown;

    protected Java15ExecutorFactory() throws Exception {
        this.checkInit();
    }

    public InternalSystemExecutor createExecutor() throws Exception {
        Object[] params = this.toConstructionParameters();
        return new Executor(this.constructor.newInstance(params), this.submit, this.shutdown);
    }

    protected Object[] toConstructionParameters() throws Exception {
        ClassLoader loader = this.getClass().getClassLoader();
        Object factory = Proxy.newProxyInstance(loader, new Class[]{this.loadClass(IFACTORY_CLASS)}, (InvocationHandler)new FactoryProxy());
        Object queue = this.loadClass(QUEUE_CLASS).newInstance();
        return new Object[]{new Integer(0), new Integer(Integer.MAX_VALUE), new Long(60L), this.getSecondTimeUnit(), queue, factory};
    }

    protected Constructor extractConstructor(Class poolClass) throws Exception {
        return poolClass.getConstructor(Integer.TYPE, Integer.TYPE, Long.TYPE, this.loadClass(TIMEUNIT_CLASS), this.loadClass(IQUEUE_CLASS), this.loadClass(IFACTORY_CLASS));
    }

    protected Class loadClass(String name) throws Exception {
        Class cl = null;
        cl = this.safeLoad(name);
        if (cl == null) {
            cl = this.safeContextLoad(name);
        }
        if (cl == null) {
            throw new ClassNotFoundException("Class '" + name + "' not found");
        }
        return cl;
    }

    protected Class loadMainPoolClass() throws Exception {
        return this.loadClass(MAIN_CLASS);
    }

    protected Method extractSubmitMethod(Class poolClass) throws Exception {
        return poolClass.getMethod("execute", Runnable.class);
    }

    protected Method extractShutdownMethod(Class poolClass) throws Exception {
        return poolClass.getMethod("shutdown", new Class[0]);
    }

    private Class safeLoad(String name) {
        try {
            return ClassLoadingHelper.loadClass((String)name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Class safeContextLoad(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return loader == null ? null : loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Object getSecondTimeUnit() throws Exception {
        Class cl = this.loadClass(TIMEUNIT_CLASS);
        Class<?> classClass = cl.getClass();
        Method m = classClass.getMethod("getEnumConstants", null);
        Object o = m.invoke((Object)cl, null);
        int len = Array.getLength(o);
        for (int i = 0; i < len; ++i) {
            Object test = Array.get(o, i);
            if (!test.toString().equals("SECONDS")) continue;
            return test;
        }
        return null;
    }

    private synchronized void checkInit() throws Exception {
        if (this.mainClass != null) {
            return;
        }
        this.mainClass = this.loadMainPoolClass();
        this.constructor = this.extractConstructor(this.mainClass);
        this.submit = this.extractSubmitMethod(this.mainClass);
        this.shutdown = this.extractShutdownMethod(this.mainClass);
    }

    protected static final class FactoryProxy
    implements InvocationHandler {
        protected FactoryProxy() {
        }

        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return ThreadFactory.getInstance().newThread((Runnable)args[0]);
        }
    }

    private static final class Executor
    implements InternalSystemExecutor {
        private final Method submit;
        private final Method shutdown;
        private final Object target;

        private Executor(Object target, Method submit, Method shutdown) {
            this.target = target;
            this.submit = submit;
            this.shutdown = shutdown;
        }

        public void shutdown() {
            try {
                this.shutdown.invoke(this.target, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.logWarning("Failed to shutdown 1.5 concurrent thread pool", (Throwable)e);
            }
        }

        public void execute(Runnable task) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug("(1.5) executing task: " + task);
                }
                this.submit.invoke(this.target, task);
            }
            catch (Exception e) {
                LOGGER.logWarning("Failed to invoke 1.5 concurrent thread pool", (Throwable)e);
            }
        }
    }
}

