/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class TerminationResult
extends Result {
    protected boolean allRepliesProcessed = false;
    protected Hashtable<Participant, TxState> heuristicparticipants_ = new Hashtable();
    protected Hashtable<Participant, TxState> possiblyIndoubts_ = new Hashtable();

    public TerminationResult(int numberOfRepliesToWaitFor) {
        super(numberOfRepliesToWaitFor);
    }

    public Hashtable<Participant, TxState> getHeuristicParticipants() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        return this.heuristicparticipants_;
    }

    public Hashtable<Participant, TxState> getPossiblyIndoubts() throws IllegalStateException, InterruptedException {
        this.calculateResultFromAllReplies();
        return this.possiblyIndoubts_;
    }

    @Override
    protected synchronized void calculateResultFromAllReplies() throws IllegalStateException, InterruptedException {
        if (this.allRepliesProcessed) {
            return;
        }
        boolean atLeastOneHeuristicMixedException = false;
        boolean atLeastOneHeuristicRollbackException = false;
        boolean atLeastOneHeuristicCommitException = false;
        boolean atLeastOneHeuristicHazardException = false;
        boolean noFailedReplies = true;
        boolean onePhaseCommitWithRollbackException = false;
        Stack<Reply> replies = this.getReplies();
        Enumeration enumm = replies.elements();
        while (enumm.hasMoreElements()) {
            Reply reply = (Reply)enumm.nextElement();
            if (reply.hasFailed()) {
                noFailedReplies = false;
                Exception err = reply.getException();
                if (err instanceof RollbackException) {
                    onePhaseCommitWithRollbackException = true;
                    continue;
                }
                if (err instanceof HeurMixedException) {
                    atLeastOneHeuristicMixedException = true;
                    HeurMixedException hm = (HeurMixedException)((Object)err);
                    this.addErrorMessages(hm.getHeuristicMessages());
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_MIXED);
                    continue;
                }
                if (err instanceof HeurCommitException) {
                    atLeastOneHeuristicCommitException = true;
                    HeurCommitException hc = (HeurCommitException)((Object)err);
                    this.addErrorMessages(hc.getHeuristicMessages());
                    atLeastOneHeuristicMixedException = atLeastOneHeuristicMixedException || atLeastOneHeuristicRollbackException || atLeastOneHeuristicHazardException;
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_COMMITTED);
                    continue;
                }
                if (err instanceof HeurRollbackException) {
                    atLeastOneHeuristicRollbackException = true;
                    atLeastOneHeuristicMixedException = atLeastOneHeuristicMixedException || atLeastOneHeuristicCommitException || atLeastOneHeuristicHazardException;
                    HeurRollbackException hr = (HeurRollbackException)((Object)err);
                    this.addErrorMessages(hr.getHeuristicMessages());
                    this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_ABORTED);
                    continue;
                }
                atLeastOneHeuristicHazardException = true;
                atLeastOneHeuristicMixedException = atLeastOneHeuristicMixedException || atLeastOneHeuristicRollbackException || atLeastOneHeuristicCommitException;
                StringHeuristicMessage heurmsg = new StringHeuristicMessage("No commit ACK from participant " + reply.getParticipant());
                this.heuristicMessagesOfHeuristicParticipants_.addElement(heurmsg);
                this.heuristicparticipants_.put(reply.getParticipant(), TxState.HEUR_HAZARD);
                this.possiblyIndoubts_.put(reply.getParticipant(), TxState.HEUR_HAZARD);
                continue;
            }
            HeuristicMessage[] msgs = (HeuristicMessage[])reply.getResponse();
            if (msgs == null) continue;
            this.addMessages(msgs);
        }
        if (onePhaseCommitWithRollbackException) {
            this.result_ = 6;
        } else if (atLeastOneHeuristicMixedException || atLeastOneHeuristicRollbackException && this.heuristicparticipants_.size() != replies.size() || atLeastOneHeuristicCommitException && this.heuristicparticipants_.size() != replies.size()) {
            this.result_ = 2;
        } else if (atLeastOneHeuristicHazardException) {
            this.result_ = 1;
        } else if (atLeastOneHeuristicRollbackException) {
            this.result_ = 3;
        } else if (atLeastOneHeuristicCommitException) {
            this.result_ = 4;
        } else if (noFailedReplies) {
            this.result_ = 0;
        }
        this.allRepliesProcessed = true;
    }
}

