/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.imp;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.persistence.imp.LogFileLock;
import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.LogWriteException;
import com.atomikos.recovery.Repository;
import com.atomikos.recovery.imp.Deserializer;
import com.atomikos.recovery.imp.Serializer;
import com.atomikos.util.VersionedFile;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;

public class FileSystemRepository
implements Repository {
    private static final Logger LOGGER = LoggerFactory.createLogger(FileSystemRepository.class);
    private VersionedFile file;
    private FileChannel rwChannel = null;
    private LogFileLock lock_;
    private Serializer serializer = new Serializer();
    private Deserializer deserializer = new Deserializer();

    public void init() throws LogException {
        ConfigProperties configProperties = Configuration.getConfigProperties();
        String baseDir = configProperties.getLogBaseDir();
        String baseName = configProperties.getLogBaseName();
        LOGGER.logDebug("baseDir " + baseDir);
        LOGGER.logDebug("baseName " + baseName);
        this.lock_ = new LogFileLock(baseDir, baseName);
        LOGGER.logDebug("LogFileLock " + this.lock_);
        this.lock_.acquireLock();
        this.file = new VersionedFile(baseDir, baseName, ".log");
    }

    public void put(String id, CoordinatorLogEntry coordinatorLogEntry) throws LogWriteException {
        try {
            this.initChannelIfNecessary();
            this.write(coordinatorLogEntry, true);
        }
        catch (IOException e) {
            throw new LogWriteException((Throwable)e);
        }
    }

    private synchronized void initChannelIfNecessary() throws FileNotFoundException {
        if (this.rwChannel == null) {
            this.rwChannel = this.file.openNewVersionForNioWriting();
        }
    }

    private void write(CoordinatorLogEntry coordinatorLogEntry, boolean flushImmediately) throws IOException {
        String str = this.serializer.toJSON(coordinatorLogEntry);
        byte[] buffer = str.getBytes();
        ByteBuffer buff = ByteBuffer.wrap(buffer);
        this.writeToFile(buff, coordinatorLogEntry.shouldSync() && flushImmediately);
    }

    private synchronized void writeToFile(ByteBuffer buff, boolean force) throws IOException {
        this.rwChannel.write(buff);
        if (force) {
            this.rwChannel.force(false);
        }
    }

    public CoordinatorLogEntry get(String coordinatorId) {
        throw new UnsupportedOperationException();
    }

    public Collection<CoordinatorLogEntry> findAllCommittingCoordinatorLogEntries() {
        throw new UnsupportedOperationException();
    }

    public Collection<CoordinatorLogEntry> getAllCoordinatorLogEntries() throws LogReadException {
        HashMap<String, CoordinatorLogEntry> coordinatorLogEntries = new HashMap<String, CoordinatorLogEntry>();
        FileInputStream fis = null;
        try {
            String line;
            fis = this.file.openLastValidVersionForReading();
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                CoordinatorLogEntry coordinatorLogEntry = this.deserialize(line);
                coordinatorLogEntries.put(coordinatorLogEntry.id, coordinatorLogEntry);
            }
            br.close();
        }
        catch (EOFException unexpectedEOF) {
            LOGGER.logTrace("Unexpected EOF - logfile not closed properly last time?", (Throwable)unexpectedEOF);
        }
        catch (StreamCorruptedException unexpectedEOF) {
            LOGGER.logTrace("Unexpected EOF - logfile not closed properly last time?", (Throwable)unexpectedEOF);
        }
        catch (ObjectStreamException unexpectedEOF) {
            LOGGER.logTrace("Unexpected EOF - logfile not closed properly last time?", (Throwable)unexpectedEOF);
        }
        catch (FileNotFoundException firstStart) {
        }
        catch (Exception e) {
            LOGGER.logFatal("Error in recover", (Throwable)e);
            throw new LogReadException((Throwable)e);
        }
        finally {
            this.closeSilently(fis);
        }
        return coordinatorLogEntries.values();
    }

    private void closeSilently(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException io) {
            LOGGER.logWarning("Fail to close logfile after reading - ignoring");
        }
    }

    private CoordinatorLogEntry deserialize(String line) {
        return this.deserializer.fromJSON(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.closeOutput();
        }
        catch (Exception e) {
            LOGGER.logWarning("Error closing file - ignoring", (Throwable)e);
        }
        finally {
            this.lock_.releaseLock();
        }
    }

    protected void closeOutput() throws IllegalStateException {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error closing previous output", e);
        }
    }

    public synchronized void writeCheckpoint(Collection<CoordinatorLogEntry> checkpointContent) throws LogWriteException {
        try {
            this.closeOutput();
            this.rwChannel = this.file.openNewVersionForNioWriting();
            for (CoordinatorLogEntry coordinatorLogEntry : checkpointContent) {
                this.write(coordinatorLogEntry, false);
            }
            this.rwChannel.force(false);
            this.file.discardBackupVersion();
        }
        catch (FileNotFoundException firstStart) {
        }
        catch (Exception e) {
            LOGGER.logFatal("Failed to write checkpoint", (Throwable)e);
            throw new LogWriteException((Throwable)e);
        }
    }
}

