/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2ClientIntf;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.RequestFacade;
import com.att.aft.dme2.api.RequestValidator;
import com.att.aft.dme2.api.util.DME2FileUploadInfo;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.handler.DefaultAsyncResponseHandler;
import com.att.aft.dme2.internal.apache.commons.collections.MapUtils;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.ContextFactory;
import com.att.aft.dme2.request.DME2Payload;
import com.att.aft.dme2.request.DME2TextPayload;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.request.FilePayload;
import com.att.aft.dme2.request.HttpRequest;
import com.att.aft.dme2.request.Request;
import com.att.aft.dme2.request.RequestContext;
import com.att.aft.dme2.util.DME2GRMJVMRegistration;
import com.att.aft.dme2.util.DME2UrlStreamHandler;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.DME2ValidationUtil;
import com.att.aft.dme2.util.ErrorContext;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DME2Client
implements DME2ClientIntf {
    RequestContext requestContext = null;
    RequestFacade requestFacade = null;
    private static final Logger logger = LoggerFactory.getLogger(DME2Client.class.getName());
    Request request = null;
    private String context = null;
    private String subContext = null;
    private boolean returnResponseAsBytes = false;
    private String payload;
    private DME2Manager manager;
    private URI newUri;
    private long perEndpointTimeoutMs;
    private String charset;
    private String method;
    private Map<String, String> headers = null;
    private String contentType;
    private DME2Payload dme2Payload = null;
    private String queryParams;
    private String username;
    private String password;
    private AsyncResponseHandlerIntf asyncResponseHandlerIntf;
    private static final String AFT_DME2_0605 = "AFT-DME2-0605";

    public DME2Client(DME2Manager mgr, Request request) throws DME2Exception, MalformedURLException {
        logger.debug(null, "DME2Client", "DME2 URI:" + request.getLookupUri());
        this.validateAndInitialize(mgr, request);
    }

    private void validateAndInitialize(DME2Manager mgr, Request request) throws DME2Exception, MalformedURLException {
        logger.debug(null, "validateAndInitialize", LogMessage.METHOD_ENTER);
        RequestValidator.validate(mgr);
        RequestValidator.validate(mgr.getConfig(), request);
        ContextFactory contextFactory = ContextFactory.getInstance();
        this.requestContext = contextFactory.createContext(mgr, request);
        this.requestFacade = contextFactory.createFacade(this.requestContext);
        DME2GRMJVMRegistration.getInstance(mgr, request.getUniformResource());
        logger.debug(null, "validateAndInitialize", LogMessage.METHOD_EXIT);
    }

    @Override
    public void send(DME2Payload payload) throws DME2Exception {
        this.requestFacade.send(payload);
    }

    @Override
    public Object sendAndWait(DME2Payload payload) throws DME2Exception {
        AsyncResponseHandlerIntf responseHandler = null;
        if (this.requestContext.getRequest().getResponseHandler() == null) {
            responseHandler = new DefaultAsyncResponseHandler(this.requestContext.getMgr().getConfig(), this.requestContext.getUniformResource().getService(), false);
            this.requestContext.getRequest().setResponseHandler(responseHandler);
        } else {
            responseHandler = this.requestContext.getRequest().getResponseHandler();
        }
        this.send(payload);
        try {
            return responseHandler.getResponse(this.requestContext.getRequest().getReadTimeout());
        }
        catch (Exception e) {
            DME2Exception ex = new DME2Exception("AFT-DME2-0707", e);
            logger.error(this.requestContext.getLogContext().getConversationId(), null, "AFT-DME2-0707", ex.getErrorMessage());
            throw ex;
        }
    }

    public void setResponseHandlers(AsyncResponseHandlerIntf responseHandler) {
        this.requestContext.getRequest().setResponseHandler(responseHandler);
    }

    @Override
    public void stop() throws DME2Exception {
    }

    public DME2Client(URI newUri, long perEndpointTimeoutMs) throws DME2Exception {
        this(null, newUri, perEndpointTimeoutMs, null, false);
    }

    public DME2Client(URI newUri) throws DME2Exception {
        this(null, newUri, -1L, null, false);
    }

    public DME2Client(DME2Manager manager, URI newUri, long perEndpointTimeoutMs) throws DME2Exception {
        this(manager, newUri, perEndpointTimeoutMs, null, false);
    }

    public DME2Client(DME2Manager manager, URI newUri) throws DME2Exception {
        this(manager, newUri, -1L, null, false);
    }

    public DME2Client(DME2Manager manager, URI newUri, long perEndpointTimeoutMs, String charset) throws DME2Exception {
        this(manager, newUri, perEndpointTimeoutMs, charset, false);
    }

    public DME2Client(DME2Manager manager, URI newUri, String charset) throws DME2Exception {
        this(manager, newUri, -1L, charset, false);
    }

    public DME2Client(DME2Manager manager, URI newUri, String charset, boolean returnResponseAsBytes) throws DME2Exception {
        this(manager, newUri, -1L, charset, returnResponseAsBytes);
    }

    public DME2Client(DME2Manager manager, URI newUri, long perEndpointTimeoutMs, String charset, boolean returnResponseAsBytes) throws DME2Exception {
        if (newUri != null) {
            logger.debug(null, "DME2Client", "DME2 URI:" + newUri.toString());
        }
        if (manager == null) {
            manager = DME2Manager.getDefaultInstance();
        }
        if (newUri == null) {
            throw new DME2Exception(AFT_DME2_0605, new ErrorContext().add("extendedMessage", "uri=null"));
        }
        if (perEndpointTimeoutMs < 1L) {
            perEndpointTimeoutMs = manager.getConfig().getLong("AFT_DME2_EP_READ_TIMEOUT_MS", 240000L);
        }
        this.manager = manager;
        this.newUri = newUri;
        this.perEndpointTimeoutMs = perEndpointTimeoutMs;
        this.charset = charset;
        this.returnResponseAsBytes = returnResponseAsBytes;
        try {
            DME2GRMJVMRegistration.getInstance(manager, new DmeUniformResource(manager.getConfig(), this.uriToURL(newUri)));
        }
        catch (MalformedURLException e) {
            throw new DME2Exception("AFT-DME2-0707", e);
        }
    }

    public DME2Client(DME2Manager manager, URI uri, String charset, boolean returnResponseAsBytes, boolean isEncoded) throws DME2Exception {
        this(manager, uri, -1L, charset, returnResponseAsBytes, isEncoded);
    }

    public DME2Client(DME2Manager manager, URI uri, long perEndpointTimeoutMs, String charset, boolean returnResponseAsBytes, boolean isEncoded) throws DME2Exception {
        try {
            if (this.newUri == null) {
                throw new DME2Exception(AFT_DME2_0605, new ErrorContext().add("extendedMessage", "uri=null"));
            }
            logger.debug(null, "DME2Client", "DME2 URI:" + this.newUri.toString());
            if (perEndpointTimeoutMs < 1L) {
                perEndpointTimeoutMs = manager.getConfig().getLong("AFT_DME2_EP_READ_TIMEOUT_MS", 240000L);
            }
            String encodedStr = DME2Utils.encodeURIString(uri.toString().trim(), isEncoded);
            URI encodedURI = new URI(encodedStr);
            URL encodedURL = this.uriToURL(encodedURI);
            DME2ValidationUtil.validateServiceStringIsNonJDBCURL(encodedURL.toString());
            this.manager = manager;
            this.newUri = encodedURI;
            this.perEndpointTimeoutMs = perEndpointTimeoutMs;
            this.charset = charset;
            this.returnResponseAsBytes = returnResponseAsBytes;
            DME2GRMJVMRegistration.getInstance(manager, new DmeUniformResource(manager.getConfig(), this.uriToURL(uri)));
        }
        catch (Exception e) {
            if (!(e instanceof DME2Exception)) {
                throw new DME2Exception("AFT-DME2-0607", new ErrorContext().add("extendedMessage", e.getMessage()).add("URL", uri.toString()), (Throwable)e);
            }
            throw (DME2Exception)e;
        }
    }

    public DME2Client(DME2Manager manager, URL url, String charset, boolean returnResponseAsBytes, boolean isEncoded) throws DME2Exception {
        this(manager, url, -1L, charset, returnResponseAsBytes, isEncoded);
    }

    public DME2Client(DME2Manager manager, URL url, long perEndpointTimeoutMs, String charset, boolean returnResponseAsBytes, boolean isEncoded) throws DME2Exception {
        try {
            if (this.newUri == null) {
                throw new DME2Exception(AFT_DME2_0605, new ErrorContext().add("extendedMessage", "uri=null"));
            }
            logger.debug(null, "DME2Client", "DME2 URI:" + this.newUri.toString());
            if (perEndpointTimeoutMs < 1L) {
                perEndpointTimeoutMs = manager.getConfig().getLong("AFT_DME2_EP_READ_TIMEOUT_MS", 240000L);
            }
            String encodedStr = DME2Utils.encodeURIString(url.toString().trim(), isEncoded);
            URI encodedURI = new URI(encodedStr);
            URL encodedURL = this.uriToURL(encodedURI);
            DME2ValidationUtil.validateServiceStringIsNonJDBCURL(encodedURL.toString());
            this.manager = manager;
            this.newUri = encodedURI;
            this.perEndpointTimeoutMs = perEndpointTimeoutMs;
            this.charset = charset;
            this.returnResponseAsBytes = returnResponseAsBytes;
            DME2GRMJVMRegistration.getInstance(manager, this.request.getUniformResource());
        }
        catch (Exception e) {
            if (!(e instanceof DME2Exception)) {
                throw new DME2Exception("AFT-DME2-0607", new ErrorContext().add("extendedMessage", e.getMessage()).add("URL", url.toString()), (Throwable)e);
            }
            throw (DME2Exception)e;
        }
    }

    private URL uriToURL(URI uri) throws MalformedURLException {
        return new URL(uri.getScheme(), uri.getHost(), uri.getPort(), DME2Utils.appendQueryStringToPath(uri.getPath(), uri.getQuery()), new DME2UrlStreamHandler());
    }

    public String sendAndWait(long timeoutMs) throws Exception {
        this.buildRequest();
        this.request.setReadTimeout(timeoutMs);
        this.validateAndInitialize(this.manager, this.request);
        if (this.dme2Payload == null) {
            this.dme2Payload = new DME2TextPayload(this.payload);
        }
        return (String)this.sendAndWait(this.dme2Payload);
    }

    public void send() throws DME2Exception {
        this.buildRequest();
        try {
            this.validateAndInitialize(this.manager, this.request);
        }
        catch (MalformedURLException e) {
            DME2Exception ex = new DME2Exception("AFT-DME2-0707", e);
            logger.error(this.requestContext.getLogContext().getConversationId(), null, "AFT-DME2-0707", ex.getErrorMessage());
            throw ex;
        }
        if (this.dme2Payload == null) {
            this.dme2Payload = new DME2TextPayload(this.payload);
        }
        this.send(this.dme2Payload);
    }

    private void buildRequest() throws DME2Exception {
        this.request = ((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)new HttpRequest.RequestBuilder(this.newUri).withLookupURL(this.newUri.toString().trim())).withHttpMethod(this.method).withContext(this.context)).withSubContext(this.subContext)).withHeaders(this.headers).withQueryParams(this.queryParams)).withPerEndpointTimeoutMs(this.perEndpointTimeoutMs).withCharset(this.charset)).withReturnResponseAsBytes(this.returnResponseAsBytes)).withResponseHandlers(this.asyncResponseHandlerIntf)).withAuthCreds(this.manager.getRealm(), this.username, this.password)).build();
    }

    public void setHeaders(Map<String, String> inHeaders) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        if (MapUtils.isNotEmpty(inHeaders)) {
            for (String header : inHeaders.keySet()) {
                this.headers.put(header, inHeaders.get(header));
            }
        }
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setPayload(String payload, String contentType) {
        this.payload = payload;
        this.contentType = contentType;
    }

    public void setDME2Payload(DME2Payload payload) {
        this.dme2Payload = payload;
    }

    public void setUploadFile(String file) {
        this.dme2Payload = new FilePayload(file, false, false);
    }

    public void setUploadFileWithMultiPart(String fileName, boolean isFileTypeBinary) {
        this.dme2Payload = new FilePayload(fileName, true, isFileTypeBinary);
    }

    public void setUploadFileWithMultiPart(String fileName, boolean isFileTypeBinary, String multipartName) {
        this.dme2Payload = new FilePayload(fileName, true, isFileTypeBinary, multipartName);
    }

    public void setUploadFileWithMultiPart(List<DME2FileUploadInfo> files, boolean isFileTypeBinary) {
        ArrayList<String> filesUploadList = new ArrayList<String>();
        for (DME2FileUploadInfo file : files) {
            filesUploadList.add(file.getFilepath() + file.getFileName());
        }
        this.dme2Payload = new FilePayload(filesUploadList, true, isFileTypeBinary);
    }

    public void setUploadFileWithMultiPart(DME2FileUploadInfo file, boolean isFileTypeBinary) {
        ArrayList<String> filesUploadList = new ArrayList<String>();
        filesUploadList.add(file.getFilepath() + file.getFileName());
        this.dme2Payload = new FilePayload(filesUploadList, true, isFileTypeBinary);
    }

    public void setQueryParams(String queryParams) {
        this.queryParams = queryParams;
    }

    public void setQueryParams(Map<String, String> mapParams, boolean encode) {
        if (mapParams == null || mapParams.size() == 0) {
            this.queryParams = "";
            return;
        }
        StringBuffer sb = new StringBuffer(mapParams.size() * 2);
        sb.append("?");
        for (Map.Entry<String, String> e : mapParams.entrySet()) {
            try {
                sb.append(e.getKey()).append("=").append(encode ? URLEncoder.encode(e.getValue() != null ? e.getValue() : "", Charset.forName("UTF-8").name()) : (e.getValue() != null ? e.getValue() : "")).append("&");
            }
            catch (UnsupportedEncodingException uee) {
                logger.error("", null, "setQueryParams", uee.getMessage());
                throw new RuntimeException("Could not encode parameter: " + e.toString(), uee);
            }
        }
        this.queryParams = sb.toString();
    }

    public String getQueryParams() {
        return this.queryParams;
    }

    public void setSubContext(String subContext) {
        this.subContext = subContext;
    }

    @Deprecated
    public void setUrlQueryParams(String queryParams) {
        this.queryParams = queryParams;
    }

    @Deprecated
    public void setUrlQueryParams(Map<String, String> mapParams, boolean encode) {
        if (mapParams == null || mapParams.size() == 0) {
            this.queryParams = "";
            return;
        }
        StringBuffer sb = new StringBuffer(mapParams.size() * 2);
        sb.append("?");
        for (Map.Entry<String, String> e : mapParams.entrySet()) {
            try {
                sb.append(e.getKey()).append("=").append(encode ? URLEncoder.encode(e.getValue() != null ? e.getValue() : "", Charset.forName("UTF-8").name()) : (e.getValue() != null ? e.getValue() : "")).append("&");
            }
            catch (UnsupportedEncodingException uee) {
                logger.error("", null, "setQueryParams", uee.getMessage());
                throw new RuntimeException("Could not encode parameter: " + e.toString(), uee);
            }
        }
        this.queryParams = sb.toString();
    }

    @Deprecated
    public void setUrlContextPath(String urlContextPath) {
        this.context = urlContextPath;
    }

    public void setAllowAllHttpReturnCodes(Boolean allow) {
        if (allow.booleanValue()) {
            this.addHeader("AFT_DME2_ALLOW_ALL_HTTP_RETURN_CODES", "true");
        } else {
            this.addHeader("AFT_DME2_ALLOW_ALL_HTTP_RETURN_CODES", "false");
        }
    }

    public void setReplyHandler(AsyncResponseHandlerIntf replyHandler) {
        this.asyncResponseHandlerIntf = replyHandler;
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }
}

