/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.request.DME2Payload;
import com.att.aft.dme2.request.Request;
import com.att.aft.dme2.util.DME2Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DME2ClientSpringImpl {
    private DME2Manager manager;
    private Properties props;
    private Properties jvmprops;
    private String dme2uri;
    private long perEndpointTimeoutMs;
    private String charset;
    private boolean returnResponseAsBytes;
    private boolean isEncoded;
    private String method;
    private DME2Client dme2Client;
    private DME2Payload dme2Payload;
    private String queryParamsString;
    private Map<String, String> queryParamsMap;
    private boolean queryParamsMapEncode;
    private Map<String, String> headers;
    private String username;
    private String password;
    private String context;
    private String subcontext;
    private AsyncResponseHandlerIntf asyncResponseHandlerIntf;

    public DME2Client getDME2Client() throws DME2Exception, URISyntaxException {
        if (this.jvmprops != null) {
            for (Object key : this.jvmprops.keySet()) {
                System.setProperty((String)key, this.jvmprops.getProperty((String)key));
            }
        }
        if (this.isEncoded) {
            this.dme2uri = DME2Utils.encodeURIString(this.dme2uri.trim(), this.isEncoded);
        }
        this.manager = DME2Manager.getDefaultInstance();
        if (this.props != null) {
            for (Object key : this.props.keySet()) {
                this.manager.setProperty((String)key, this.props.getProperty((String)key));
            }
        }
        this.dme2Client = new DME2Client(this.manager, new URI(this.dme2uri), this.perEndpointTimeoutMs, this.charset, this.returnResponseAsBytes);
        if (this.method != null) {
            this.dme2Client.setMethod(this.method);
        }
        if (this.dme2Payload != null) {
            this.dme2Client.setDME2Payload(this.dme2Payload);
        }
        if (this.queryParamsString != null) {
            this.dme2Client.setQueryParams(this.queryParamsString);
        }
        if (this.queryParamsMap != null) {
            this.dme2Client.setQueryParams(this.queryParamsMap, this.queryParamsMapEncode);
        }
        this.dme2Client.setHeaders(this.headers);
        if (this.username != null || this.password != null) {
            this.dme2Client.setCredentials(this.username, this.password);
        }
        if (this.asyncResponseHandlerIntf != null) {
            this.dme2Client.setReplyHandler(this.asyncResponseHandlerIntf);
        }
        return this.dme2Client;
    }

    public DME2Client getDME2Client(Request request) throws DME2Exception, MalformedURLException {
        for (Object key : this.jvmprops.keySet()) {
            System.setProperty((String)key, this.jvmprops.getProperty((String)key));
        }
        this.manager = DME2Manager.getDefaultInstance();
        if (this.props != null) {
            for (Object key : this.props.keySet()) {
                this.manager.setProperty((String)key, this.props.getProperty((String)key));
            }
        }
        this.dme2Client = new DME2Client(this.manager, request);
        if (this.dme2Payload != null) {
            this.dme2Client.setDME2Payload(this.dme2Payload);
        }
        if (this.queryParamsString != null) {
            this.dme2Client.setQueryParams(this.queryParamsString);
        }
        if (this.queryParamsMap != null) {
            this.dme2Client.setQueryParams(this.queryParamsMap, this.queryParamsMapEncode);
        }
        this.dme2Client.setHeaders(this.headers);
        if (this.username != null || this.password != null) {
            this.dme2Client.setCredentials(this.username, this.password);
        }
        if (this.asyncResponseHandlerIntf != null) {
            this.dme2Client.setReplyHandler(this.asyncResponseHandlerIntf);
        }
        return this.dme2Client;
    }

    public void addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setReplyHandler(AsyncResponseHandlerIntf replyHandler) {
        this.asyncResponseHandlerIntf = replyHandler;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void setJvmprops(Properties jvmprops) {
        this.jvmprops = jvmprops;
    }

    public void setDme2uri(String dme2uri) {
        this.dme2uri = dme2uri;
    }

    public void setPerEndpointTimeoutMs(long perEndpointTimeoutMs) {
        this.perEndpointTimeoutMs = perEndpointTimeoutMs;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setReturnResponseAsBytes(boolean returnResponseAsBytes) {
        this.returnResponseAsBytes = returnResponseAsBytes;
    }

    public void setEncoded(boolean isEncoded) {
        this.isEncoded = isEncoded;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setDme2Payload(DME2Payload dme2Payload) {
        this.dme2Payload = dme2Payload;
    }

    public void setQueryParamsString(String queryParamsString) {
        this.queryParamsString = queryParamsString;
    }

    public void setQueryParamsMap(Map<String, String> queryParamsMap) {
        this.queryParamsMap = queryParamsMap;
    }

    public void setQueryParamsMapEncode(boolean queryParamsMapEncode) {
        this.queryParamsMapEncode = queryParamsMapEncode;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setSubcontext(String subcontext) {
        this.subcontext = subcontext;
    }
}

