/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2MXBeanMaster;
import com.att.aft.dme2.api.DME2Server;
import com.att.aft.dme2.api.DME2ServiceHolder;
import com.att.aft.dme2.api.http.DME2QueuedThreadPool;
import com.att.aft.dme2.api.util.DME2PortFileManager;
import com.att.aft.dme2.api.util.DME2ThreadPoolConfig;
import com.att.aft.dme2.api.util.DME2ThrottleConfig;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2CancelRequestEventProcessor;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2EventDispatcher;
import com.att.aft.dme2.event.DME2EventManager;
import com.att.aft.dme2.event.DME2FailoverEventProcessor;
import com.att.aft.dme2.event.DME2FaultEventProcessor;
import com.att.aft.dme2.event.DME2InitEventProcessor;
import com.att.aft.dme2.event.DME2ReplyEventProcessor;
import com.att.aft.dme2.event.DME2RequestEventProcessor;
import com.att.aft.dme2.event.DME2ServiceStatManager;
import com.att.aft.dme2.event.DME2ServiceStats;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.internal.apache.commons.lang3.StringUtils;
import com.att.aft.dme2.internal.jetty.client.HttpClient;
import com.att.aft.dme2.internal.jetty.client.HttpProxy;
import com.att.aft.dme2.internal.jetty.client.ProxyConfiguration;
import com.att.aft.dme2.internal.jetty.util.ssl.SslContextFactory;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.DME2LoggingConfig;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistry;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryFS;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryFactory;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryGRM;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2RouteInfo;
import com.att.aft.dme2.manager.registry.DME2StaleCacheAdapter;
import com.att.aft.dme2.manager.registry.DME2StaleCacheAdapterFactory;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.server.api.websocket.DME2ServerWebSocketHandler;
import com.att.aft.dme2.server.api.websocket.DME2WSClientFactory;
import com.att.aft.dme2.server.mbean.DME2MXBean;
import com.att.aft.dme2.util.DME2ExceptionHandler;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.ErrorContext;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import javax.servlet.Servlet;

public class DME2Manager
implements DME2MXBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private Properties serviceProperties;
    private static final Logger logger = LoggerFactory.getLogger(DME2Manager.class.getName());
    private static ResourceBundle errorTable = DME2LoggingConfig.getInstance().initializeDME2ErrorTable("com/att/aft/dme2/api/errorTable");
    private DME2Configuration config;
    private boolean bindServer = false;
    private boolean enableWebSocket = false;
    private static volatile DME2Manager instance = null;
    private String hostname = null;
    private double latitude = 0.0;
    private double longitude = 0.0;
    private Integer port = null;
    private transient DME2EndpointRegistry registry = null;
    private transient DME2StaleCacheAdapter staleCacheAdapter = null;
    private transient DME2Server server = null;
    private String name;
    private DME2ServiceStatManager statManager;
    private DME2ServiceStats stats;
    private transient HttpClient client = null;
    private long endpointStalenessPeriodMs = 900000L;
    private final long routeOfferStalenessPeriodMs = 15L;
    private final Set<String> globalNoticeCache = Collections.synchronizedSet(new TreeSet());
    private transient ThreadPoolExecutor retryThreadpool;
    private String userName = null;
    private String password = null;
    private boolean running = false;
    private String charset = null;
    private boolean ignoreFailoverOnExpire = false;
    private String processID = null;
    private static final String MANAGER = "manager";
    private static final String SERVICE = "service";
    private static final String PACKAGE = "com.att.aft.dme2.Version";
    private DME2WSClientFactory dme2WsClientFactory = null;
    private transient ThreadPoolExecutor wsRetryThreadpool = null;
    private byte[] lockObject = new byte[0];
    private DME2EventManager eventManager = null;
    private String realm;
    private static boolean disableMetrics = false;
    private static boolean DISABLE_METRICS_FILTER = false;
    private static boolean DISABLE_THROTTLE_FILTER = false;
    private static TimeZone timezone = Calendar.getInstance().getTimeZone();
    private static Locale locale = Locale.getDefault();

    public String getRealm() {
        return this.realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DME2Manager getDefaultInstance() throws DME2Exception {
        DME2Manager result = instance;
        if (result != null) return result;
        Class<DME2Manager> clazz = DME2Manager.class;
        synchronized (DME2Manager.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new DME2Manager("DefaultDME2Manager", new Properties());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public DME2Manager(String name, Properties props) throws DME2Exception {
        this.setParams(name, new DME2Configuration(name, props));
        this.serviceProperties = props;
    }

    public static synchronized DME2Manager initDefaultManager(Properties props) throws DME2Exception {
        if (instance != null) {
            throw new DME2Exception("AFT-DME2-0001", new ErrorContext().add(MANAGER, instance.getName()));
        }
        instance = new DME2Manager("DefaultDME2Manager", props);
        return instance;
    }

    public DME2Manager() {
        try {
            this.setParams("DefaultDME2Manager", new DME2Configuration("DefaultDME2Manager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setParams(String name, DME2Configuration config) throws DME2Exception {
        try {
            String latitudeStr;
            this.config = config;
            this.validateBootProperties();
            this.statManager = DME2ServiceStatManager.getInstance(config);
            if (config != null && !config.getBoolean("AFT_DME2_COLLECT_SERVICE_STATS")) {
                this.statManager.setDisableMetrics(true);
            }
            this.retryThreadpool = DME2ThreadPoolConfig.getInstance(this).createExchangeRetryThreadPool();
            this.printVersion();
            logger.debug((URI)null, "ctor(String,DME2Configuration)", "DME2Manager [{}] initializing...", (Object)name);
            this.endpointStalenessPeriodMs = config.getLong("AFT_DME2_CLIENT_ENDPOINT_STALENESS_PERIOD_MS");
            this.name = name;
            this.server = this.initServer();
            this.registry = this.initRegistry();
            this.staleCacheAdapter = DME2StaleCacheAdapterFactory.getStaleCacheAdapter(this.registry);
            this.charset = config.getProperty("AFT_DME2_CHARSET");
            this.ignoreFailoverOnExpire = config.getBoolean("AFT_DME2_IGNORE_FAILOVER_ONEXPIRE");
            this.userName = config.getProperty("DME2_CRED_AUTH_USERNAME");
            this.password = config.getProperty("DME2_CRED_AUTH_PASSWORD");
            DME2PortFileManager fmgr = DME2PortFileManager.getInstance(config);
            String persistedPorts = fmgr.getPort(DME2Utils.getRunningInstanceName(config), this.server.getServerProperties().isSslEnable());
            if (persistedPorts != null) {
                this.server.setPersistedPorts(persistedPorts);
            }
            if (this.server != null && this.bindServer) {
                if (!this.server.isRunning()) {
                    this.server.start();
                }
                this.hostname = this.server.getServerProperties().getHostname();
                this.port = this.server.getServerProperties().getPort();
            }
            if ((latitudeStr = config.getProperty("AFT_LATITUDE")) == null) {
                throw new DME2Exception("AFT-DME2-0003", new ErrorContext().add(MANAGER, this.name));
            }
            String longitudeStr = config.getProperty("AFT_LONGITUDE");
            if (longitudeStr == null) {
                throw new DME2Exception("AFT-DME2-0004", new ErrorContext().add(MANAGER, this.name));
            }
            this.latitude = Double.parseDouble(latitudeStr);
            this.longitude = Double.parseDouble(longitudeStr);
            DME2MXBeanMaster.getInstance().addManager(this);
            if (this.registry instanceof DME2EndpointRegistryFS) {
                DME2MXBeanMaster.getInstance().addRegistryCache(this, (DME2EndpointRegistryFS)this.registry);
            }
            if (this.registry instanceof DME2EndpointRegistryGRM) {
                DME2MXBeanMaster.getInstance().addRegistryCache(this, (DME2EndpointRegistryGRM)this.registry);
            }
            this.initEventManager();
            logger.debug((URI)null, "ctor(String,DME2Configuration)", "DME2Manager [{}] initialized successfully", (Object)name);
            this.processID = ManagementFactory.getRuntimeMXBean().getName();
            DME2MXBeanMaster.getInstance().addThrottleConfig(DME2ThrottleConfig.getInstance(config, config.getProperty("AFT_DME2_THROTTLE_FILTER_CONFIG_FILE", "dme2-throttle-config.properties")), this.getName());
        }
        catch (Exception e) {
            throw DME2ExceptionHandler.handleException(e, "");
        }
    }

    private void validateBootProperties() throws DME2Exception {
        if (null == this.config.getProperty("AFT_ENVIRONMENT")) {
            throw new DME2Exception("AFT-DME2-0901", new ErrorContext().add(MANAGER, this.name));
        }
        if (null == this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_PLATFORM_KEY", "platform")) && null == this.config.getProperty("AFT_DME2_CONTAINER_SCLD_PLATFORM_KEY")) {
            throw new DME2Exception("AFT-DME2-0901", new ErrorContext().add(MANAGER, this.name));
        }
        if (null == this.config.getProperty("AFT_LATITUDE")) {
            throw new DME2Exception("AFT-DME2-0003", new ErrorContext().add(MANAGER, this.name));
        }
        if (null == this.config.getProperty("AFT_LONGITUDE")) {
            throw new DME2Exception("AFT-DME2-0004", new ErrorContext().add(MANAGER, this.name));
        }
    }

    public DME2Manager(String name, DME2Configuration config) throws DME2Exception {
        this.setParams(name, config);
    }

    private void initEventManager() {
        this.eventManager = DME2EventManager.getInstance(this.config);
        this.registerEventHandlers();
    }

    private void registerEventHandlers() {
        this.eventManager.registerEventProcessor(EventType.REQUEST_EVENT.getName(), new DME2RequestEventProcessor(this.config));
        this.eventManager.registerEventProcessor(EventType.REPLY_EVENT.getName(), new DME2ReplyEventProcessor(this.config));
        this.eventManager.registerEventProcessor(EventType.FAULT_EVENT.getName(), new DME2FaultEventProcessor(this.config));
        this.eventManager.registerEventProcessor(EventType.TIMEOUT_EVENT.getName(), new DME2FaultEventProcessor(this.config));
        this.eventManager.registerEventProcessor(EventType.CANCEL_REQUEST_EVENT.getName(), new DME2CancelRequestEventProcessor(this.config));
        this.eventManager.registerEventProcessor(EventType.FAILOVER_EVENT.getName(), new DME2FailoverEventProcessor(this.config));
        this.eventManager.registerEventProcessor(EventType.INIT_EVENT.getName(), new DME2InitEventProcessor(this.config));
    }

    public DME2Manager(String name, DME2Configuration config, Properties props) throws DME2Exception {
        this.setParams(name, config);
        this.serviceProperties = props;
    }

    public Properties getServiceProperties() {
        return this.serviceProperties;
    }

    public String getProcessID() {
        return this.processID.contains("@") ? this.processID.substring(0, this.processID.indexOf("@")) : this.processID;
    }

    public void bindServiceListener(String service, Servlet listenerServlet) throws DME2Exception {
        this.bindServiceListener(service, listenerServlet, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindServiceListener(String service, Servlet listenerServlet, String securityRealm, String[] allowedRoles, String loginMethod) throws DME2Exception {
        try {
            if (this.statManager != null) {
                this.stats = this.statManager.getServiceStats(service);
            }
            this.bindServer = true;
            this.realm = securityRealm;
            if (this.server == null) {
                DME2Manager dME2Manager = instance;
                synchronized (dME2Manager) {
                    if (this.server == null) {
                        this.initDefaultServer(service);
                    }
                }
            }
            if (this.server != null && !this.server.isRunning()) {
                try {
                    this.server.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.running = true;
            }
            DME2ServiceHolder serviceHolder = new DME2ServiceHolder();
            serviceHolder.setServiceURI(service);
            serviceHolder.setServlet(listenerServlet);
            serviceHolder.setSecurityRealm(securityRealm);
            serviceHolder.setAllowedRoles(allowedRoles);
            serviceHolder.setLoginMethod(loginMethod);
            serviceHolder.setManager(this);
            serviceHolder.setServiceProperties(this.serviceProperties);
            this.server.addService(serviceHolder);
        }
        catch (Exception e) {
            throw DME2ExceptionHandler.handleException(e, service);
        }
    }

    public void bindServiceListener(String service, DME2ServerWebSocketHandler webSocketHandler) throws DME2Exception {
        this.bindServiceListener(service, webSocketHandler, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindServiceListener(String service, DME2ServerWebSocketHandler webSocketHandler, String securityRealm, String[] allowedRoles, String loginMethod) throws DME2Exception {
        try {
            this.bindServer = true;
            this.enableWebSocket = true;
            if (this.server == null) {
                DME2Manager dME2Manager = instance;
                synchronized (dME2Manager) {
                    if (this.server == null) {
                        this.initDefaultServer(service, true);
                    }
                }
            }
            if (this.server != null && !this.server.isRunning()) {
                this.server.setWebSocket(true);
                this.server.start();
                this.running = true;
            }
            if (webSocketHandler != null) {
                webSocketHandler.setDme2ServiceName(service);
            }
            DME2ServiceHolder serviceHolder = new DME2ServiceHolder();
            serviceHolder.setServiceURI(service);
            serviceHolder.setDme2WebSocketHandler(webSocketHandler);
            serviceHolder.setSecurityRealm(securityRealm);
            serviceHolder.setAllowedRoles(allowedRoles);
            serviceHolder.setLoginMethod(loginMethod);
            serviceHolder.setServiceProperties(this.serviceProperties);
            this.server.addService(serviceHolder);
        }
        catch (Exception e) {
            throw DME2ExceptionHandler.handleException(e, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindService(DME2ServiceHolder serviceHolder) throws DME2Exception {
        DME2ServerWebSocketHandler webSocketHandler;
        this.server.addService(serviceHolder);
        serviceHolder.setServiceProperties(this.serviceProperties);
        if (this.server == null) {
            DME2Manager dME2Manager = instance;
            synchronized (dME2Manager) {
                if (this.server == null) {
                    if (serviceHolder.getDme2WebSocketHandler() != null) {
                        this.initDefaultServer(serviceHolder.getServiceURI(), true);
                        this.enableWebSocket = true;
                    } else {
                        this.initDefaultServer(serviceHolder.getServiceURI());
                        this.bindServer = true;
                    }
                }
            }
        }
        if (this.server != null && !this.server.isRunning()) {
            if (serviceHolder.getDme2WebSocketHandler() != null) {
                this.server.setWebSocket(true);
            }
            this.server.start();
            this.running = true;
        }
        if ((webSocketHandler = serviceHolder.getDme2WebSocketHandler()) != null) {
            webSocketHandler.setDme2ServiceName(serviceHolder.getServiceURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(DME2ServiceHolder holder) throws DME2Exception {
        if (this.server == null) {
            DME2Manager dME2Manager = instance;
            synchronized (dME2Manager) {
                if (this.server == null) {
                    this.initDefaultServer(DME2Utils.getRunningInstanceName(this.config));
                }
            }
        }
        holder.setManager(this);
        this.server.addService(holder);
    }

    public void removeService(DME2ServiceHolder holder) throws DME2Exception {
        this.server.removeService(holder);
    }

    public Collection<DME2ServiceHolder> getServices() {
        return this.server.getServices();
    }

    public DME2ServiceHolder getService(String serviceURI) {
        return this.server.getService(serviceURI);
    }

    public void start() throws DME2Exception {
        if (!this.running) {
            if (this.registry == null) {
                this.registry = this.initRegistry();
            }
            this.server.start();
        }
    }

    public void stop() throws DME2Exception {
        Exception t = null;
        try {
            if (this.dme2WsClientFactory != null) {
                this.dme2WsClientFactory.stop();
            }
        }
        catch (Exception e) {
            logger.error((URI)null, "stop", LogMessage.SERVER_STOP_FAIL, (Object)e);
            t = e;
        }
        if (this.running) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.error((URI)null, "stop", LogMessage.SERVER_STOP_FAIL, (Object)e);
                t = e;
            }
            try {
                this.registry.shutdown();
            }
            catch (Exception e) {
                logger.error((URI)null, "stop", LogMessage.SERVER_STOP_FAIL, (Object)e);
                t = e;
            }
            DME2EventDispatcher.setStopThreads(true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                t = e;
            }
            if (t != null) {
                ErrorContext ec = new ErrorContext();
                ec.add("ErrorMessage", t.getMessage());
                throw new DME2Exception("AFT-DME2-3008", ec);
            }
        }
    }

    public DME2Client newClient(URI uri, long connTimeoutMs) throws DME2Exception {
        return new DME2Client(this, uri, connTimeoutMs);
    }

    public DME2Client newClient(URI uri, long connTimeoutMs, String charset) throws DME2Exception {
        return new DME2Client(this, uri, connTimeoutMs, charset);
    }

    public List<DME2RouteOffer> getActiveOffers(DmeUniformResource uniformResource, DME2Endpoint[] endpoints) throws DME2Exception {
        String serviceName = uniformResource.getService();
        if (endpoints != null) {
            DME2RouteOffer offer = new DME2RouteOffer(uniformResource.getService(), uniformResource.getVersion(), uniformResource.getEnvContext(), "DIRECT", endpoints, this);
            return Arrays.asList(offer);
        }
        switch (uniformResource.getUrlType()) {
            case STANDARD: {
                if (uniformResource.getPartner() == null) {
                    return null;
                }
            }
            case SEARCHABLE: {
                boolean searchKeyWithWildcard = false;
                if (serviceName != null && serviceName.contains("/")) {
                    searchKeyWithWildcard = true;
                }
                String serviceKey = uniformResource.getRouteInfoServiceSearchKey();
                return this.getActiveOffers(serviceKey, uniformResource.getVersion(), uniformResource.getEnvContext(), uniformResource.getPartner(), uniformResource.getDataContext(), uniformResource.getStickySelectorKey(), searchKeyWithWildcard);
            }
        }
        return null;
    }

    public List<DME2RouteOffer> getActiveOffers(String service, String version, String envContext, String partnerName, String dataContext, String stickySelectorKey) throws DME2Exception {
        return this.getActiveOffers(service, version, envContext, partnerName, dataContext, stickySelectorKey, false);
    }

    public List<DME2RouteOffer> getActiveOffers(String service, String version, String envContext, String partnerName, String dataContext, String stickySelectorKey, boolean searchKeyWithWildcard) throws DME2Exception {
        return this.getActiveOffers(service, version, envContext, partnerName, dataContext, stickySelectorKey, searchKeyWithWildcard, null);
    }

    public List<DME2RouteOffer> getActiveOffers(String service, String version, String envContext, String partnerName, String dataContext, String stickySelectorKey, boolean searchKeyWithWildcard, String preferredRouteOffer) throws DME2Exception {
        DME2RouteInfo routeInfo = this.getRouteInfo(service, version, envContext);
        if (routeInfo == null) {
            throw new DME2Exception("AFT-DME2-0005 {}", new ErrorContext().add(SERVICE, service).add("version", version));
        }
        boolean checkDataPartitionRange = Boolean.parseBoolean(this.config.getProperty("CHECK_DATA_PARTITION_RANGE_FIRST", "false"));
        List<DME2RouteOffer> offers = routeInfo.getRouteOffers(envContext, partnerName, dataContext, stickySelectorKey, checkDataPartitionRange, preferredRouteOffer);
        if (searchKeyWithWildcard && offers != null) {
            for (DME2RouteOffer offer : offers) {
                offer.setSearchWithWildcard(true);
            }
        }
        return offers;
    }

    public DME2EndpointRegistry getEndpointRegistry() {
        return this.registry;
    }

    public DME2Endpoint[] getEndpoints(DmeUniformResource uniformResource) throws DME2Exception {
        if (uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.DIRECT) {
            return this.getDirectEndpoints(uniformResource);
        }
        String serviceKey = uniformResource.getRegistryFindEndpointSearchKey();
        if (serviceKey == null) {
            return null;
        }
        return this.findEndpoints(serviceKey, uniformResource.getVersion(), uniformResource.getEnvContext(), uniformResource.getRouteOffer(), uniformResource.isUsingVersionRanges());
    }

    public DME2Endpoint[] findEndpoints(String serviceKey, String version, String env, String routeOffer, boolean useVersionRange) throws DME2Exception {
        List<DME2Endpoint> unfiltered = this.registry.findEndpoints(serviceKey, version, env, routeOffer);
        if (useVersionRange) {
            return unfiltered.toArray(new DME2Endpoint[unfiltered.size()]);
        }
        ArrayList<DME2Endpoint> filtered = new ArrayList<DME2Endpoint>(unfiltered.size());
        for (DME2Endpoint ep : unfiltered) {
            if (!this.versionMatches(ep.getServiceVersion(), version)) continue;
            filtered.add(ep);
        }
        DME2Endpoint[] var = new DME2Endpoint[filtered.size()];
        int i = 0;
        Iterator iterator = filtered.iterator();
        while (iterator.hasNext()) {
            DME2Endpoint dme2End;
            var[i] = dme2End = (DME2Endpoint)iterator.next();
            ++i;
        }
        return var;
    }

    private boolean versionMatches(String endpointVersion, String requestVersion) {
        return endpointVersion.equals(requestVersion) || endpointVersion.startsWith(requestVersion + ".");
    }

    private DME2Endpoint[] getDirectEndpoints(DmeUniformResource uniformResource) {
        DME2Endpoint ep = new DME2Endpoint(0.0);
        ep.setHost(uniformResource.getOriginalURL().getHost());
        ep.setPort(uniformResource.getOriginalURL().getPort());
        ep.setPath(uniformResource.getSubContext() != null ? uniformResource.getSubContext() : uniformResource.getOriginalURL().getPath());
        ep.setServiceName(uniformResource.getOriginalURL().getPath());
        ep.setServiceVersion(uniformResource.getVersion());
        ep.setEnvContext(uniformResource.getEnvContext());
        ep.setRouteOffer(uniformResource.getRouteOffer());
        ep.setContextPath(uniformResource.getSubContext());
        ep.setProtocol(uniformResource.getOriginalURL().getProtocol());
        ep.setSimpleName(uniformResource.getService());
        ep.setDmeUniformResource(uniformResource);
        return new DME2Endpoint[]{ep};
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public DME2RouteInfo getRouteInfo(String service, String version, String envContext) throws DME2Exception {
        return this.registry.getRouteInfo(service, version, envContext);
    }

    public DME2Server getServer() {
        return this.server;
    }

    private void initDefaultServer(String service) throws DME2Exception {
        this.initDefaultServer(service, false);
    }

    private void initDefaultServer(String service, boolean isWebSocket) throws DME2Exception {
        this.server = new DME2Server(this.config);
        this.server.setManager(this);
        this.server.setWebSocket(isWebSocket);
        String configHost = this.config.getProperty("AFT_DME2_HOSTNAME", null);
        String configPort = this.config.getProperty("AFT_DME2_PORT", null);
        boolean sslEnabled = this.config.getBoolean("AFT_DME2_SSL_ENABLE", false);
        String configPortRange = null;
        configPortRange = sslEnabled ? this.config.getProperty("AFT_DME2_PORT_RANGE", this.config.getProperty("AFT_DME2_SERVER_DEFAULT_SSL_PORT_RANGE")) : this.config.getProperty("AFT_DME2_PORT_RANGE", this.config.getProperty("AFT_DME2_SERVER_DEFAULT_PORT_RANGE"));
        DME2PortFileManager fmgr = DME2PortFileManager.getInstance(this.config);
        String persistedPorts = fmgr.getPort(service, sslEnabled);
        if (persistedPorts != null) {
            this.server.setPersistedPorts(persistedPorts);
        }
        if (configHost != null) {
            this.server.getServerProperties().setHostname(configHost);
        }
        if (configPortRange != null) {
            this.server.getServerProperties().setPortRange(configPortRange);
        }
        if (configPort != null) {
            this.server.getServerProperties().setPort(Integer.parseInt(configPort));
        }
        this.server.start();
        this.hostname = this.server.getServerProperties().getHostname();
        this.port = this.server.getServerProperties().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindServiceListener(String service) throws DME2Exception {
        this.bindServer = true;
        if (this.server == null) {
            DME2Manager dME2Manager = instance;
            synchronized (dME2Manager) {
                if (this.server == null) {
                    this.initDefaultServer(service);
                }
            }
        }
        this.registry.unpublish(service, this.hostname, this.port);
        this.server.unbindServiceListener(service);
    }

    public String getName() {
        return this.name;
    }

    private DME2EndpointRegistry initRegistry() throws DME2Exception {
        DME2EndpointRegistry reg;
        String registryClassName = this.config.getProperty("DME2_EP_REGISTRY_CLASS");
        if (registryClassName.equals("DME2GRM")) {
            reg = DME2EndpointRegistryFactory.getInstance().createEndpointRegistry("DME2GRM".concat("-").concat(this.getName()), this.config, DME2EndpointRegistryType.GRM, this.getName(), this.config.getProperties());
        } else if (registryClassName.equals("DME2FS")) {
            reg = DME2EndpointRegistryFactory.getInstance().createEndpointRegistry("DME2FS".concat("-").concat(this.getName()), this.config, DME2EndpointRegistryType.FileSystem, this.getName(), this.config.getProperties());
        } else if (registryClassName.equals("DME2MEMORY")) {
            reg = DME2EndpointRegistryFactory.getInstance().createEndpointRegistry("DME2MEMORY".concat("-").concat(this.getName()), this.config, DME2EndpointRegistryType.Memory, this.getName(), this.config.getProperties());
        } else {
            try {
                reg = (DME2EndpointRegistry)Class.forName(registryClassName).newInstance();
            }
            catch (Exception e) {
                throw new DME2Exception("AFT-DME2-0006", new ErrorContext().add(MANAGER, this.name), (Throwable)e);
            }
        }
        return reg;
    }

    private DME2Server initServer() throws DME2Exception {
        DME2Server ser = new DME2Server(this.config);
        ser.setManager(this);
        return ser;
    }

    public void setClientCredentials(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public double[] getDistanceBands() {
        return this.registry.getDistanceBands();
    }

    private void createEvent(EventType type, Map<String, Object> props) {
        DME2Event event = new DME2Event();
        switch (type) {
            case REPLY_EVENT: 
            case FAULT_EVENT: {
                event.setReplyMsgSize((Long)props.get("MSG_SIZE"));
                break;
            }
            case INIT_EVENT: 
            case REQUEST_EVENT: 
            case FAILOVER_EVENT: {
                event.setReqMsgSize((Long)props.get("MSG_SIZE"));
            }
        }
        event.setType(type);
        event.setMessageId((String)props.get("MESSAGE_ID") != null ? (String)props.get("MESSAGE_ID") : (String)props.get("AFT_DME2_CONNECT_ID"));
        event.setEventTime((Long)props.get("EVENT_TIME"));
        if ((String)props.get("DME2_INTERFACE_PROTOCOL") != null && ((String)props.get("DME2_INTERFACE_PROTOCOL")).equals("AFT_DME2_INTERFACE_JMS_PROTOCOL")) {
            event.setProtocol(this.config.getProperty("AFT_DME2_INTERFACE_JMS_PROTOCOL"));
        } else {
            event.setProtocol((String)props.get("DME2_INTERFACE_PROTOCOL"));
        }
        event.setProtocol((String)props.get("DME2_INTERFACE_PROTOCOL"));
        event.setRole((String)props.get("DME2_INTERFACE_ROLE"));
        event.setInterfacePort((String)props.get("DME2_INTERFACE_PORT"));
        event.setQueueName((String)props.get("QUEUE_NAME"));
        event.setService((String)props.get("DME2_WEBSOCKET_SERVICE_NAME"));
        event.setElapsedTime((Long)props.get("ELAPSED_TIME"));
        event.setPartner((String)props.get("DME2_REQUEST_PARTNER"));
        this.eventManager.postEvent(event);
    }

    public void postStatEvent(Map<String, Object> props) {
        if (this.config.getBoolean("AFT_DME2_COLLECT_SERVICE_STATS")) {
            try {
                logger.debug(null, "postStatEvent", "trying to post event");
                EventType type = null;
                if (props != null) {
                    logger.debug((URI)null, "postStatEvent", "Event details as being posted: {}", (Object)props);
                    if (props.get("FAULT_EVENT") != null && ((Boolean)props.get("FAULT_EVENT")).booleanValue()) {
                        type = EventType.FAULT_EVENT;
                    } else if (props.get("REPLY_EVENT") != null && ((Boolean)props.get("REPLY_EVENT")).booleanValue()) {
                        type = EventType.REPLY_EVENT;
                    } else if (props.get("REQUEST_EVENT") != null && ((Boolean)props.get("REQUEST_EVENT")).booleanValue()) {
                        type = EventType.REQUEST_EVENT;
                    } else if (props.get("FAILOVER_EVENT") != null && ((Boolean)props.get("FAILOVER_EVENT")).booleanValue()) {
                        type = EventType.FAILOVER_EVENT;
                    } else if (props.get("INIT_EVENT") != null && ((Boolean)props.get("INIT_EVENT")).booleanValue()) {
                        type = EventType.INIT_EVENT;
                    }
                    if (type != null) {
                        this.createEvent(type, props);
                    } else {
                        logger.warn((URI)null, "postStatEvent", "event type is not correct: {}", (Object)props);
                    }
                } else {
                    logger.warn(null, "postStatEvent", "event details as provided is null");
                }
            }
            catch (Exception e) {
                logger.warn(null, "postStatEvent", "error encountered while handling event");
            }
        }
    }

    @Override
    public String[] diagnostics() throws Exception {
        ArrayList<String> retList = new ArrayList<String>();
        String[] retStr = null;
        try {
            DME2Manager dME2Manager = this;
            Iterator<String> it = dME2Manager.statManager.getServiceNames().iterator();
            while (it.hasNext()) {
                boolean ignoreQueue = false;
                String serviceName = it.next();
                String[] splitStr = this.config.getProperty("AFT_DME2_QLIST_IGNORE").split(",");
                for (int i = 0; i < splitStr.length; ++i) {
                    if (serviceName == null || !serviceName.contains(splitStr[i])) continue;
                    ignoreQueue = true;
                    break;
                }
                if (ignoreQueue) continue;
                DME2ServiceStats sstats = this.statManager.getServiceStats(serviceName);
                String[] statsArr = sstats.getStats();
                for (int j = 0; j < statsArr.length; ++j) {
                    retList.add(statsArr[j]);
                }
            }
        }
        catch (Exception e) {
            logger.debug((URI)null, "diagnostics", LogMessage.SVC_STATS_FAIL, (Object)e);
        }
        retStr = new String[retList.size()];
        return retList.toArray(retStr);
    }

    @Override
    public void dump() throws Exception {
    }

    @Override
    public String getLoggingLevel() {
        return "info";
    }

    @Override
    public boolean heartbeat() throws Exception {
        return true;
    }

    @Override
    public boolean kill() throws Exception {
        return false;
    }

    @Override
    public void refresh() throws Exception {
        this.getEndpointRegistry().refresh();
        this.staleCacheAdapter.clearStaleEndpoints();
    }

    @Override
    public void setLoggingLevel(String newLoggingLevel) {
        String[] toks = newLoggingLevel.split(";");
        String level = toks[0];
        String handler = null;
        String path = null;
        if (toks.length > 1) {
            for (String t : toks) {
                String[] pair = t.split("=");
                if (pair.length != 2) continue;
                String key = pair[0];
                String value = pair[1];
                if (key.toUpperCase().equals("HANDLER")) {
                    handler = value;
                    continue;
                }
                if (!key.toUpperCase().equals("PATH")) continue;
                path = value;
            }
        }
        if (handler != null && handler.toUpperCase().equals("file")) {
            if (path == null) {
                throw new RuntimeException("FILE type specified but PATH not provided");
            }
        } else if (handler != null && handler.toUpperCase().equals("console")) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.parse(level));
        }
    }

    @Override
    public boolean shutdown() throws Exception {
        logger.debug(null, "shutdown", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "shutdown", "Shutting down manager {}", (Object)this.name);
        Exception t = null;
        try {
            if (this.dme2WsClientFactory != null) {
                this.dme2WsClientFactory.stop();
            }
        }
        catch (Exception e) {
            logger.error((URI)null, "shutdown", LogMessage.SERVER_STOP_FAIL, (Object)e);
            t = e;
        }
        try {
            logger.debug((URI)null, "shutdown", "Shutting down registry for manager {}", (Object)this.name);
            this.registry.shutdown();
        }
        catch (Exception e) {
            logger.error((URI)null, "shutdown", LogMessage.SERVER_STOP_FAIL, (Object)e);
            t = e;
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.error((URI)null, "shutdown", LogMessage.SERVER_STOP_FAIL, (Object)e);
            t = e;
        }
        if (t != null) {
            throw t;
        }
        return this.running;
    }

    @Override
    public String statistics() throws Exception {
        return Arrays.toString(this.diagnostics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getClient() throws DME2Exception {
        DME2Manager dME2Manager = this;
        synchronized (dME2Manager) {
            if (this.client == null) {
                int maxConnsPerAddress = this.config.getInt("AFT_DME2_CLIENT_MAX_CONNS_PER_ADDRESS");
                int readTimeoutMs = this.config.getInt("AFT_DME2_EP_READ_TIMEOUT_MS");
                int connectTimeoutMs = this.config.getInt("AFT_DME2_CLIENT_CONNECT_TIMEOUT_MS");
                int tpMaxIdleTimeMs = this.config.getInt("AFT_DME2_CLIENT_TP_MAX_IDLE_TIME_MS");
                int tpMaxThreads = this.config.getInt("AFT_DME2_CLIENT_TP_MAX_THREADS");
                int tpMinThreads = this.config.getInt("AFT_DME2_CLIENT_TP_MIN_THREADS");
                int tpMaxQueued = this.config.getInt("AFT_DME2_CLIENT_TP_MAX_QUEUED");
                int maxBuffers = this.config.getInt("AFT_DME2_CLIENT_MAX_BUFFERS");
                int requestBufferSize = this.config.getInt("AFT_DME2_CLIENT_REQ_BUFFER_SIZE");
                int requestHeaderSize = this.config.getInt("AFT_DME2_CLIENT_REQ_HEADER_SIZE");
                int responseBufferSize = this.config.getInt("AFT_DME2_CLIENT_RSP_BUFFER_SIZE");
                int responseHeaderSize = this.config.getInt("AFT_DME2_CLIENT_RSP_HEADER_SIZE");
                int maxRetries = this.config.getInt("AFT_DME2_CLIENT_MAX_RETRIES");
                boolean connectBlocking = this.config.getBoolean("AFT_DME2_CLIENT_CONN_BLOCKING");
                boolean allowRenegotiate = this.config.getBoolean("AFT_DME2_CLIENT_ALLOW_RENEGOTIATE");
                String clientProxyHost = this.config.getProperty("AFT_DME2_CLIENT_PROXY_HOST");
                String clientProxyPort = this.config.getProperty("AFT_DME2_CLIENT_PROXY_PORT");
                this.client = new HttpClient(new SslContextFactory(true));
                this.client.setMaxConnectionsPerDestination(maxConnsPerAddress);
                logger.debug(null, "getClient", "DME2Manager httpClient maxBuffers={};requestBufferSize={};requestHeaderSize={};responseBufferSize={};responseHeaderSize={};maxRetries={};connectBlocking={}", maxBuffers, requestBufferSize, requestHeaderSize, responseBufferSize, responseHeaderSize, maxRetries, connectBlocking);
                this.client.setRequestBufferSize(requestBufferSize);
                this.client.setResponseBufferSize(responseBufferSize);
                this.client.setConnectBlocking(connectBlocking);
                if (this.client.getSslContextFactory() != null) {
                    if (this.isIgnoreSSLConfig()) {
                        logger.debug(null, "getClient", "DME2Manager configuring ssl");
                        this.configureSsl(this.client.getSslContextFactory());
                    }
                    logger.debug((URI)null, "getClient", "DME2Manager.getClient isAllowRenegotiate={}", (Object)this.client.getSslContextFactory().isRenegotiationAllowed());
                    this.client.getSslContextFactory().setRenegotiationAllowed(allowRenegotiate);
                    logger.debug((URI)null, "getClient", "DME2Manager.getClient setAllowRenegotiate={}", (Object)allowRenegotiate);
                }
                DME2QueuedThreadPool tp = new DME2QueuedThreadPool();
                tp.setIdleTimeout(tpMaxIdleTimeMs);
                tp.setDaemon(true);
                this.client.setMaxRequestsQueuedPerDestination(tpMaxQueued);
                tp.setMaxThreads(tpMaxThreads);
                tp.setMinThreads(tpMinThreads);
                this.client.addBean(tp);
                this.client.setConnectTimeout(connectTimeoutMs);
                if (clientProxyHost != null && clientProxyPort != null) {
                    ProxyConfiguration proxyConfig = this.client.getProxyConfiguration();
                    HttpProxy proxy = new HttpProxy(clientProxyHost, new Integer(clientProxyPort));
                    proxyConfig.getProxies().add(proxy);
                }
                if (this.userName != null && this.password != null) {
                    this.setClientCredentials(this.userName, this.password);
                }
                try {
                    this.client.start();
                }
                catch (Exception e) {
                    throw new DME2Exception("AFT-DME2-0007", new ErrorContext().add(MANAGER, instance.getName()), (Throwable)e);
                }
            }
        }
        return this.client;
    }

    private boolean isIgnoreSSLConfig() {
        return !this.config.getBoolean("AFT_DME2_CLIENT_IGNORE_SSL_CONFIG");
    }

    private String[] getPropsArray(String key) {
        String temp = this.config.getProperty(key);
        if (temp != null) {
            return temp.split(",");
        }
        return null;
    }

    private void configureSsl(SslContextFactory cf) throws DME2Exception {
        String keySslExcludeProtocols = "AFT_DME2_CLIENT_SSL_EXCLUDE_PROTOCOLS";
        String keySslExcludeCipherSuite = "AFT_DME2_CLIENT_SSL_EXCLUDE_CIPHERSUITES";
        String keySslIncludeProtocols = "AFT_DME2_CLIENT_SSL_INCLUDE_PROTOCOLS";
        String keySslIncludeCipherSuite = "AFT_DME2_CLIENT_SSL_INCLUDE_CIPHERSUITES";
        String keystore = this.getKeyStore();
        String keystorePw = this.config.getProperty("AFT_DME2_CLIENT_KEYSTORE_PASSWORD");
        String truststore = this.getTrustStore();
        String truststorePw = this.config.getProperty("AFT_DME2_CLIENT_TRUSTSTORE_PASSWORD");
        String keyPw = this.config.getProperty("AFT_DME2_CLIENT_KEY_PASSWORD");
        Boolean allowRenegotiate = this.isAllowRenegotiate();
        Boolean trustAll = this.getSslTrustAll();
        String certAlias = this.getSslCertAlias();
        Boolean needClientAuth = this.getNeedClientAuth();
        Boolean wantClientAuth = this.getWantClientAuth();
        Boolean enableSessionCaching = this.isEnableSessionCaching();
        Integer sslSessionCacheSize = this.getSslSessionCacheSize();
        Integer sslSessionTimeout = this.getSslSessionTimeout();
        Boolean validatePeerCerts = this.isSslValidatePeerCerts();
        Boolean validateCerts = this.isValidateCerts();
        String[] excludeProtocols = this.getPropsArray(keySslExcludeProtocols);
        String[] includeProtocols = this.getPropsArray(keySslIncludeProtocols);
        String[] excludeCipherSuites = this.getPropsArray(keySslExcludeCipherSuite);
        String[] includeCipherSuites = this.getPropsArray(keySslIncludeCipherSuite);
        if (keystore != null) {
            cf.setKeyStorePath(keystore);
        }
        if (!StringUtils.isNotBlank(keystorePw)) {
            throw new DME2Exception("AFT-DME2-0918", new ErrorContext().add("AFT_DME2_CLIENT_KEYSTORE_PASSWORD", keystorePw));
        }
        cf.setKeyStorePassword(keystorePw);
        if (keyPw != null) {
            cf.setKeyManagerPassword(keyPw);
        }
        if (trustAll != null) {
            cf.setTrustAll(trustAll);
        }
        if (certAlias != null) {
            cf.setCertAlias(certAlias);
        }
        if (needClientAuth != null) {
            cf.setNeedClientAuth(needClientAuth);
        }
        if (wantClientAuth != null) {
            cf.setWantClientAuth(wantClientAuth);
        }
        if (enableSessionCaching != null) {
            cf.setSessionCachingEnabled(enableSessionCaching);
        }
        if (sslSessionCacheSize != null) {
            cf.setSslSessionCacheSize(sslSessionCacheSize);
        }
        if (sslSessionTimeout != null) {
            cf.setSslSessionTimeout(sslSessionTimeout);
        }
        if (validatePeerCerts != null) {
            cf.setValidatePeerCerts(validatePeerCerts);
        }
        if (validateCerts != null) {
            cf.setValidateCerts(validateCerts);
        }
        if (excludeProtocols != null) {
            cf.setExcludeProtocols(excludeProtocols);
        }
        if (includeProtocols != null) {
            cf.setIncludeProtocols(includeProtocols);
        }
        if (excludeCipherSuites != null) {
            cf.setExcludeCipherSuites(excludeCipherSuites);
        }
        if (includeCipherSuites != null) {
            cf.setIncludeCipherSuites(includeCipherSuites);
        }
        if (truststore != null) {
            if (StringUtils.isBlank(truststorePw)) {
                throw new DME2Exception("AFT-DME2-0919", new ErrorContext().add("AFT_DME2_CLIENT_TRUSTSTORE_PASSWORD", truststorePw));
            }
            cf.setTrustStorePassword(truststorePw);
        } else {
            cf.setTrustStorePassword(keystorePw);
        }
        cf.setRenegotiationAllowed(allowRenegotiate);
    }

    public Boolean isAllowRenegotiate() {
        return this.config.getBoolean("AFT_DME2_CLIENT_ALLOW_RENEGOTIATE");
    }

    private String getTrustStore() {
        return this.config.getProperty("AFT_DME2_CLIENT_TRUSTSTORE");
    }

    private String getKeyStore() {
        return this.config.getProperty("AFT_DME2_CLIENT_KEYSTORE");
    }

    private Boolean isValidateCerts() {
        return this.config.getBoolean("AFT_DME2_CLIENT_SSL_VALIDATE_CERTS");
    }

    private Boolean isSslValidatePeerCerts() {
        return this.config.getBoolean("AFT_DME2_CLIENT_SSL_VALIDATE_PEER_CERTS");
    }

    private Integer getSslSessionTimeout() {
        return this.config.getInteger("AFT_DME2_CLIENT_SSL_SESSION_TIMEOUT", null);
    }

    private Integer getSslSessionCacheSize() {
        return this.config.getInteger("AFT_DME2_CLIENT_SSL_SESSION_CACHE_SIZE", null);
    }

    private Boolean isEnableSessionCaching() {
        return this.config.getBoolean("AFT_DME2_CLIENT_SSL_ENABLED_SESSION_CACHING");
    }

    private Boolean getWantClientAuth() {
        return this.config.getBoolean("AFT_DME2_CLIENT_SSL_WANT_CLIENT_AUTH");
    }

    private Boolean getNeedClientAuth() {
        return this.config.getBoolean("AFT_DME2_CLIENT_SSL_NEED_CLIENT_AUTH");
    }

    private String getSslCertAlias() {
        return this.config.getProperty("AFT_DME2_CLIENT_SSL_CERT_ALIAS");
    }

    private Boolean getSslTrustAll() {
        return this.config.getBoolean("AFT_DME2_CLIENT_SSL_TRUST_ALL");
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isEndpointStale(String url) {
        Long staleTime = this.staleCacheAdapter.getEndpointExpirationTime(url);
        if (staleTime == null) {
            return false;
        }
        if (staleTime <= System.currentTimeMillis()) {
            this.staleCacheAdapter.removeStaleEndpoint(url);
            logger.debug((URI)null, "isEndpointStale", LogMessage.STALENESS_EXPIRED, (Object)url);
            return false;
        }
        return true;
    }

    public boolean isUrlInStaleList(String url) {
        return this.staleCacheAdapter.isEndpointStale(url);
    }

    public void addStaleEndpoint(String url) {
        this.staleCacheAdapter.addStaleEndpoint(url, this.endpointStalenessPeriodMs + System.currentTimeMillis());
    }

    public void addStaleEndpoint(String url, Long newEndpointStalenessPeriod) {
        Long endpointStalenessPeriod = newEndpointStalenessPeriod;
        if (endpointStalenessPeriod == null || endpointStalenessPeriod == 0L) {
            endpointStalenessPeriod = this.endpointStalenessPeriodMs;
        }
        this.staleCacheAdapter.addStaleEndpoint(url, System.currentTimeMillis() + endpointStalenessPeriod);
    }

    public void removeStaleEndpoint(String url) {
        this.staleCacheAdapter.removeStaleEndpoint(url);
    }

    public boolean isRouteOfferStale(String url) {
        return this.staleCacheAdapter.isRouteOfferStale(url);
    }

    public void addStaleRouteOffer(String url, Long routeOfferStalenessPeriod) {
        Long stalePeriod = null;
        String stalePeriodStr = System.getProperty("AFT_DME2_ROUTEOFFER_STALENESS_IN_MIN");
        if (stalePeriodStr != null) {
            logger.debug((URI)null, "addStaleRouteOffer", LogMessage.DEBUG_MESSAGE, (Object)"RouteOffer staleness duration found in System Properties. Value = {} minutes.", (Object)stalePeriodStr);
            try {
                stalePeriod = Long.parseLong(stalePeriodStr);
                stalePeriod = stalePeriod * 60000L;
            }
            catch (NumberFormatException e) {
                logger.debug((URI)null, "addStaleRouteOffer", "Exception occured while parsing staleness duration provided in System Properties. Ignoring and using default value of {} minutes.", (Object)15L);
                stalePeriod = 15L;
            }
        } else {
            stalePeriod = (routeOfferStalenessPeriod != null && routeOfferStalenessPeriod != 0L ? routeOfferStalenessPeriod : 15L) * 60000L;
        }
        stalePeriod = stalePeriod + System.currentTimeMillis();
        this.staleCacheAdapter.addStaleRouteOffer(url, stalePeriod);
        logger.debug((URI)null, "addStaleRouteOffer", "Marked RouteOffer stale for service: {}. Staleness duration in milliseconds is: {}", (Object)url, (Object)stalePeriod);
    }

    public void removeStaleRouteOffer(String url) {
        logger.debug((URI)null, "addStaleRouteOffer", "Removing stale RouteOffer for service: {}", (Object)url);
        this.staleCacheAdapter.removeStaleRouteOffer(url);
    }

    @Override
    public void disableMetrics() {
        disableMetrics = true;
    }

    @Override
    public void enableMetrics() {
        disableMetrics = false;
    }

    @Override
    public void enableMetricsFilter() {
        DISABLE_METRICS_FILTER = false;
    }

    @Override
    public void disableMetricsFilter() {
        DISABLE_METRICS_FILTER = true;
    }

    @Override
    public void enableThrottleFilter() {
        DISABLE_THROTTLE_FILTER = false;
    }

    @Override
    public void disableThrottleFilter() {
        DISABLE_THROTTLE_FILTER = true;
    }

    public void printVersion() {
        try {
            Object obj = Class.forName(PACKAGE).newInstance();
            Method method = Class.forName(PACKAGE).getMethod("getVersion", new Class[0]);
            Object retVal = method.invoke(obj, (Object[])null);
            String version = (String)retVal;
            logger.info((URI)null, "printVersion", "DME2 Version={}", (Object)version);
            if (this.config.getBoolean("DME2.DEBUG")) {
                logger.debug(null, "printVersion", new Date() + "\t DME2 Version " + version);
            }
        }
        catch (Exception e) {
            logger.error((URI)null, "printVersion", "DME2 error loading Version class. Verify whether {} class is in classpath", (Object)PACKAGE);
        }
    }

    public static String getVersion() {
        String version = null;
        try {
            Object obj = Class.forName(PACKAGE).newInstance();
            Method method = Class.forName(PACKAGE).getMethod("getVersion", new Class[0]);
            Object retVal = method.invoke(obj, (Object[])null);
            version = (String)retVal;
        }
        catch (Exception e) {
            logger.error(null, "getVersion", LogMessage.VERSION_FAIL);
        }
        return version;
    }

    public void publish(DME2ServiceHolder service) throws DME2Exception {
        try {
            if (!this.server.isRunning()) {
                throw new DME2Exception("AFT-DME2-1803", new ErrorContext().add(SERVICE, service.getServiceURI()));
            }
            this.hostname = this.server.getServerProperties().getHostname();
            if (this.hostname != null && this.hostname.startsWith("0.")) {
                try {
                    InetAddress.getLocalHost();
                    this.hostname = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                }
                catch (Exception e) {
                    logger.debug((URI)null, "publish", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                }
            }
            this.port = this.server.getServerProperties().getPort();
            DME2PortFileManager fmgr = DME2PortFileManager.getInstance(this.config);
            fmgr.persistPort(DME2Utils.getRunningInstanceName(this.config), this.port, this.server.getServerProperties().isSslEnable());
            if (service.getDme2WebSocketHandler() != null) {
                String serviceContext = service.getContext();
                if (this.config.getBoolean("AFT_DME2_SERVER_WEBSOCKET_APPEND_CONTEXT") && !serviceContext.endsWith("/")) {
                    serviceContext = serviceContext + "/";
                }
                if (this.server.getServerProperties().isSslEnable()) {
                    this.registry.publish(service.getServiceURI(), serviceContext, this.hostname, this.port, this.latitude, this.longitude, "wss");
                } else {
                    this.registry.publish(service.getServiceURI(), serviceContext, this.hostname, this.port, this.latitude, this.longitude, "ws");
                }
            } else if (this.server.getServerProperties().isSslEnable()) {
                this.registry.publish(service.getServiceURI(), service.getContext(), this.hostname, this.port, this.latitude, this.longitude, "https");
            } else {
                this.registry.publish(service.getServiceURI(), service.getContext(), this.hostname, this.port, this.latitude, this.longitude, "http");
            }
            logger.debug((URI)null, "publish", "AFT-DME2-1800 {}", (Object)new ErrorContext().add(SERVICE, service.getServiceURI()).add("address", this.server.getBaseAddress()).add("hostname", this.hostname).add("port", this.port + ""));
            List<String> serviceAliases = service.getServiceAliases();
            if (serviceAliases != null && serviceAliases.size() > 0) {
                for (String tsAlias : serviceAliases) {
                    String serviceURI = service.getServiceURI();
                    if (serviceURI == null || tsAlias.equals(serviceURI)) continue;
                    if (this.server.getServerProperties().isSslEnable()) {
                        this.registry.publish(tsAlias, service.getContext(), this.hostname, this.port, this.latitude, this.longitude, "https");
                    } else {
                        this.registry.publish(tsAlias, service.getContext(), this.hostname, this.port, this.latitude, this.longitude, "http");
                    }
                    logger.debug((URI)null, "publish", "AFT-DME2-1801", (Object)new ErrorContext().add("serviceAlias", tsAlias).add("serviceURI", service.getServiceURI()).add("context", service.getContext()).add("address", this.server.getBaseAddress()).add("hostname", this.hostname).add("port", this.port + ""));
                }
            }
        }
        catch (Exception e) {
            throw DME2ExceptionHandler.handleException(e, service.getServiceURI());
        }
    }

    public void unpublish(DME2ServiceHolder service) throws DME2Exception {
        try {
            String hostName = this.server.getServerProperties().getHostname();
            if (hostName != null && hostName.startsWith("0.")) {
                try {
                    InetAddress.getLocalHost();
                    hostName = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                }
                catch (Exception e) {
                    logger.debug((URI)null, "unpublish", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                }
            }
            this.registry.unpublish(service.getServiceURI(), hostName, this.server.getServerProperties().getPort());
            logger.debug((URI)null, "unpublish", "AFT-DME2-1802", (Object)new ErrorContext().add(SERVICE, service.getServiceURI()).add("address", this.server.getBaseAddress()).add("hostname", hostName).add("port", this.port + ""));
        }
        catch (Exception e) {
            throw DME2ExceptionHandler.handleException(e, service.getServiceURI());
        }
    }

    public Set<String> getGlobalNoticeCache() {
        return this.globalNoticeCache;
    }

    public ThreadPoolExecutor getExchangeRetryThreadPool() {
        return this.retryThreadpool;
    }

    public String getCharacterSet() {
        return this.charset;
    }

    public void setCharacterSet(String charset) {
        this.charset = charset;
    }

    public void setIgnoreFailoverOnExpire(boolean ignoreFailoverOnExpire) {
        this.ignoreFailoverOnExpire = ignoreFailoverOnExpire;
    }

    public boolean isIgnoreFailoverOnExpire() {
        return this.ignoreFailoverOnExpire;
    }

    public DME2WSClientFactory getWsClientFactory() {
        return this.dme2WsClientFactory;
    }

    private void configureSsl(DME2WSClientFactory factory) throws DME2Exception {
        this.configureSsl(factory.getWsClientFactory().getSslContextFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DME2WSClientFactory initWSClientFactory() throws DME2Exception {
        if (this.dme2WsClientFactory != null) {
            return this.dme2WsClientFactory;
        }
        byte[] byArray = this.lockObject;
        synchronized (this.lockObject) {
            if (this.dme2WsClientFactory == null) {
                this.dme2WsClientFactory = new DME2WSClientFactory(this);
                if (!this.config.getBoolean("AFT_DME2_CLIENT_IGNORE_SSL_CONFIG")) {
                    this.configureSsl(this.dme2WsClientFactory);
                }
                this.dme2WsClientFactory.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.wsRetryThreadpool == null) {
                this.wsRetryThreadpool = DME2ThreadPoolConfig.getInstance(this).createWebSocketRetryFactoryThreadPool();
            }
            return this.dme2WsClientFactory;
        }
    }

    public ThreadPoolExecutor getWsRetryThreadpool() {
        return this.wsRetryThreadpool;
    }

    public void logStatementsForTesting(String log) {
    }

    public DME2StaleCacheAdapter getStaleCache() {
        return this.staleCacheAdapter;
    }

    public DME2Configuration getConfig() {
        return this.config;
    }

    public void setConfig(DME2Configuration config) {
        this.config = config;
    }

    @Override
    public void setProperty(String key, String value) {
        this.config.setOverrideProperty(key, value);
    }

    @Override
    public Properties getProperties() {
        return this.serviceProperties;
    }

    @Override
    public void removeProperty(String key) {
        this.serviceProperties.remove(key);
    }

    public Long getLongProp(String key, Long defaultValue) {
        return this.config.getLong(key, defaultValue);
    }

    public Boolean getBoolProp(String key, Boolean defaultValue) {
        return this.config.getBoolean(key, defaultValue);
    }

    public Integer getIntProp(String key, Integer defaultValue) {
        return this.config.getInteger(key, defaultValue);
    }

    public String getStringProp(String key, String defaultValue) {
        return this.config.getProperty(key, defaultValue);
    }

    public String getProp(String key) {
        return this.config.getProperty(key);
    }

    public static TimeZone getTimezone() {
        return timezone;
    }

    public static Locale getLocale() {
        return locale;
    }

    static {
        try {
            DME2Manager.getDefaultInstance();
        }
        catch (DME2Exception dME2Exception) {
            // empty catch block
        }
    }
}

