/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.util.ErrorCatalog;
import com.att.aft.dme2.util.ErrorContext;

public class DME2RuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String code = null;
    private String msg = null;

    public DME2RuntimeException(String code, ErrorContext context, Throwable t) {
        this(code, ErrorCatalog.getInstance().getErrorMessage(code, context), t);
    }

    public DME2RuntimeException(String code, ErrorContext context) {
        this(code, ErrorCatalog.getInstance().getErrorMessage(code, context), new Object[0]);
    }

    public DME2RuntimeException(String code, String format, Object ... objs) {
        super("[" + code + "]: " + String.format(format, objs));
        this.code = code;
        this.msg = String.format(format, objs);
    }

    public DME2RuntimeException(String code, String msg, Throwable e) {
        super("[" + code + "]: " + msg, e);
        this.code = code;
        this.msg = msg;
    }

    public DME2RuntimeException(String code, Throwable msg) {
        super("[" + code + "]: " + msg.getLocalizedMessage(), msg);
        this.code = code;
        this.msg = msg.getLocalizedMessage();
    }

    public String getErrorCode() {
        return this.code;
    }

    public String getErrorMessage() {
        return this.msg;
    }
}

