/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.ActionType;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.RequestInvokerIntf;
import com.att.aft.dme2.api.RequestProcessorIntf;
import com.att.aft.dme2.api.util.DME2ExchangeFaultContext;
import com.att.aft.dme2.api.util.DME2ExchangeRequestContext;
import com.att.aft.dme2.api.util.DME2ExchangeRequestHandler;
import com.att.aft.dme2.api.util.DME2FailoverFaultHandler;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.RequestHandlerIntf;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.domain.IteratorMetricsEvent;
import com.att.aft.dme2.iterator.factory.EndpointIteratorFactory;
import com.att.aft.dme2.iterator.service.DME2BaseEndpointIterator;
import com.att.aft.dme2.iterator.service.DME2EndpointURLFormatter;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DME2Payload;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.request.HttpRequest;
import com.att.aft.dme2.request.Request;
import com.att.aft.dme2.request.RequestContext;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.InternalConnectionFailedException;
import java.net.URI;
import java.util.UUID;

public class DefaultRequestProcessor
implements RequestProcessorIntf {
    public RequestInvokerIntf invoker = null;
    private boolean forcePreferredRouteOffer;
    private static final Logger logger = LoggerFactory.getLogger(DefaultRequestProcessor.class.getName());
    private DME2Configuration config;
    private DME2EndpointReference currentEndpointReference;
    private boolean attemptingRetry;
    private final StringBuffer routeOfferBuffer = new StringBuffer();
    private String context;
    private boolean isEndpointResolved;
    private String currentFinalUrl = null;
    private long sendStart;
    private String timeoutString;
    private long connectTimeout;
    private long qendpointReadTimeOut;
    private boolean preferLocal = false;
    private String url = null;
    IteratorMetricsEvent iteratorMetricsEvent = null;

    public DefaultRequestProcessor(RequestInvokerIntf invoker) {
        this.invoker = invoker;
    }

    @Override
    public boolean send(RequestContext context, DME2EndpointReference endpoint, DME2Payload payload) throws DME2Exception {
        boolean isEndpointResolved = this.resolveFinalEndpointURL(context, endpoint);
        if (isEndpointResolved) {
            try {
                context.getRequest().setLookupUri(endpoint.getEndpoint().toURLString());
                this.invoker.execute(ActionType.SEND, context, payload);
            }
            catch (InternalConnectionFailedException e) {
                return false;
            }
        }
        return isEndpointResolved;
    }

    @Override
    public void send(RequestContext context, DME2Payload payload) throws DME2Exception {
        this.invoker.init(context, ActionType.SEND, payload);
        String conversationID = context.getLogContext().getConversationId();
        DME2BaseEndpointIterator iterator = null;
        DME2EndpointURLFormatter urlFormatterImpl = null;
        DME2Manager manager = context.getMgr();
        this.config = manager.getConfig();
        this.invokeRequestHandlers(context.getRequest());
        iterator = EndpointIteratorFactory.getDefaultEndpointIteratorBuilder(this.config).setServiceURI(context.getRequest().getLookupUri()).setProps(manager.getProperties()).setManager(manager).setUrlFormatter(urlFormatterImpl).setIteratorEndpointOrderHandlers(((HttpRequest)context.getRequest()).getEndpointOrderHandlers()).setIteratorRouteOfferOrderHandlers(((HttpRequest)context.getRequest()).getIteratorRouteOfferOrderHandlers()).build();
        if (!iterator.hasNext()) {
            ErrorContext ec = new ErrorContext();
            ec.add("service", context.getRequest().getLookupUri());
            if (iterator.getRouteOffersTried() != null) {
                ec.add("routeOffersTried", iterator.getRouteOffersTried());
            }
            DME2Exception e = new DME2Exception("AFT-DME2-0702", ec);
            logger.error(conversationID, null, "AFT-DME2-0702", e.getErrorMessage());
            throw e;
        }
        while (iterator.hasNext() && !this.isEndpointResolved) {
            DME2EndpointReference next = (DME2EndpointReference)iterator.next();
            this.resolveFinalEndpointURL(context, next);
        }
        if (!this.isEndpointResolved) {
            ErrorContext ec = new ErrorContext();
            ec.add("service", context.getRequest().getLookupUri());
            ec.add("routeOffersTried", this.routeOfferBuffer.toString());
            DME2Exception e = new DME2Exception("AFT-DME2-0702", ec);
            logger.error(conversationID, null, "AFT-DME2-0702", e.getErrorMessage());
            throw e;
        }
        this.setReadTimeout(context);
        this.sendStart = System.currentTimeMillis();
        String searchFilter = "";
        if (iterator.getCurrentDME2RouteOffer() != null && iterator.getCurrentDME2RouteOffer().getSearchFilter() != null) {
            searchFilter = iterator.getCurrentDME2RouteOffer().getSearchFilter();
        }
        if (iterator.getCurrentDME2EndpointRouteOffer() != null && context.getMgr().getGlobalNoticeCache().remove(context.getRequest().getLookupUri() + ":" + searchFilter)) {
            logger.info(context.getLogContext().getConversationId(), null, LogMessage.EXCH_OFFER_RESTORE.toString(), searchFilter);
        }
        try {
            iterator.setMetricsConversationId(this.getConversationId(context));
            iterator.start(this.createIteratorMetricsEvent(null, this.currentEndpointReference.getEndpoint().getProtocol(), this.currentEndpointReference.getEndpoint().toURLString(), this.currentEndpointReference.getEndpoint().getHost(), context));
        }
        catch (Exception metricsException) {
            logger.info(context.getLogContext().getConversationId(), null, "DefaultRequestProcessor.send: error in capturing start metrics for the iterator endpoint reference: {}", this.currentEndpointReference != null ? this.currentEndpointReference.toString() : null);
        }
        try {
            context.getRequest().setLookupUri(this.getUrl());
            this.invoker.createExchange(this.getUrl(), context, iterator);
            this.invoker.execute(ActionType.SEND, context, payload);
        }
        catch (InternalConnectionFailedException internalConnectionFailedException) {
            // empty catch block
        }
    }

    private String getConversationId(RequestContext context) {
        String conversationId = null;
        try {
            if (conversationId == null) {
                conversationId = ((HttpRequest)context.getRequest()).getRequestHeaders().get("JMSMessageID");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conversationId;
    }

    private void invokeRequestHandlers(Request request) {
        if (!this.config.getBoolean("AFT_DME2_ALLOW_INVOKE_HANDLERS")) {
            return;
        }
        String preferredRouteOffer = null;
        String preferredVersion = null;
        String[] requestHandlers = this.getExchangeRequestHandlers(request);
        String requestUrl = request.getLookupUri();
        if (requestHandlers != null) {
            long start = System.currentTimeMillis();
            DME2ExchangeRequestContext ctxData = new DME2ExchangeRequestContext(requestUrl, request.getReadTimeout(), DME2Utils.getQueryParamsAsMap(request.getQueryParams()), request.getClientHeaders());
            for (int i = 0; i < requestHandlers.length; ++i) {
                String handlerName = requestHandlers[i];
                try {
                    Object handler;
                    Object obj = DME2Utils.loadClass(this.config, requestUrl, handlerName);
                    if (obj != null && obj instanceof RequestHandlerIntf) {
                        handler = (RequestHandlerIntf)obj;
                        preferredRouteOffer = handler.getPreferredRouteOffer(request);
                        logger.debug(null, "getPreferredRouteOffer", LogMessage.EXCH_INVOKE_HANDLER, "handleRequest", handlerName, System.currentTimeMillis() - start);
                        logger.debug((URI)null, "getPreferredRouteOffer", "{}:handleRequest invoked", (Object)handlerName);
                        continue;
                    }
                    if (obj == null || !(obj instanceof DME2ExchangeRequestHandler)) continue;
                    handler = (DME2ExchangeRequestHandler)obj;
                    try {
                        handler.handleRequest(ctxData);
                    }
                    catch (Throwable e) {
                        logger.debug((URI)null, "getPreferredRouteOffer", "{}:handleRequest invoke failed with exception:", (Object)handlerName, (Object)e);
                        logger.warn(null, "getPreferredRouteOffer", LogMessage.EXCH_INVOKE_FAIL, "handleRequest", handlerName, e);
                    }
                    preferredRouteOffer = ctxData.getPreferredRouteOffer();
                    logger.debug((URI)null, "getPreferredRouteOffer", "{}:handleRequest invoked", (Object)handlerName);
                    continue;
                }
                catch (Throwable e) {
                    logger.debug((URI)null, "getPreferredRouteOffer", "{}:handleRequest invoke failed with exception:", (Object)handlerName, (Object)e);
                    logger.warn(null, "getPreferredRouteOffer", LogMessage.EXCH_INVOKE_FAIL, "handleRequest", handlerName, e);
                }
            }
            preferredVersion = ctxData.getPreferredVersion();
            this.forcePreferredRouteOffer = ctxData.isForcePreferredRouteOffer();
        }
        logger.debug((URI)null, "getPreferredRouteOffer", "Returning {} as preferred route offer", (Object)preferredRouteOffer);
        if (preferredRouteOffer != null) {
            this.config.setOverrideProperty("AFT_DME2_PREFERRED_ROUTEOFFER", preferredRouteOffer);
        }
        if (preferredVersion != null) {
            this.config.setOverrideProperty("AFT_DME2_PREFERRED_VERSION", preferredVersion);
        }
        this.config.setOverrideProperty("AFT_DME2_FORCE_PREFERRED_ROUTE_OFFER", this.forcePreferredRouteOffer ? "true" : "false");
    }

    private String[] getExchangeRequestHandlers(Request request) {
        String requestHandlers = request.getClientHeaders().get(this.config.getProperty("AFT_DME2_EXCHANGE_REQUEST_HANDLERS_KEY"));
        logger.debug((URI)null, "getExchangeRequestHandlers", "{}:handleRequest invoked", (Object)requestHandlers);
        if (requestHandlers != null && requestHandlers.length() > 0) {
            try {
                String[] requestHandlersArr = requestHandlers.split(",");
                return requestHandlersArr;
            }
            catch (Exception e) {
                logger.debug((URI)null, "getExchangeRequestHandlers", LogMessage.EXCH_READ_HANDLER_FAIL, (Object)"getExchangeRequestHandlers", (Object)e);
                return null;
            }
        }
        requestHandlers = this.config.getProperty(this.config.getProperty("AFT_DME2_EXCHANGE_REQUEST_HANDLERS_KEY"), "");
        if (requestHandlers != null && requestHandlers.length() > 0) {
            String[] requestHandlersArr = requestHandlers.split(",");
            logger.debug((URI)null, "getExchangeRequestHandlers", "REQUEST_HANDLERS_CHAIN_MGR_PROPERTY", (Object)requestHandlers);
            return requestHandlersArr;
        }
        return null;
    }

    private void setReadTimeout(RequestContext context) throws DME2Exception {
        context.getRequest();
        long jmsPropertyEndpointTimeout = context.getRequest().getReadTimeout();
        long timeout = 0L;
        if (jmsPropertyEndpointTimeout > 0L) {
            try {
                timeout = jmsPropertyEndpointTimeout;
            }
            catch (Exception e) {
                timeout = this.config.getLong("AFT_DME2_EP_READ_TIMEOUT_MS");
            }
            this.timeoutString = "JMSHeader-AFT_DME2_EP_READ_TIMEOUT_MS=" + timeout;
        } else if (this.qendpointReadTimeOut > 0L) {
            this.timeoutString = "URIQueryString-endpointReadTimeout=" + this.qendpointReadTimeOut;
            timeout = this.qendpointReadTimeOut;
        } else {
            timeout = this.config.getLong("AFT_DME2_EP_READ_TIMEOUT_MS");
            this.timeoutString = "CFG_AFT_DME2_EP_READ_TIMEOUT_MS=" + timeout;
        }
        context.getRequest().setReadTimeout(timeout);
    }

    private boolean invokeReplyHandlersRouteOfferFailover(RequestContext context, String routeOffer, String version) {
        if (!this.config.getBoolean("AFT_DME2_ALLOW_INVOKE_HANDLERS", true)) {
            return false;
        }
        String[] failoverHandlers = DME2Utils.getFailoverHandlers(this.config, context.getRequest().getClientHeaders());
        if (failoverHandlers != null) {
            String requestUrl = context.getRequest().getLookupUri();
            DME2ExchangeFaultContext ctxData = new DME2ExchangeFaultContext(requestUrl, 0, context.getRequest().getClientHeaders(), routeOffer, version, requestUrl, null);
            logger.debug((URI)null, "DefaultRequestProcessor.invokeReplyHandlersRouteOfferFailover", "invokeReplyHandlersRouteOfferFault routeOffer={};requestUrl={}", (Object)routeOffer, (Object)context.getRequest().getLookupUri());
            for (int i = 0; i < failoverHandlers.length; ++i) {
                long start = System.currentTimeMillis();
                String handlerName = failoverHandlers[i];
                try {
                    Object obj = DME2Utils.loadClass(this.config, requestUrl, handlerName);
                    if (!(obj instanceof DME2FailoverFaultHandler)) continue;
                    DME2FailoverFaultHandler handler = (DME2FailoverFaultHandler)obj;
                    handler.handleRouteOfferFailover(ctxData);
                    logger.debug(null, "DefaultRequestProcessor.invokeReplyHandlersRouteOfferFailover", LogMessage.EXCH_INVOKE_HANDLER, "handleRouteOfferFailover", handlerName, System.currentTimeMillis() - start);
                    continue;
                }
                catch (Throwable e1) {
                    logger.warn(null, "DefaultRequestProcessor.invokeReplyHandlersRouteOfferFailover", LogMessage.EXCH_INVOKE_FAIL, "handleRouteOfferFailover", handlerName, e1);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private void resolveFinalRequestURLFromIterator(RequestContext context, DME2BaseEndpointIterator iterator) {
        boolean isEndpointResolved = false;
        while (iterator.hasNext()) {
            String service;
            DME2EndpointReference next = (DME2EndpointReference)iterator.next();
            if (this.currentEndpointReference != null && next.getRouteOffer() != this.currentEndpointReference.getRouteOffer() && next.getSequence() != this.currentEndpointReference.getSequence()) {
                logger.info(null, LogMessage.EXCH_FAILOVER.toString(), context.getRequest().getLookupUri());
                String routeOffer = null;
                String version = null;
                if (this.currentEndpointReference != null) {
                    if (this.currentEndpointReference.getRouteOffer() != null && this.currentEndpointReference.getRouteOffer().getRouteOffer() != null) {
                        routeOffer = this.currentEndpointReference.getRouteOffer().getRouteOffer().getName();
                    }
                    if (this.currentEndpointReference.getEndpoint() != null) {
                        version = this.currentEndpointReference.getEndpoint().getServiceVersion();
                    }
                }
                this.invokeReplyHandlersRouteOfferFailover(context, routeOffer, version);
            }
            this.currentEndpointReference = next;
            if (this.attemptingRetry) {
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_RETRY_ROUTE_OFFER", (Object)(this.currentEndpointReference.getRouteOffer() != null ? this.currentEndpointReference.getRouteOffer().getSearchFilter() : null));
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_RETRY_SEQUENCE", (Object)this.currentEndpointReference.getSequence());
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_RETRY_ENDPOINT", (Object)this.currentEndpointReference.getEndpoint().toURLString());
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_RETRY_DISTANCE_BAND", (Object)this.currentEndpointReference.getDistanceBand().toString());
            } else {
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_ROUTE_OFFER", (Object)(this.currentEndpointReference.getRouteOffer() != null ? this.currentEndpointReference.getRouteOffer().getSearchFilter() : null));
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_SEQUENCE", (Object)this.currentEndpointReference.getSequence());
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_ENDPOINT", (Object)this.currentEndpointReference.getEndpoint().toURLString());
                logger.debug((URI)null, "resolveFinalRequestURLFromIterator", "CURRENT_DISTANCE_BAND", (Object)this.currentEndpointReference.getDistanceBand().toString());
            }
            if (this.currentEndpointReference.getRouteOffer() != null) {
                if (this.routeOfferBuffer.length() == 0) {
                    this.routeOfferBuffer.append(this.currentEndpointReference.getRouteOffer().getSearchFilter());
                } else if (!this.routeOfferBuffer.toString().contains(this.currentEndpointReference.getRouteOffer().getSearchFilter())) {
                    this.routeOfferBuffer.append(",");
                    this.routeOfferBuffer.append(this.currentEndpointReference.getRouteOffer().getSearchFilter());
                }
            }
            if (this.getContext() != null && context.getUniformResource().getUrlType().name().equals((Object)DmeUniformResource.DmeUrlType.STANDARD)) {
                if (!this.matchServletPath(this.getContext(), context.getRequest().getSubContext(), this.currentEndpointReference.getEndpoint().getContextPath())) {
                    continue;
                }
            } else if (context.getUniformResource().getUrlType().name().equals((Object)DmeUniformResource.DmeUrlType.DIRECT) && (service = context.getUniformResource().getService()) != null && service.contains("/")) {
                String cp = service.substring(service.indexOf("/"));
                if (!this.matchServletPath(cp, context.getUniformResource().getSubContext(), this.currentEndpointReference.getEndpoint().getContextPath())) continue;
                this.setContext(cp);
            }
            String hostFromArgs = this.config.getProperty("AFT_DME2_CONTAINER_HOST_KEY");
            if (this.preferLocal) {
                String epHost = this.currentEndpointReference.getEndpoint().getHost();
                if (epHost.equalsIgnoreCase(hostFromArgs) || DME2Utils.isHostMyLocalHost(hostFromArgs, this.config.getBoolean("DME2.DEBUG"))) {
                    this.currentEndpointReference.getEndpoint().setHost(hostFromArgs);
                    logger.debug(null, "LOAD_LOCAL_SEP_OK", this.currentEndpointReference.getEndpoint().toURLString());
                }
            } else {
                logger.debug(null, "LOAD_LOCAL_SEP_OK", this.currentEndpointReference.getEndpoint().toURLString());
            }
            this.setUrl(this.currentEndpointReference.getEndpoint().toURLString(this.getContext(), context.getRequest().getSubContext(), context.getRequest().getQueryParams()));
            isEndpointResolved = true;
            break;
        }
    }

    private boolean resolveFinalEndpointURL(RequestContext context, DME2EndpointReference next) {
        String service;
        if (this.currentEndpointReference != null && next.getRouteOffer() != this.currentEndpointReference.getRouteOffer() && next.getSequence() != this.currentEndpointReference.getSequence()) {
            logger.info(null, LogMessage.EXCH_FAILOVER.toString(), context.getRequest().getLookupUri());
            String routeOffer = null;
            String version = null;
            if (this.currentEndpointReference != null) {
                if (this.currentEndpointReference.getRouteOffer() != null && this.currentEndpointReference.getRouteOffer().getRouteOffer() != null) {
                    routeOffer = this.currentEndpointReference.getRouteOffer().getRouteOffer().getName();
                }
                if (this.currentEndpointReference.getEndpoint() != null) {
                    version = this.currentEndpointReference.getEndpoint().getServiceVersion();
                }
            }
            this.invokeReplyHandlersRouteOfferFailover(context, routeOffer, version);
        }
        this.currentEndpointReference = next;
        if (this.attemptingRetry) {
            logger.debug(null, "CURRENT_RETRY_ROUTE_OFFER", this.currentEndpointReference.getRouteOffer() != null ? this.currentEndpointReference.getRouteOffer().getSearchFilter() : null);
            logger.debug((URI)null, "resolveFinalEndpointURL", "CURRENT_RETRY_SEQUENCE", (Object)this.currentEndpointReference.getSequence());
            logger.debug((URI)null, "resolveFinalEndpointURL", "CURRENT_RETRY_ENDPOINT", (Object)this.currentEndpointReference.getEndpoint().toURLString());
            logger.debug((URI)null, "resolveFinalEndpointURL", "CURRENT_RETRY_DISTANCE_BAND", (Object)this.currentEndpointReference.getDistanceBand().toString());
        } else {
            logger.debug((URI)null, "resolveFinalEndpointURL", "{} {}", (Object)"CURRENT_ROUTE_OFFER", (Object)(this.currentEndpointReference.getRouteOffer() != null ? this.currentEndpointReference.getRouteOffer().getSearchFilter() : null));
            logger.debug((URI)null, "resolveFinalEndpointURL", "{} {}", (Object)"CURRENT_SEQUENCE", (Object)this.currentEndpointReference.getSequence());
            logger.debug((URI)null, "resolveFinalEndpointURL", "{} {}", (Object)"CURRENT_ENDPOINT", (Object)this.currentEndpointReference.getEndpoint().toURLString());
            logger.debug((URI)null, "resolveFinalEndpointURL", "{} {}", (Object)"CURRENT_DISTANCE_BAND", (Object)this.currentEndpointReference.getDistanceBand().toString());
        }
        if (this.currentEndpointReference.getRouteOffer() != null) {
            if (this.routeOfferBuffer.length() == 0) {
                this.routeOfferBuffer.append(this.currentEndpointReference.getRouteOffer().getSearchFilter());
            } else if (!this.routeOfferBuffer.toString().contains(this.currentEndpointReference.getRouteOffer().getSearchFilter())) {
                this.routeOfferBuffer.append(",");
                this.routeOfferBuffer.append(this.currentEndpointReference.getRouteOffer().getSearchFilter());
            }
        }
        if (this.getContext() != null && context.getUniformResource().getUrlType().equals((Object)DmeUniformResource.DmeUrlType.STANDARD)) {
            if (!this.matchServletPath(this.getContext(), context.getRequest().getSubContext(), this.currentEndpointReference.getEndpoint().getContextPath())) {
                return false;
            }
        } else if (context.getUniformResource() != null && !DmeUniformResource.DmeUrlType.DIRECT.equals((Object)context.getUniformResource().getUrlType()) && (service = context.getUniformResource().getService()) != null && service.contains("/")) {
            String cp = service.substring(service.indexOf("/"));
            if (!this.matchServletPath(cp, context.getUniformResource().getSubContext(), this.currentEndpointReference.getEndpoint().getContextPath())) {
                return false;
            }
            this.setContext(cp);
        }
        String hostFromArgs = this.config.getProperty("AFT_DME2_CONTAINER_HOST_KEY");
        if (this.preferLocal) {
            String epHost = this.currentEndpointReference.getEndpoint().getHost();
            if (epHost.equalsIgnoreCase(hostFromArgs) || DME2Utils.isHostMyLocalHost(hostFromArgs, this.config.getBoolean("DME2.DEBUG"))) {
                this.currentEndpointReference.getEndpoint().setHost(hostFromArgs);
                logger.debug(null, "LOAD_LOCAL_SEP_OK", this.currentEndpointReference.getEndpoint().toURLString());
            }
        } else {
            logger.debug(null, "LOAD_LOCAL_SEP_OK", this.currentEndpointReference.getEndpoint().toURLString());
        }
        this.setUrl(this.currentEndpointReference.getEndpoint().toURLString(this.getContext() == null ? context.getRequest().getContext() : this.getContext(), context.getRequest().getSubContext(), context.getRequest().getQueryParams()));
        this.isEndpointResolved = true;
        return this.isEndpointResolved;
    }

    private boolean matchServletPath(String context, String subContext, String endpointPaths) {
        String clientURLContext = context != null ? context : ("/" + subContext != null ? subContext : "");
        clientURLContext = clientURLContext.replaceAll("//", "/");
        String[] contextPaths = endpointPaths.split(",");
        if (contextPaths.length == 1 && contextPaths[0].equalsIgnoreCase("/")) {
            return true;
        }
        for (int j = 0; j < contextPaths.length; ++j) {
            String[] toks = contextPaths[j].split("/");
            StringBuffer pathToCompare = new StringBuffer();
            for (int i = 0; i < toks.length; ++i) {
                if (toks[i].length() <= 0) continue;
                if (toks[i].startsWith("{") && toks[i].endsWith("}")) {
                    pathToCompare.append("/.*");
                    continue;
                }
                if (toks[i].startsWith("(") && toks[i].endsWith(")")) {
                    pathToCompare.append("/.*");
                    continue;
                }
                pathToCompare.append("/" + toks[i]);
            }
            if (pathToCompare.length() <= 0 || !clientURLContext.matches(pathToCompare.toString())) continue;
            return true;
        }
        return false;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getCurrentFinalUrl() {
        return this.currentFinalUrl;
    }

    public void setCurrentFinalUrl(String currentFinalUrl) {
        this.currentFinalUrl = currentFinalUrl;
    }

    @Override
    public void sendAndWait(RequestContext context, DME2Payload payload) throws DME2Exception {
        this.send(context, payload);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.currentFinalUrl = url;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isPreferLocal() {
        return this.preferLocal;
    }

    public void setPreferLocal(boolean preferLocal) {
        this.preferLocal = preferLocal;
    }

    @Override
    public void retry(RequestContext context, DME2Payload payload) throws DME2Exception {
    }

    @Override
    public void failover(RequestContext context, DME2Payload payload) throws DME2Exception {
    }

    private String generateUniqueTransactionReference() {
        StringBuffer uniqueReference = new StringBuffer();
        uniqueReference.append(this.hashCode());
        uniqueReference.append("-");
        uniqueReference.append(UUID.randomUUID().toString());
        return uniqueReference.toString();
    }

    private IteratorMetricsEvent createIteratorMetricsEvent(String conversationId, String protocol, String serviceUri, String clientIp, RequestContext context) {
        String role = this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE");
        IteratorMetricsEvent iteratorMetricsEvent = new IteratorMetricsEvent();
        iteratorMetricsEvent.setClientIp(clientIp);
        iteratorMetricsEvent.setConversationId(conversationId);
        iteratorMetricsEvent.setProtocol(protocol);
        iteratorMetricsEvent.setRole(role);
        iteratorMetricsEvent.setServiceUri(serviceUri);
        iteratorMetricsEvent.setEventTime(System.currentTimeMillis());
        String partner = context.getRequest().getClientHeaders().get("DME2_REQUEST_PARTNER");
        if (partner == null) {
            partner = context.getRequest().getClientHeaders().get("com.att.aft.dme2.partner");
        }
        iteratorMetricsEvent.setPartner(partner);
        return iteratorMetricsEvent;
    }
}

