/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.jetty.http.HttpMethod;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.BinaryPayload;
import com.att.aft.dme2.request.DME2Payload;
import com.att.aft.dme2.request.DME2StreamPayload;
import com.att.aft.dme2.request.DME2TextPayload;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.request.FilePayload;
import com.att.aft.dme2.request.HttpRequest;
import com.att.aft.dme2.request.Request;
import com.att.aft.dme2.util.DME2UrlStreamHandler;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.ServiceValidationHelper;
import com.att.aft.dme2.util.UriHelper;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

public class RequestValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequestValidator.class.getName());

    public static void validate(DME2Configuration config, Request request) throws DME2Exception {
        URI encodedURI = null;
        URL encodedURL = null;
        String encodedStr = null;
        if (request == null) {
            throw new DME2Exception("AFT-DME2-0703", "Invalid request object", new Object[0]);
        }
        if (request.getLookupUri() == null || "".equals(request.getLookupUri().trim())) {
            throw new DME2Exception("AFT-DME2-0703", "Invalid URI", new Object[0]);
        }
        encodedStr = !request.isEncoded() ? UriHelper.encodeURIString(request.getLookupUri(), false) : UriHelper.encodeURIString(request.getLookupUri(), true);
        try {
            encodedURI = new URI(encodedStr);
            encodedURL = new URL(encodedURI.getScheme(), encodedURI.getHost(), encodedURI.getPort(), UriHelper.appendQueryStringToPath(encodedURI.getPath(), encodedURI.getQuery()), new DME2UrlStreamHandler());
        }
        catch (URISyntaxException e) {
            DME2Exception ex = new DME2Exception("AFT-DME2-0705", e);
            throw ex;
        }
        catch (MalformedURLException e) {
            DME2Exception ex = new DME2Exception("AFT-DME2-0705", e);
            throw ex;
        }
        ServiceValidationHelper.validateServiceStringIsNonJDBCURL(encodedURL.toString());
        DmeUniformResource dmeUri = new DmeUniformResource(config, encodedURL);
        if (dmeUri.getUrlType() != DmeUniformResource.DmeUrlType.DIRECT) {
            dmeUri.assertValid();
        }
        if (request.isPresentPreferLocalEPs()) {
            dmeUri.setPreferLocalEPs(request.isPreferLocalEPs());
        }
        if (request.isPresentUseVersionRange()) {
            dmeUri.setUseVersionRange(request.isUseVersionRange());
        }
        request.setUniformResource(dmeUri);
        if (request instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)request;
            if (httpRequest.isPresentExchangeRoundTripTimeOut()) {
                dmeUri.setRoundTripTimeout(httpRequest.getExchangeRoundTripTimeOut());
            }
            if (httpRequest.getHttpMethod() == null) {
                httpRequest.setHttpMethod(HttpMethod.POST.name());
            }
        }
    }

    public static void validate(DME2Payload payload) throws DME2Exception {
        String textPayload = null;
        Object streamPayLoad = null;
        byte[] bytePayload = null;
        List<String> multiPartFiles = null;
        InputStream streamPayload = null;
        FilePayload filePayload = null;
        if (payload != null) {
            if (payload instanceof DME2TextPayload) {
                textPayload = ((DME2TextPayload)payload).getPayload();
            } else if (payload instanceof FilePayload) {
                filePayload = (FilePayload)payload;
                if (filePayload.isMultipartPayload()) {
                    multiPartFiles = filePayload.getMultipartFileNamesWithPaths();
                }
            } else if (payload instanceof BinaryPayload) {
                bytePayload = ((BinaryPayload)payload).getPayload();
            } else if (payload instanceof DME2StreamPayload) {
                streamPayload = ((DME2StreamPayload)payload).getPayload();
            }
            if (textPayload == null && bytePayload == null && streamPayload == null && filePayload == null && (multiPartFiles == null || multiPartFiles.size() == 0)) {
                DME2Exception ex = new DME2Exception("AFT-DME2-0701", new ErrorContext());
                throw ex;
            }
        } else {
            DME2Exception ex = new DME2Exception("AFT-DME2-0701", new ErrorContext());
            throw ex;
        }
    }

    public static void validate(DME2Manager manager) throws DME2Exception {
        if (manager == null) {
            throw new DME2Exception("AFT-DME2-0706", "Invalid manager object", new Object[0]);
        }
    }
}

