/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.proxy;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.proxy.DME2IngressContinuationListener;
import com.att.aft.dme2.api.proxy.DME2IngressProxyReplyHandler;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.jetty.continuation.Continuation;
import com.att.aft.dme2.internal.jetty.continuation.ContinuationSupport;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DME2StreamPayload;
import com.att.aft.dme2.request.DME2TextPayload;
import com.att.aft.dme2.request.HttpRequest;
import com.att.aft.dme2.request.Request;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2URI;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.GuidGen;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DME2IngressProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = "com.att.aft.dme2.proxy.DME2IngressProxyServlet";
    private static Logger logger = LoggerFactory.getLogger("com.att.aft.dme2.proxy.DME2IngressProxyServlet");
    private static DME2Configuration config2 = new DME2Configuration("DME2IngressProxyServlet");
    final int MSG_PARSING_BUFFER = 8096;
    private DME2Manager manager;
    private String scldEnv = null;
    private boolean allowHttpReturnCode = false;
    private static final String REQUESTURI = "requestURI";

    public void destroy() {
        logger.info((URI)null, "destroy", LogMessage.PROXY_DESTROYED, (Object)CLASS_NAME, (Object)this.manager.getName());
    }

    public void init(ServletConfig config) throws ServletException {
        if (this.manager == null) {
            Enumeration parmNames = config.getInitParameterNames();
            Properties props = new Properties();
            while (parmNames.hasMoreElements()) {
                String name = (String)parmNames.nextElement();
                String value = config.getInitParameter(name);
                if (name == null || value == null) continue;
                props.setProperty(name, value);
            }
            this.scldEnv = System.getProperty("scldEnv");
            String mgrName = props.getProperty("com.att.aft.dme2.manager.name");
            DME2Configuration config2 = new DME2Configuration(mgrName);
            try {
                this.manager = mgrName != null ? new DME2Manager(mgrName, config2) : new DME2Manager(mgrName, config2);
            }
            catch (DME2Exception e) {
                throw new ServletException("Error initializing DME2Manager", (Throwable)e);
            }
        }
    }

    public void init() throws ServletException {
        if (this.manager != null) {
            this.manager = new DME2Manager();
        }
    }

    public DME2IngressProxyServlet(DME2Manager manager) {
        logger.debug(null, "ctor(DME2Manager)", LogMessage.METHOD_ENTER);
        this.manager = manager;
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service(req, resp);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug(null, "service", LogMessage.METHOD_ENTER);
        String convId = null;
        String username = null;
        String password = null;
        boolean streamMode = false;
        Continuation continuation = null;
        long endpointReadTimeout = 60000L;
        StringBuffer buf = new StringBuffer();
        String version = null;
        String routeOffer = null;
        String partner = null;
        String streamModeStr = null;
        String subContextStr = null;
        try {
            String healthCheck = req.getHeader("DME2HealthCheck");
            if (healthCheck != null) {
                resp.setStatus(200);
                return;
            }
            String queryString = req.getQueryString();
            HashMap<String, String> newQueryMap = new HashMap<String, String>();
            if (queryString != null) {
                String[] queryToks;
                for (String qtok : queryToks = queryString.split("&")) {
                    String[] pair = qtok.split("=");
                    if (pair.length != 2) continue;
                    String key = pair[0];
                    if (key.toLowerCase().equals("dme2.endpointreadtimeout")) {
                        String endpointReadTimeoutStr = pair[1];
                        try {
                            endpointReadTimeout = Long.parseLong(endpointReadTimeoutStr);
                        }
                        catch (Exception e) {
                            logger.debug((URI)null, "service", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                        }
                        if (endpointReadTimeout <= (long)Integer.parseInt(config2.getProperty(config2.getProperty("AFT_DME2_ENDPOINT_DEF_READ_TIMEOUT")))) continue;
                        endpointReadTimeout = Integer.parseInt(config2.getProperty(config2.getProperty("AFT_DME2_ENDPOINT_DEF_READ_TIMEOUT")));
                        continue;
                    }
                    if (key.toLowerCase().equals("dme2.username")) {
                        username = URLDecoder.decode(pair[1], "UTF-8");
                        continue;
                    }
                    if (key.toLowerCase().equals("dme2.password")) {
                        password = URLDecoder.decode(pair[1], "UTF-8");
                        continue;
                    }
                    if (key.toLowerCase().equals("dme2.convid")) {
                        convId = URLDecoder.decode(pair[1], "UTF-8");
                        continue;
                    }
                    if (key.toLowerCase().equals("dme2.streammode")) {
                        streamModeStr = URLDecoder.decode(pair[1], "UTF-8");
                        continue;
                    }
                    if (key.toLowerCase().equals("dme2.allowhttpcode")) {
                        this.allowHttpReturnCode = true;
                        continue;
                    }
                    if (key.toLowerCase().equals("subcontext")) {
                        subContextStr = pair[1];
                        continue;
                    }
                    if (key.toLowerCase().equals("version")) {
                        version = pair[1];
                        newQueryMap.put(key, pair[1]);
                        continue;
                    }
                    if (key.toLowerCase().equals("partner")) {
                        partner = pair[1];
                        newQueryMap.put(key, pair[1]);
                        continue;
                    }
                    if (key.toLowerCase().equals("routeoffer")) {
                        routeOffer = pair[1];
                        newQueryMap.put(key, pair[1]);
                        continue;
                    }
                    newQueryMap.put(key, pair[1]);
                }
            }
            if (streamModeStr != null) {
                if (streamModeStr.equalsIgnoreCase("true")) {
                    streamMode = true;
                }
            } else {
                streamMode = Boolean.getBoolean("DME2_PROXY_STREAM_MODE");
            }
            if (this.scldEnv != null && newQueryMap.get("envContext") == null) {
                newQueryMap.put("envContext", this.scldEnv);
            }
            String finalQueryString = this.genQueryString(newQueryMap);
            DME2URI uniformResource = null;
            String servletPath = req.getServletPath();
            if (servletPath != null) {
                String service = this.getServiceName(servletPath);
                if (service != null) {
                    String[] elems = service.split("/");
                    int i = elems.length;
                    if (i > 1) {
                        String versionStr = "version=" + this.getField(servletPath, "/version=");
                        String envContextStr = "envContext=" + this.getField(servletPath, "/envContext=");
                        if (subContextStr == null) {
                            subContextStr = this.getField(servletPath, "/subContext=");
                        }
                        String routeStr = this.getField(servletPath, "/partner=") != null ? "partner=" + this.getField(servletPath, "/partner=") : "routeOffer=" + this.getField(servletPath, "/routeOffer=");
                        String requestURI = "http://" + service + "?" + versionStr + "&" + envContextStr + "&" + routeStr + "&" + finalQueryString.replaceAll("//", "/");
                        uniformResource = new DME2URI(config2, requestURI);
                    } else {
                        String urlPath = (servletPath + "?" + finalQueryString).replaceAll("//", "/");
                        uniformResource = req.getServletPath().contains("routeOffer=") ? new DME2URI(config2, "http://DME2RESOLVE/" + urlPath) : new DME2URI(config2, "http://DME2SEARCH/" + urlPath);
                    }
                } else {
                    String requestURI = "http://" + req.getServerName() + "/" + (servletPath + "?" + finalQueryString).replaceAll("//", "/");
                    uniformResource = new DME2URI(config2, requestURI);
                }
            }
            logger.debug((URI)null, "service", " uniformResource : {}", (Object)uniformResource);
            if (convId == null) {
                convId = GuidGen.getId();
            }
            DME2Constants.setContext(convId, null);
            logger.info((URI)null, "service", "AFT-DME2-6600", (Object)new ErrorContext().add("requestFrom", req.getRemoteHost() + ":" + req.getRemotePort()).add("conversationID", convId).add(REQUESTURI, req.getRequestURI()));
            continuation = ContinuationSupport.getContinuation((ServletRequest)req, (ServletResponse)resp);
            continuation.setTimeout(endpointReadTimeout + 1000L);
            DME2IngressContinuationListener listener = new DME2IngressContinuationListener(convId, resp);
            continuation.addContinuationListener(listener);
            continuation.suspend((ServletResponse)resp);
            GZIPInputStream gis = null;
            String contentEncoding = req.getHeader(config2.getProperty("DME2_CONTENT_ENCODING_KEY"));
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase(config2.getProperty("DME2_CLIENT_COMPRESS_TYPE")) && Boolean.parseBoolean(config2.getProperty("DME2_CLIENT_ALLOW_COMPRESS"))) {
                try {
                    logger.debug((URI)null, "service", "AFT-DME2-6614", (Object)new ErrorContext().add("requestFrom", req.getRemoteHost() + ":" + req.getRemotePort()).add("contentEncoding", contentEncoding));
                    gis = new GZIPInputStream((InputStream)req.getInputStream());
                }
                catch (Exception e) {
                    continuation.resume();
                    logger.error((URI)null, "service", "AFT-DME2-6615", (Object)new ErrorContext().add(REQUESTURI, buf.toString()).add("errorCreatingGZIPStream", e.getMessage()), (Object)e);
                    resp.sendError(500, "UNABLE TO READ COMPRESSED INPUT MESSAGE;Message=" + e.getMessage());
                    resp.flushBuffer();
                    continuation.complete();
                }
            }
            StringBuilder output = new StringBuilder(8096);
            if (!streamMode) {
                InputStreamReader input = null;
                input = gis != null ? new InputStreamReader(gis) : new InputStreamReader((InputStream)req.getInputStream());
                char[] buffer = new char[8096];
                try {
                    int read = input.read(buffer, 0, buffer.length);
                    while (read != -1) {
                        output.append(buffer, 0, read);
                        read = input.read(buffer, 0, buffer.length);
                    }
                }
                catch (IOException e) {
                    continuation.resume();
                    logger.error((URI)null, "service", "AFT-DME2-6601", (Object)new ErrorContext().add(REQUESTURI, buf.toString()).add("initCause", e.getMessage()), (Object)e);
                    resp.sendError(500, "UNABLE TO READ INPUT MESSAGE;Message=" + e.getMessage());
                    resp.flushBuffer();
                    continuation.complete();
                    return;
                }
            }
            DME2Client client = null;
            String disableResponseStream = config2.getProperty("AFT_DME2_DISABLE_INGRESS_REPLY_STREAM", "false");
            Enumeration headerNames = req.getHeaderNames();
            HashMap<String, String> headerMap = new HashMap<String, String>();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String value = req.getHeader(headerName);
                headerMap.put(headerName, value);
            }
            logger.debug((URI)null, "service", " uniformResource.getOriginalURL().toString() : {}", (Object)uniformResource.getOriginalURI().toString());
            logger.debug((URI)null, "service", " uniformResource.getSubContext().toString() : {}", (Object)uniformResource.getSubContext());
            HttpRequest.RequestBuilder builder = (HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)new HttpRequest.RequestBuilder(new URI(uniformResource.getOriginalURI().toString())).withHttpMethod("POST").withReadTimeout(endpointReadTimeout)).withReturnResponseAsBytes(true)).withAuthCreds("myrealm", username, password)).withHeaders(headerMap).withLookupURL(uniformResource.getOriginalURI().toString());
            if (uniformResource.getSubContext() != null) {
                builder.withSubContext(uniformResource.getSubContext());
            }
            Request request = null;
            if (disableResponseStream.equalsIgnoreCase("true")) {
                builder.withReturnResponseAsBytes(false);
            } else {
                builder.withReturnResponseAsBytes(true);
            }
            if (gis != null) {
                builder.withHeader(config2.getProperty("DME2_ACCEPT_ENCODING_KEY"), config2.getProperty("DME2_CLIENT_COMPRESS_TYPE"));
            }
            if (subContextStr != null) {
                builder.withSubContext(subContextStr);
            }
            request = (Request)builder.build();
            client = new DME2Client(this.manager, request);
            client.setResponseHandlers(new DME2IngressProxyReplyHandler(uniformResource.toString(), continuation, convId, streamMode, config2));
            if (streamMode) {
                DME2StreamPayload payloadObj = new DME2StreamPayload((InputStream)req.getInputStream());
                client.send(payloadObj);
            } else {
                logger.debug((URI)null, "service", "Input from IngressProxy : {}", (Object)output.toString());
                client.send(new DME2TextPayload(output.toString(), req.getContentType()));
            }
        }
        catch (Exception e) {
            logger.error((URI)null, "service", "AFT-DME2-6602", (Object)new ErrorContext().add(REQUESTURI, buf.toString()).add("initCause", e.getMessage()), (Object)e);
            resp.sendError(500, e.getMessage());
            resp.flushBuffer();
            return;
        }
        catch (Throwable e) {
            logger.error((URI)null, "service", "AFT-DME2-6602", (Object)new ErrorContext().add(REQUESTURI, buf.toString()).add("initCause", e.getMessage()), (Object)e);
            resp.sendError(500, e.getMessage());
            resp.flushBuffer();
            return;
        }
    }

    private String genQueryString(Map<String, String> newQueryMap) {
        StringBuffer buf = new StringBuffer();
        for (String key : newQueryMap.keySet()) {
            if (buf.length() == 0) {
                buf.append(key + "=" + newQueryMap.get(key));
                continue;
            }
            buf.append("&" + key + "=" + newQueryMap.get(key));
        }
        return buf.toString();
    }

    private String getServiceName(String servletPath) {
        int indexOfNext;
        String serviceName = null;
        int indexOfService = -1;
        String serviceStr = "/service=";
        indexOfService = servletPath.indexOf(serviceStr);
        if (indexOfService != -1 && (indexOfNext = servletPath.indexOf("=", indexOfService + serviceStr.length())) != -1) {
            String temp = servletPath.substring(indexOfService, indexOfNext);
            String svc1 = temp.substring(temp.indexOf("=") + 1, temp.lastIndexOf("/"));
            return svc1;
        }
        return serviceName;
    }

    private String getField(String servletPath, String field) {
        int indexOfField = -1;
        indexOfField = servletPath.indexOf(field);
        if (indexOfField != -1) {
            int indexOfNext = servletPath.indexOf("=", indexOfField + field.length());
            if (indexOfNext != -1) {
                String temp = servletPath.substring(indexOfField, indexOfNext);
                String fieldVal = temp.substring(temp.indexOf("=") + 1, temp.lastIndexOf("/"));
                return fieldVal;
            }
            String fieldVal = servletPath.substring(indexOfField + field.length());
            return fieldVal;
        }
        return null;
    }

    public static void main(String[] a) {
    }
}

