/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.quick;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.DME2SimpleReplyHandler;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DME2TextPayload;
import com.att.aft.dme2.request.HttpRequest;
import com.att.aft.dme2.request.Request;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class QuickClient {
    private static final String USAGE = "usage: java com.att.aft.dme2.quick.QuickClient -t <timeout to wait for response> -s <service> { -m <message> | -f <inputfile> } [ -o <outputfile> ]";
    private static final Logger logger = LoggerFactory.getLogger(QuickClient.class);

    public static void main(String[] args) throws DME2Exception, InterruptedException {
        String service = null;
        String message = null;
        String file = null;
        String outFile = null;
        String timeoutStr = null;
        int loops = 1;
        boolean verbose = false;
        Long sleep = null;
        if (args.length == 0) {
            System.err.println(USAGE);
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-s")) {
                service = args[i + 1];
                continue;
            }
            if (arg.equals("-m")) {
                message = args[i + 1];
                continue;
            }
            if (arg.equals("-f")) {
                file = args[i + 1];
                continue;
            }
            if (arg.equals("-o")) {
                outFile = args[i + 1];
                continue;
            }
            if (arg.equals("-t")) {
                timeoutStr = args[i + 1];
                continue;
            }
            if (arg.equals("-l")) {
                loops = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (arg.equals("-v")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-sleep")) {
                sleep = Long.parseLong(args[i + 1]);
                continue;
            }
            if (!arg.equals("-?")) continue;
            System.err.println(USAGE);
            System.exit(0);
        }
        if (service == null) {
            QuickClient.fatal("-s <service> required", 1);
        }
        if (message == null && file == null) {
            QuickClient.fatal("-m <message> OR -f <inputfile> required", 2);
        }
        if (message != null && file != null) {
            QuickClient.fatal("Either -m <message> OR -f <inputfile> required, but both are not allowed", 3);
        }
        if (file != null) {
            File infile = new File(file);
            if (!infile.exists()) {
                QuickClient.fatal("Input file [" + file + "] does not exist", 4);
            }
            if (!infile.canRead()) {
                QuickClient.fatal("Input file [" + file + "] is not readable", 5);
            }
            message = new String(QuickClient.read(file));
        }
        logger.debug((URI)null, "main", "sleep={}", (Object)sleep);
        long timeout = Long.parseLong(timeoutStr);
        long start = System.currentTimeMillis();
        Long firstRequest = null;
        int successes = 0;
        int timeouts = 0;
        int fails = 0;
        for (int i = 0; i < loops; ++i) {
            try {
                long start2 = System.currentTimeMillis();
                DME2Configuration config = new DME2Configuration("QuickClient");
                DME2Manager manager = new DME2Manager("QuickClient", config);
                Object request = ((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)((HttpRequest.RequestBuilder)new HttpRequest.RequestBuilder(new URI(service)).withHttpMethod("POST").withReadTimeout(30000L)).withReturnResponseAsBytes(false)).withLookupURL(service)).build();
                DME2Client client = new DME2Client(manager, (Request)request);
                DME2SimpleReplyHandler replyHandler = new DME2SimpleReplyHandler(manager.getConfig(), "QuickClient", false);
                client.setResponseHandlers(replyHandler);
                client.send(new DME2TextPayload(message));
                String response = replyHandler.getResponse(timeout);
                long elapsed = System.currentTimeMillis() - start2;
                if (firstRequest == null) {
                    firstRequest = System.currentTimeMillis() - start;
                }
                if (outFile != null) {
                    QuickClient.write(new File(outFile), response);
                }
                if (verbose) {
                    System.out.println("[" + i + "] - " + elapsed + " - Response=" + response);
                }
                ++successes;
            }
            catch (DME2Exception e) {
                if (e.getMessage().toLowerCase().indexOf("timeout") > -1) {
                    ++timeouts;
                } else {
                    ++fails;
                }
                QuickClient.fatal("[" + i + "] - Error during call", e, 50, false);
            }
            catch (URISyntaxException e) {
                ++fails;
                QuickClient.fatal("[" + i + "] - URI invalid: ", e, 100, false);
            }
            catch (Exception e) {
                ++fails;
                QuickClient.fatal("[" + i + "] - Failure during call: ", e, 200, false);
            }
            if (sleep == null) continue;
            Thread.sleep(sleep);
        }
        long end = System.currentTimeMillis();
        long total = end - start;
        System.out.println("Fails: " + fails);
        System.out.println("Successes: " + successes);
        System.out.println("Timeouts: " + timeouts);
        System.out.println("Total Time Ms: " + total);
        System.out.println("Time per request: " + total / (long)loops);
        System.out.println("First request: " + firstRequest);
        System.out.println("TPS: " + (long)loops / (total / 1000L));
        Thread.sleep(2000L);
        System.exit(0);
    }

    public static final void fatal(String error, int rc) {
        System.err.println(USAGE);
        System.err.println("ERROR: " + error);
        System.exit(rc);
    }

    public static final void fatal(String error, Throwable e, int rc, boolean exit) {
        System.err.println(USAGE);
        System.err.println("ERROR: " + error + ": " + e.toString());
        e.printStackTrace();
        if (exit) {
            System.exit(rc);
        }
    }

    public static byte[] read(String fileName) {
        InputStream is = null;
        try {
            int offset;
            File file = new File(fileName);
            is = new FileInputStream(file);
            long length = file.length();
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new RuntimeException("Could not completely read file " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    logger.debug((URI)null, "read", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                }
            }
        }
    }

    public static void write(File outfile, String message) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(outfile);
            writer.write(message);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    logger.debug((URI)null, "write", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                }
            }
        }
    }
}

