/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.util.PortFileLockManager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Date;
import java.util.Properties;

public class DME2PortFileManager {
    private static final Logger logger = LoggerFactory.getLogger(DME2PortFileManager.class);
    private static DME2PortFileManager instance;
    private DME2Configuration config;
    private static String portCacheFilePath;
    private static String sslPortCacheFilePath;
    private File portFile;
    private File sslPortFile;
    private static final String PORT = "Port";
    private static final String SERVICE = "Service";

    private DME2PortFileManager(DME2Configuration config) {
        try {
            File file1;
            File dir1;
            this.config = config;
            portCacheFilePath = config.getProperty("AFT_DME2_PORT_CACHE_FILE", System.getProperty("user.home") + "/.aft/.dme2PortCache");
            File file = new File(portCacheFilePath);
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(dir1 = (file1 = new File(sslPortCacheFilePath = config.getProperty("AFT_DME2_SSL_PORT_CACHE_FILE", System.getProperty("user.home") + "/.aft/.dme2PortCache-ssl"))).getParentFile()).exists()) {
                dir1.mkdirs();
            }
            this.portFile = new File(portCacheFilePath);
            this.sslPortFile = new File(sslPortCacheFilePath);
        }
        catch (Exception e) {
            logger.error((URI)null, "DME2PortFileManager", "AFT-DME2-6704", (Object)new ErrorContext().add("DME2PortFileManager", ""), (Object)e);
        }
    }

    public static synchronized DME2PortFileManager getInstance(DME2Configuration config) {
        if (instance == null) {
            instance = new DME2PortFileManager(config);
        }
        return instance;
    }

    public String getPort(String service, boolean sslEnabled) {
        if (!this.config.getBoolean("AFT_DME2_ALLOW_PORT_CACHING", true)) {
            return null;
        }
        logger.debug((URI)null, "getPort", "DME2PortFileManager.getPort Service={}; sslEnabled={}", (Object)service, (Object)sslEnabled);
        if (service == null) {
            return null;
        }
        String port = null;
        try {
            if (sslEnabled) {
                port = this.getPortFromFile(service, this.sslPortFile);
                logger.debug(null, "getPort", "DME2PortFileManager.getPort Service={}; sslEnabled={};sslPortFile lookup port={};sslPortFile name={}", service, sslEnabled, port, this.sslPortFile.getAbsolutePath());
            } else {
                port = this.getPortFromFile(service, this.portFile);
                logger.debug(null, "getPort", "DME2PortFileManager.getPort Service={}; sslEnabled={};portFile lookup port={};portFile name={}", service, sslEnabled, port, this.portFile.getAbsolutePath());
            }
            return port;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getPortFromFile(String service, File fileName) {
        String port = null;
        FileInputStream in = null;
        Properties props = new Properties();
        if (this.portFile.exists()) {
            try {
                in = new FileInputStream(fileName);
                props.load(in);
            }
            catch (Exception e) {
                return null;
            }
        }
        if ((port = props.getProperty(service)) != null) {
            logger.debug((URI)null, "DME2PortFileManager", "AFT-DME2-6703", (Object)new ErrorContext().add(SERVICE, service).add(PORT, String.valueOf(port)));
            return port;
        }
        return port;
    }

    private PortFileLockManager acquireLock(String path, long lockWaitIterations, long lockWaitSleepInterval) throws Exception {
        PortFileLockManager pfm = PortFileLockManager.getInstance(path, lockWaitIterations, lockWaitSleepInterval);
        pfm.acquire();
        return pfm;
    }

    public synchronized void persistPort(String service, Integer port, boolean sslEnabled) throws DME2Exception {
        if (!this.config.getBoolean("AFT_DME2_ALLOW_PORT_CACHING", true)) {
            return;
        }
        FileInputStream in = null;
        PortFileLockManager pfm = null;
        if (service == null || port == null) {
            return;
        }
        try {
            Properties props = new Properties();
            File file = null;
            file = sslEnabled ? this.sslPortFile : this.portFile;
            if (file.exists()) {
                in = new FileInputStream(file);
                props.load(in);
            } else {
                props.store(new FileOutputStream(file), "Initial creation--" + new Date());
                in = new FileInputStream(file);
            }
            pfm = sslEnabled ? this.acquireLock(sslPortCacheFilePath, this.config.getLong("AFT_DME2_PORT_FILELOCK_WAIT_ITER"), this.config.getLong("AFT_DME2_PORT_FILELOCK_WAIT_INTERVAL")) : this.acquireLock(portCacheFilePath, this.config.getLong("AFT_DME2_PORT_FILELOCK_WAIT_ITER"), this.config.getLong("AFT_DME2_PORT_FILELOCK_WAIT_INTERVAL"));
            String portStr = props.getProperty(service);
            if (portStr != null) {
                if (!portStr.contains(String.valueOf(port))) {
                    props.setProperty(service, portStr + "," + String.valueOf(port));
                    props.store(new FileOutputStream(file), "Published by DME2 at --" + new Date());
                } else {
                    logger.debug((URI)null, "DME2PortFileManager", "AFT-DME2-6701", (Object)new ErrorContext().add(SERVICE, service).add(PORT, String.valueOf(port)));
                }
            } else {
                props.setProperty(service, String.valueOf(port));
                props.store(new FileOutputStream(file), "Published by DME2 at --" + new Date());
            }
            logger.debug((URI)null, "DME2PortFileManager", "AFT-DME2-6702", (Object)new ErrorContext().add(SERVICE, service).add(PORT, String.valueOf(port)));
        }
        catch (Exception e) {
            logger.error((URI)null, "DME2PortFileManager", "AFT-DME2-6700", (Object)new ErrorContext().add(SERVICE, service).add(PORT, String.valueOf(port)), (Object)e);
            throw new DME2Exception("AFT-DME2-6700", new ErrorContext().add(SERVICE, service).add(PORT, String.valueOf(port)), (Throwable)e);
        }
        finally {
            if (pfm != null) {
                try {
                    pfm.release();
                }
                catch (Exception e) {
                    logger.debug((URI)null, "DME2PortFileManager", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                }
            }
        }
    }

    static {
        portCacheFilePath = null;
        sslPortCacheFilePath = null;
    }
}

