/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class DME2ProximityAide {
    public static final double CALCULATED_DISTANCE_MAX = 20000.0;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    private static double clientLatitudeRadians = 0.6736970912698113;
    private static double clientLongitudeRadians = -1.5742869852988852;
    public static final double EARTH_RADIUS_IN_KILOMETERS = 6373.0;
    private double[] DISTANCEBANDS = null;
    private static final double[] DISTANCE_BANDS_DEFAULT = new double[]{0.1, 500.0, 5000.0, 20000.0};
    private int DISTANCECACHESIZE;
    private final ConcurrentMap<String, Double> distanceMap = new ConcurrentHashMap<String, Double>();
    private final ConcurrentLinkedQueue<String> distanceQueue = new ConcurrentLinkedQueue();

    private double calculateDistance(double serviceLatitudeDegrees, double serviceLongitudeDegrees) {
        double serviceLatitudeRadians = serviceLatitudeDegrees * (Math.PI / 180);
        double serviceLongitudeRadians = serviceLongitudeDegrees * (Math.PI / 180);
        double deltaLatitude = serviceLatitudeRadians - clientLatitudeRadians;
        double deltaLongitude = serviceLongitudeRadians - clientLongitudeRadians;
        double a = Math.pow(Math.sin(deltaLatitude / 2.0), 2.0) + Math.cos(clientLatitudeRadians) * Math.cos(serviceLatitudeRadians) * Math.pow(Math.sin(deltaLongitude / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6373.0;
    }

    private String getDistanceKey(double serviceLatitudeDegrees, double serviceLongitudeDegrees) {
        return new StringBuffer(32).append(serviceLatitudeDegrees).append(',').append(serviceLongitudeDegrees).toString();
    }

    public double getDistanceTo(double serviceLatitudeDegrees, double serviceLongitudeDegrees) {
        double result = -1.0;
        String distanceKey = this.getDistanceKey(serviceLatitudeDegrees, serviceLongitudeDegrees);
        Double cachedDistance = (Double)this.distanceMap.get(distanceKey);
        if (cachedDistance == null) {
            result = this.calculateDistance(serviceLatitudeDegrees, serviceLongitudeDegrees);
            this.setDistanceTo(serviceLatitudeDegrees, serviceLongitudeDegrees, result);
        } else {
            result = cachedDistance;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDistanceTo(double serviceLatitudeDegrees, double serviceLongitudeDegrees, double distanceValue) {
        String distanceKey = this.getDistanceKey(serviceLatitudeDegrees, serviceLongitudeDegrees);
        this.distanceMap.put(distanceKey, distanceValue);
        this.distanceQueue.add(distanceKey);
        int distanceQueueSize = this.distanceQueue.size();
        if (distanceQueueSize > this.DISTANCECACHESIZE) {
            ConcurrentLinkedQueue<String> concurrentLinkedQueue = this.distanceQueue;
            synchronized (concurrentLinkedQueue) {
                if (distanceQueueSize > 0) {
                    String cachedDistanceKey = (String)this.distanceQueue.remove();
                    this.distanceMap.remove(cachedDistanceKey);
                }
            }
        }
    }

    public DME2ProximityAide(double clientLatitudeDegrees, double clientLongitudeDegrees, int distanceCacheSize, double[] distanceBands, boolean isExcludingOutOfBandEndpoints) {
        clientLatitudeRadians = clientLatitudeDegrees * (Math.PI / 180);
        clientLongitudeRadians = clientLongitudeDegrees * (Math.PI / 180);
        this.DISTANCECACHESIZE = distanceCacheSize;
        if (distanceBands != null) {
            int length = distanceBands.length;
            if (distanceBands[length - 1] >= 20000.0 || isExcludingOutOfBandEndpoints) {
                this.DISTANCEBANDS = new double[length];
                System.arraycopy(distanceBands, 0, this.DISTANCEBANDS, 0, length);
            } else {
                this.DISTANCEBANDS = new double[length + 1];
                System.arraycopy(distanceBands, 0, this.DISTANCEBANDS, 0, length);
                this.DISTANCEBANDS[length] = 20000.0;
            }
        } else {
            this.DISTANCEBANDS = DISTANCE_BANDS_DEFAULT;
        }
    }

    public double[] getDistanceBands() {
        return this.DISTANCEBANDS;
    }
}

