/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.mbean.DME2ThrottleMXBean;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;

public class DME2ThrottleConfig
implements DME2ThrottleMXBean {
    private static volatile DME2ThrottleConfig dme2ThrottleConfig;
    private static Properties props;
    private static Logger logger;
    private Float defthrottlePctPerPartner;
    private DME2Configuration config;

    public DME2ThrottleConfig(DME2Configuration configuration) {
        logger.debug(null, "ctor", LogMessage.METHOD_ENTER);
        this.config = configuration;
        this.defthrottlePctPerPartner = Float.valueOf(this.config.getFloat("AFT_DME2_THROTTLE_PCT_PER_PARTNER"));
        logger.debug((URI)null, "ctor", "defthrottlePctPerPartner is {}", (Object)this.defthrottlePctPerPartner);
        logger.debug(null, "ctor", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DME2ThrottleConfig getInstance(DME2Configuration configuration, String fileName) {
        DME2ThrottleConfig result = dme2ThrottleConfig;
        if (result != null) return result;
        Class<DME2ThrottleConfig> clazz = DME2ThrottleConfig.class;
        synchronized (DME2ThrottleConfig.class) {
            result = dme2ThrottleConfig;
            if (result != null) return result;
            try {
                dme2ThrottleConfig = result = new DME2ThrottleConfig(configuration);
                props = DME2ThrottleConfig.loadProps(fileName);
            }
            catch (Exception e) {
                logger.error(null, "getInstance", "Error loading throttle config");
                throw e;
            }
            return result;
        }
    }

    public static DME2ThrottleConfig getInstance() {
        return dme2ThrottleConfig;
    }

    public void registerForRefresh() {
    }

    public float getThrottleConfig(String service, String partner) {
        logger.debug(null, "getThrottleConfig", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "getThrottleConfig", "Get throttle for service {} and partner {}", (Object)service, (Object)partner);
        if (props != null && service != null & partner != null) {
            String throttle = (String)props.get(service + "." + partner);
            if (throttle != null) {
                logger.debug((URI)null, "getThrottleConfig", "Throttle: {}", (Object)throttle);
                return Float.parseFloat(throttle);
            }
            logger.debug(null, "getThrottleConfig", "Throttle null");
            return -1.0f;
        }
        logger.debug(null, "getThrottleConfig", "Throttle 0");
        return 0.0f;
    }

    @Override
    public float getThrottleConfigForPartner(String service, String partner) {
        return this.getThrottleConfig(service, partner);
    }

    @Override
    public void setThrottleConfigForPartner(String service, String partner, float value) {
        logger.debug(null, "setThrottleConfigForPartner", LogMessage.METHOD_ENTER);
        logger.debug(null, "setThrottleConfigForPartner", "Service: {} Partner: {} Value: {}", service, partner, Float.valueOf(value));
        if (value > 0.0f && value <= 100.0f) {
            props.setProperty(service + "." + partner, String.valueOf(value));
        }
        logger.debug(null, "setThrottleConfigForPartner", LogMessage.METHOD_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProps(String fileName) {
        ClassLoader[] cls = new ClassLoader[]{ClassLoader.getSystemClassLoader(), DME2ThrottleConfig.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        Properties props = new Properties();
        boolean loaded = false;
        for (ClassLoader cl : cls) {
            InputStream in = cl.getResourceAsStream(fileName);
            logger.debug((URI)null, "loadProps", "Loading from: {}", (Object)cl.getResource(fileName));
            if (in == null) continue;
            try {
                logger.debug((URI)null, "loadProps", "Loading {}: {}", (Object)cl.toString(), (Object)fileName);
                props.load(in);
                loaded = true;
                in.close();
                break;
            }
            catch (IOException e) {
                logger.error((URI)null, "loadProps", "Exception", (Object)e);
            }
        }
        if (loaded) {
            return props;
        }
        InputStream in = null;
        try {
            logger.debug((URI)null, "loadProps", "Loading props from: {}", (Object)fileName);
            in = new FileInputStream(fileName);
            props.load(in);
            logger.debug((URI)null, "loadProps", "Successfully Loaded throttling props from: {}", (Object)fileName);
        }
        catch (IOException e) {
            logger.debug((URI)null, "loadProps", "Exception", (Object)e);
            logger.debug((URI)null, "loadProps", "Error loading throttling props from: {},  using default throttle setting", (Object)fileName);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.debug((URI)null, "loadProps", "IOException", (Object)e);
                }
            }
        }
        return props;
    }

    static {
        props = new Properties();
        logger = LoggerFactory.getLogger(DME2ThrottleConfig.class.getName());
    }
}

