/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.api.DME2ServiceHolder;
import com.att.aft.dme2.api.util.DME2ThrottleConfig;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.lang.StringUtils;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PartnerActiveRequestCounter {
    private static final Logger logger = LoggerFactory.getLogger(PartnerActiveRequestCounter.class);
    private DME2Configuration config;
    private DME2ServiceHolder dme2ServiceHolder;
    private final ConcurrentMap<String, AtomicInteger> partnerVsCurrActiveReqCount = new ConcurrentHashMap<String, AtomicInteger>();
    private DME2ThrottleConfig throttleConfig = DME2ThrottleConfig.getInstance();
    private String serviceName = null;
    private static String SERVICE = "/service=";
    private static String SERVICE2 = "service=";

    public PartnerActiveRequestCounter(DME2ServiceHolder dme2ServiceHolder) {
        this.dme2ServiceHolder = dme2ServiceHolder;
        this.config = dme2ServiceHolder.getManager().getConfig();
        this.serviceName = this.getService(dme2ServiceHolder.getServiceURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPartnerWithinMaxAllowedActiveRequests(String requestPartnerName) {
        boolean partnerWithinMaxAllowedRequests = true;
        int maxActiveRequestsPerPartner = this.getMaxActiveRequestsPerPartner(requestPartnerName);
        if (StringUtils.isNotBlank(requestPartnerName) && maxActiveRequestsPerPartner > 0) {
            AtomicInteger atomicInteger;
            logger.debug((URI)null, "isPartnerWithinMaxAllowedActiveRequests", "DME2ThrottleFilter validating request count with maxActive={} partner = {}", (Object)maxActiveRequestsPerPartner, (Object)requestPartnerName);
            this.partnerVsCurrActiveReqCount.putIfAbsent(requestPartnerName, new AtomicInteger(0));
            AtomicInteger atomicInteger2 = atomicInteger = (AtomicInteger)this.partnerVsCurrActiveReqCount.get(requestPartnerName);
            synchronized (atomicInteger2) {
                int requestCount = atomicInteger.get() + 1;
                if (requestCount > maxActiveRequestsPerPartner) {
                    logger.debug((URI)null, "isPartnerWithinMaxAllowedActiveRequests", "Request count {} exceeds maxActiveRequestsPerPartner {}", (Object)requestCount, (Object)maxActiveRequestsPerPartner);
                    partnerWithinMaxAllowedRequests = false;
                } else {
                    atomicInteger.incrementAndGet();
                    logger.debug((URI)null, "isPartnerWithinMaxAllowedActiveRequests", "DME2ThrottleFilter Increment:: Request count for partner {} is {}", (Object)requestPartnerName, (Object)atomicInteger.get());
                }
                logger.debug((URI)null, "isPartnerWithinMaxAllowedActiveRequests", "currentRequestCount:{}; maxRequestCountAllowed:{}", (Object)atomicInteger.get(), (Object)maxActiveRequestsPerPartner);
            }
        }
        return partnerWithinMaxAllowedRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementPartnerRequestCount(String requestPartnerName) {
        AtomicInteger requestCount;
        if (StringUtils.isNotBlank(requestPartnerName) && (requestCount = (AtomicInteger)this.partnerVsCurrActiveReqCount.get(requestPartnerName)) != null) {
            AtomicInteger atomicInteger = requestCount;
            synchronized (atomicInteger) {
                int valueAfterDecrement = requestCount.decrementAndGet();
                logger.debug((URI)null, "decrementPartnerRequestCount", "DME2ThrottleFilter Decrement:: Request count for partner {} is {}", (Object)requestPartnerName, (Object)valueAfterDecrement);
                if (valueAfterDecrement == 0) {
                    logger.debug(null, "decrementPartnerRequestCount", "DME2ThrottleFilter value after dec is 0 hence removing");
                    this.partnerVsCurrActiveReqCount.remove(requestPartnerName);
                }
            }
        }
    }

    private Integer getMaxActiveRequestsPerPartner(String requestPartnerName) {
        int maxActiveRequestsPerPartner = 0;
        try {
            if (this.dme2ServiceHolder != null) {
                int maxPoolSize = this.dme2ServiceHolder.getMaxPoolSize();
                logger.debug((URI)null, "getMaxActiveRequestsPerPartner", "DME2Throttle getMaxActiveRequestsPerPartner:: Max pool size {}", (Object)maxPoolSize);
                Float partnerThrottlePct = this.getThrottlePercentPerPartner(requestPartnerName);
                maxActiveRequestsPerPartner = (int)Math.ceil((double)maxPoolSize * ((double)partnerThrottlePct.floatValue() / 100.0));
            }
        }
        catch (Exception exception) {
            logger.error((URI)null, "getMaxActiveRequestsPerPartner", LogMessage.DEBUG_MESSAGE, (Object)exception.getMessage());
        }
        logger.debug((URI)null, "getMaxActiveRequestsPerPartner", "DME2ThrottleFilter is max active req per partner = {}", (Object)maxActiveRequestsPerPartner);
        return maxActiveRequestsPerPartner;
    }

    private Float getThrottlePercentPerPartner(String requestPartnerName) {
        logger.debug(null, "getThrottlePercentPerPartner", LogMessage.METHOD_ENTER);
        Float partnerThrottlePct = Float.valueOf(DME2ThrottleConfig.getInstance().getThrottleConfig(this.serviceName, requestPartnerName));
        if (partnerThrottlePct == null || partnerThrottlePct.floatValue() <= 0.0f) {
            partnerThrottlePct = this.dme2ServiceHolder.getThrottlePctPerPartner();
            logger.debug((URI)null, "getThrottlePercentPerPartner", "After service holder, throttle filter pct: {}", (Object)partnerThrottlePct);
        }
        if (partnerThrottlePct == null || partnerThrottlePct.floatValue() <= 0.0f) {
            partnerThrottlePct = Float.valueOf(this.config.getFloat("AFT_DME2_THROTTLE_PCT_PER_PARTNER"));
        }
        logger.debug((URI)null, "getThrottlePercentPerPartner", "DME2ThrottleFilter throttle pct for partner: {}={}", (Object)requestPartnerName, (Object)partnerThrottlePct);
        logger.debug(null, "getThrottlePercentPerPartner", LogMessage.METHOD_EXIT);
        return partnerThrottlePct;
    }

    private String getService(String servletPath) {
        String fieldsWithSlash = this.config.getProperty("DME2_URI_FIELD_WITH_PATH_SEP", "/service=,/subContext=");
        boolean canEndWithSlash = false;
        if (fieldsWithSlash != null) {
            canEndWithSlash = fieldsWithSlash.contains(SERVICE);
        }
        return this.getService(servletPath, canEndWithSlash);
    }

    private String getService(String servletPath, boolean canEndWithSlash) {
        int indexOfField = -1;
        String field = SERVICE;
        if (servletPath.startsWith("/")) {
            indexOfField = servletPath.toLowerCase().indexOf(SERVICE);
        } else {
            indexOfField = servletPath.toLowerCase().indexOf(SERVICE2);
            field = SERVICE2;
        }
        if (indexOfField != -1) {
            try {
                String fieldVal = null;
                int indexOfNext = servletPath.indexOf("=", indexOfField + field.length());
                if (indexOfNext != -1) {
                    String temp = servletPath.substring(indexOfField, indexOfNext);
                    fieldVal = temp.substring(temp.indexOf("=") + 1, temp.lastIndexOf("/"));
                } else {
                    fieldVal = !canEndWithSlash && servletPath.endsWith("/") ? servletPath.substring(indexOfField + field.length(), servletPath.length() - 1) : servletPath.substring(indexOfField + field.length());
                }
                if (!canEndWithSlash && fieldVal != null && fieldVal.contains("/")) {
                    fieldVal = fieldVal.replaceAll("/", "");
                }
                if (fieldVal != null && fieldVal.contains("/") && fieldVal.replaceAll("/", "").length() == fieldVal.length() - 1 && fieldVal.indexOf("/") == fieldVal.length() - 1) {
                    fieldVal = fieldVal.replace("/", "");
                }
                return fieldVal != null ? (fieldVal.length() > 0 ? fieldVal : null) : null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

