/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.lang.StringUtils;
import com.att.aft.dme2.util.ErrorContext;

public class SecurityContext {
    private final String username;
    private final String password;
    private boolean isSSL;

    private SecurityContext(String username, String password, boolean isSSL) throws DME2Exception {
        this.username = username;
        this.password = password;
        this.isSSL = isSSL;
        if (StringUtils.isEmpty(username) || StringUtils.isEmpty(password)) {
            ErrorContext error = new ErrorContext();
            error.add("username", username);
            error.add("password", password);
            throw new DME2Exception("AFT-DME2-0917", error);
        }
    }

    public static SecurityContext create(String username, String password, boolean isSSL) throws DME2Exception {
        return new SecurityContext(username, password, isSSL);
    }

    public static SecurityContext create(DME2Configuration config) throws DME2Exception {
        String user = config.getProperty("DME2_GRM_USER");
        String pass = config.getProperty("DME2_GRM_PASS");
        return new SecurityContext(user, pass, false);
    }

    public void setSSL(boolean isSSL) {
        this.isSSL = isSSL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isSSL ? 1231 : 1237);
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityContext)) {
            return false;
        }
        SecurityContext other = (SecurityContext)obj;
        if (this.isSSL != other.isSSL) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "SecurityContext [username=" + this.username + ", password=" + this.password + ", isSSL=" + this.isSSL + "]";
    }
}

