/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.DME2CacheStats;
import com.att.aft.dme2.cache.DME2CacheStatsHolder;
import com.att.aft.dme2.cache.domain.CacheConfiguration;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.domain.CacheTypeElement;
import com.att.aft.dme2.cache.domain.CacheTypes;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.service.CacheEntryView;
import com.att.aft.dme2.cache.service.CacheSerialization;
import com.att.aft.dme2.cache.service.CacheTaskScheduler;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.factory.DME2CacheFactory;
import com.att.aft.dme2.hazelcast.core.HazelcastInstanceNotActiveException;
import com.att.aft.dme2.internal.apache.commons.lang3.tuple.Pair;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2ServiceEndpointData;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCache<M>
implements DME2Cache,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCache.class.getName());
    private DME2Configuration config = null;
    private boolean enableCacheStats = true;
    protected CacheConfiguration cacheConfig = null;
    protected CacheTypeElement cacheTypeElementConfig = null;
    protected final Map<String, CacheTaskScheduler> cacheScheduleTaskRegister = new HashMap<String, CacheTaskScheduler>();
    protected CacheSerialization cacheSerializer = null;
    private long infrequentEndpointCacheTTL;
    private long endpointLastQueriedInterval;
    private final long[] emptyCacheTTLRefreshDefaultIntervals = new long[]{300000L, 300000L, 300000L, 600000L, 900000L};
    private long endpointCacheEmptyTTL;
    private long cacheEntryTTL;
    private long[] emptyCacheTTLRefreshIntervals;
    private final Map<String, DME2CacheStatsHolder> cacheStats = Collections.synchronizedMap(new HashMap());
    private final byte[] lock = new byte[0];
    private final byte[] hashlock = new byte[0];

    public AbstractCache(String cacheName, String cacheType, DME2CacheableCallback source, DME2Configuration config) {
        LOGGER.debug(null, "AbstractCache", "start");
        this.config = config;
        this.cacheTypeElementConfig = CacheTypes.getType(cacheType, config);
        if (this.cacheTypeElementConfig == null) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_018, cacheType);
        }
        this.cacheConfig = CacheConfiguration.getInstance();
        this.cacheConfig.setCacheName(cacheName);
        this.cacheConfig.setDataLoader(DME2CacheFactory.getDataHandler(this.cacheTypeElementConfig));
        this.cacheConfig.setCacheType(this.cacheTypeElementConfig);
        this.cacheConfig.setSource(source);
        this.initializeVariables();
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    public AbstractCache(CacheConfiguration cacheConfig) {
        this.cacheConfig = cacheConfig;
        this.initializeVariables();
    }

    public void initializeVariables() {
        this.endpointLastQueriedInterval = this.config.getLong("DME2_SERVICE_LAST_QUERIED_INTERVAL_MS", 900000L);
        this.infrequentEndpointCacheTTL = this.config.getLong("DME2_SEP_CACHE_INFREQUENT_TTL_MS", 1800000L);
        this.endpointCacheEmptyTTL = this.config.getLong("DME2_SEP_CACHE_EMPTY_TTL_MS", 300000L);
        long l = this.getCacheConfig().getCacheType().getTtl() > 0L ? this.getCacheConfig().getCacheType().getTtl() : (this.cacheEntryTTL = (long)(AbstractCache.isEndpointCache(this) || AbstractCache.isRouteInfoCache(this) ? 300000 : 900000));
        if (AbstractCache.isEndpointCache(this) && this.config.getLong("DME2_SEP_CACHE_TTL_MS", -1L) > 0L) {
            this.cacheEntryTTL = this.config.getLong("DME2_SEP_CACHE_TTL_MS");
        } else if (AbstractCache.isStaleEndpointCache(this) && this.config.getLong("AFT_DME2_CLIENT_ENDPOINT_STALENESS_PERIOD_MS", -1L) > 0L) {
            this.cacheEntryTTL = this.config.getLong("AFT_DME2_CLIENT_ENDPOINT_STALENESS_PERIOD_MS");
        } else if (AbstractCache.isRouteInfoCache(this) && this.config.getInt("DME2_ROUTEINFO_CACHE_TTL_MS", -1) > 0) {
            this.cacheEntryTTL = this.config.getInt("DME2_ROUTEINFO_CACHE_TTL_MS");
        }
        LOGGER.debug((URI)null, "initialize variable", "cache entry ttl initialized: [{}]", (Object)this.cacheEntryTTL);
        this.emptyCacheTTLRefreshIntervals = this.getEmptyCacheTTLIntervalsFromProperties(this.config.getProperty("DME2_SEP_EMPTY_CACHE_TTL_INTERVALS", null), this.emptyCacheTTLRefreshDefaultIntervals);
    }

    protected DME2Configuration getConfig() {
        return this.config;
    }

    protected void init() {
        LOGGER.debug(null, "init", "start");
        this.warmUpCache();
        this.createCacheSerializerTimer();
        this.createCacheRefreshTimer();
        this.createCacheRemoveUnusedEndpoints();
        LOGGER.debug(null, "init", "complete");
    }

    protected void createCacheRemoveUnusedEndpoints() {
        long unused_ep_removal_delay = -1L;
        unused_ep_removal_delay = this.getCacheConfig().getCacheType() != null && this.getCacheConfig().getCacheType().getIdleTimeoutCheckInterval() > 0L ? this.getCacheConfig().getCacheType().getIdleTimeoutCheckInterval() : 300000L;
        unused_ep_removal_delay = this.getConfig().getLong("DME2_UNUSED_ENDPOINT_REMOVAL_DELAY", unused_ep_removal_delay);
        if (unused_ep_removal_delay > 0L) {
            LOGGER.debug((URI)null, "createCacheRemoveUnusedEndpoints", "cache element idle timeout - cache: [{}], [{}]", (Object)this.getCacheName(), (Object)unused_ep_removal_delay);
            this.createScheduledTask("CacheRemoveUnusedEndpoints::" + this.getCacheName(), true, unused_ep_removal_delay, this, "checkNRemoveUnusedEndpoints");
        }
    }

    public void checkNRemoveUnusedEndpoints() {
        try {
            HashSet<CacheElement.Key> keyRemovalSet = new HashSet<CacheElement.Key>();
            long unused_ep_timeout_ms = -1L;
            unused_ep_timeout_ms = this.getCacheConfig().getCacheType().getIdleTimeout() > 0L ? this.getCacheConfig().getCacheType().getIdleTimeout() : 259200000L;
            unused_ep_timeout_ms = this.getConfig().getLong("DME2_UNUSED_ENDPOINT_REMOVAL_DURATION_MS", unused_ep_timeout_ms);
            if (unused_ep_timeout_ms > 0L) {
                for (CacheElement.Key key : this.getKeySet()) {
                    CacheElement element = this.getEntryView().getEntry(key);
                    if (element == null) continue;
                    long lastQueried = element.getLastAccessedTime();
                    LOGGER.debug((URI)null, "checkNRemoveUnusedEndpoints", "current idle time: [{}]", (Object)(System.currentTimeMillis() - lastQueried));
                    if (System.currentTimeMillis() - lastQueried <= unused_ep_timeout_ms) continue;
                    LOGGER.debug((URI)null, "checkNRemoveUnusedEndpoints", "Removing endpoints for  {}  after unused interval of {}ms", (Object)element.getValue(), (Object)unused_ep_timeout_ms);
                    keyRemovalSet.add(key);
                    LOGGER.debug(null, "checkNRemoveUnusedEndpoints", "[{}]={}; idle timeout= {}", element.getKey(), element.getValue(), unused_ep_timeout_ms);
                }
                for (CacheElement.Key<Object> key : keyRemovalSet) {
                    this.remove(key);
                }
            } else {
                LOGGER.warn(null, "checkNRemoveUnusedEndpoints", "interval for removing unused endpoints is not properly set");
            }
        }
        catch (Exception e) {
            LOGGER.debug((URI)null, "checkNRemoveUnusedEndpoints", "Error [{}] occurred while checking and removing unused cache entries", (Object)e);
        }
    }

    protected void createCacheRemoveExpiredEntries() {
        if (this.getCacheConfig().getCacheType() != null && this.getCacheConfig().getCacheType().getCleanupIntervalMS() > 0L) {
            LOGGER.debug((URI)null, "createCacheRemoveExpiredEntries", "cache element timer interval - cache: [{}], [{}]", (Object)this.getCacheName(), (Object)this.getCacheConfig().getCacheType().getCleanupIntervalMS());
            this.createScheduledTask("createCacheRemoveExpiredEntries::" + this.getCacheName(), true, this.getCacheConfig().getCacheType().getCleanupIntervalMS(), this, "checkNRemoveExpiredStaleCacheEntries");
        }
    }

    protected void createCacheRefreshTimer() {
        long refreshInterval = -1L;
        if (AbstractCache.isEndpointCache(this) || AbstractCache.isRouteInfoCache(this)) {
            if (AbstractCache.isEndpointCache(this)) {
                refreshInterval = this.getConfig().getLong("DME2_SEP_REFRESH_CACHE_TIMER_FREQ_MS", -1L);
            } else if (AbstractCache.isRouteInfoCache(this)) {
                refreshInterval = this.getConfig().getLong("DME2_ROUTE_INFO_CACHE_TIMER_FREQ_MS", -1L);
            }
            if (refreshInterval < 0L) {
                refreshInterval = this.getCacheConfig().getCacheType() != null && this.getCacheConfig().getCacheType().getRefreshInterval() > 0L ? this.getCacheConfig().getCacheType().getRefreshInterval() : 20000L;
            }
        }
        if (refreshInterval > 0L) {
            LOGGER.debug(null, "createCacheRefreshTimer", "cache element ttl - cache: [{}], ttl: [{}], refresh interval: [{}]", this.getCacheName(), this.cacheEntryTTL, refreshInterval);
            this.createScheduledTask("RefreshCacheData::" + this.getCacheName(), true, refreshInterval, this, "refresh");
        }
    }

    protected void createCacheSerializerTimer() {
        try {
            if (this.getCacheConfig().getCacheType() != null && this.getCacheConfig().getCacheType().getPersistFrequencyMS() > 0L) {
                long cacheSerializerTimer = -1L;
                if (AbstractCache.isEndpointCache(this)) {
                    cacheSerializerTimer = this.getConfig().getLong("DME2_PERSIST_CACHED_ENDPOINTS_FREQUENCY_MS", -1L);
                } else if (AbstractCache.isRouteInfoCache(this)) {
                    cacheSerializerTimer = this.getConfig().getLong("DME2_PERSIST_CACHED_ROUTEINFO_FREQUENCY_MS", -1L);
                }
                if (cacheSerializerTimer < 0L) {
                    cacheSerializerTimer = this.getCacheConfig().getCacheType().getPersistFrequencyMS();
                }
                if (cacheSerializerTimer < 0L) {
                    cacheSerializerTimer = 300000L;
                }
                if (!Boolean.valueOf(System.getProperty("AFT_DME2_DISABLE_PERSISTENT_CACHE")).booleanValue() && !this.config.getBoolean("DME2_DISABLE_PERSISTENT_CACHE", false)) {
                    if (this.cacheSerializer == null) {
                        this.cacheSerializer = DME2CacheFactory.getCacheSerializer(this, this.getConfig(), AbstractCache.isEndpointCache(this));
                    }
                    this.createScheduledTask(this.getCacheName().concat("-serializer-time"), true, cacheSerializerTimer, this.cacheSerializer, "persist", this, this.getConfig());
                    LOGGER.debug((URI)null, "createCacheSerializerTimer", "cache serializer timer has been started for cache: [{}]", (Object)this.getCacheName());
                } else {
                    LOGGER.debug(null, "createCacheSerializerTimer", "cache serializer timer has not been started because the persistent feature is disabled");
                }
            } else {
                LOGGER.debug((URI)null, "createCacheSerializerTimer", "cache serializer timer has not been started because the persistent feature is not available for this cache: [{}]", (Object)this.getCacheName());
            }
        }
        catch (DME2Exception e) {
            LOGGER.warn((URI)null, "createCacheSerializerTimer", "cache serializer cannot be instantiated", (Object)e);
        }
    }

    public static boolean isEndpointCache(DME2Cache cache) {
        boolean isEndpointCache = false;
        try {
            isEndpointCache = "EndpointCache".equals(cache.getCacheConfig().getCacheType().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isEndpointCache;
    }

    public static boolean isStaleEndpointCache(DME2Cache cache) {
        boolean isStaleEndpointCache = false;
        try {
            isStaleEndpointCache = "StaleEndpointCache".equals(cache.getCacheConfig().getCacheType().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isStaleEndpointCache;
    }

    public static boolean isStaleRouteInfoCache(DME2Cache cache) {
        boolean isStaleRouteInfoCache = false;
        try {
            isStaleRouteInfoCache = "StaleRouteOfferCache".equals(cache.getCacheConfig().getCacheType().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isStaleRouteInfoCache;
    }

    public static boolean isRouteInfoCache(DME2Cache cache) {
        boolean isRouteInfoCache = false;
        try {
            isRouteInfoCache = "RouteInfoCache".equals(cache.getCacheConfig().getCacheType().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isRouteInfoCache;
    }

    public void checkNRemoveExpiredStaleCacheEntries() {
        try {
            if (this.getCacheConfig().getCacheType().getCleanupIntervalMS() > 0L) {
                for (CacheElement.Key key : this.getKeySet()) {
                    CacheElement element = this.getEntryView().getEntry(key);
                    if (element == null) continue;
                    if (AbstractCache.isStaleEndpointCache(this) && System.currentTimeMillis() > element.getExpirationTime()) {
                        LOGGER.debug((URI)null, "checkNRemoveExpiredEntries", "Removing entry for {} at {}ms", (Object)key, (Object)element.getExpirationTime());
                        this.remove(key);
                        LOGGER.debug((URI)null, "checkNRemoveExpiredEntries", "Removed entry for {} at {}ms", (Object)key, (Object)element.getExpirationTime());
                        continue;
                    }
                    if (!AbstractCache.isStaleRouteInfoCache(this) || element == null || element.getValue() == null || element.getValue().getValue() == null || System.currentTimeMillis() <= (Long)element.getValue().getValue()) continue;
                    LOGGER.debug((URI)null, "checkNRemoveExpiredEntries", "Removing entry for {} at {}ms", (Object)key, (Object)((Long)element.getValue().getValue()));
                    this.remove(key);
                    LOGGER.debug((URI)null, "checkNRemoveExpiredEntries", "Removed entry for {} at {}ms", (Object)key, (Object)((Long)element.getValue().getValue()));
                }
            } else {
                LOGGER.warn(null, "checkNRemoveExpiredEntries", "interval for cache entries is not properly set");
            }
        }
        catch (Exception e) {
            LOGGER.error((URI)null, "checkNRemoveExpiredEntries", "Error [{}] occurred while checking and clearing cache entries", (Object)e);
        }
    }

    protected void warmUpCache() {
        try {
            this.cacheSerializer = DME2CacheFactory.getCacheSerializer(this, this.getConfig(), AbstractCache.isEndpointCache(this));
            if (!this.cacheSerializer.isStale(this, this.getConfig())) {
                this.cacheSerializer.load(this, this.getConfig());
            } else {
                this.refresh();
            }
        }
        catch (DME2Exception e) {
            LOGGER.warn(null, "createCacheSerializerTimer", "cache serializer cannot be instantiated");
        }
    }

    protected void createScheduledTask(String taskName, boolean isDaemon, long interval, Object object, String methodName, Object ... objs) {
        if (this.cacheScheduleTaskRegister.get(taskName) != null) {
            LOGGER.warn((URI)null, "createScheduledTask", "Removing duplicate task {}", (Object)taskName);
            this.cacheScheduleTaskRegister.get(taskName).cancel();
        }
        this.cacheScheduleTaskRegister.put(taskName, CacheTaskScheduler.scheduleAtFixedRate(taskName, isDaemon, interval, object, methodName, objs));
    }

    protected void createScheduledTask(String taskName, boolean isDaemon, long interval, Object object, String methodName) {
        if (this.cacheScheduleTaskRegister.get(taskName) != null) {
            LOGGER.warn((URI)null, "createScheduledTask", "Removing duplicate task {}", (Object)taskName);
            this.cacheScheduleTaskRegister.get(taskName).cancel();
        }
        this.cacheScheduleTaskRegister.put(taskName, CacheTaskScheduler.scheduleAtFixedRate(taskName, isDaemon, interval, object, methodName));
    }

    @Override
    public CacheConfiguration getCacheConfig() {
        return this.cacheConfig;
    }

    protected void putAllData(Map<CacheElement.Key, CacheElement.Value> cacheElements) {
        LOGGER.debug((URI)null, "AbstractCache.putAllData", "start - cache: [{}]", (Object)this.getCacheName());
        for (Map.Entry<CacheElement.Key, CacheElement.Value> entry : cacheElements.entrySet()) {
            if (!this.isPutAllow(entry.getKey(), entry.getValue())) continue;
            this.put(entry.getKey(), entry.getValue());
        }
        LOGGER.debug((URI)null, "AbstractCache.putAllData", "completed - cache: [{}]", (Object)this.getCacheName());
    }

    @Override
    public void put(CacheElement.Key k, CacheElement.Value v) {
        LOGGER.debug((URI)null, "AbstractCache.put(k,v)", "start put cache: [{}]", (Object)this.getCacheName());
        this.put(k, this.createElement(k, v));
        LOGGER.debug((URI)null, "AbstractCache.put(k,v)", "completed put cache: [{}]", (Object)this.getCacheName());
    }

    public CacheElement createElement(CacheElement.Key k, CacheElement.Value v) {
        LOGGER.debug((URI)null, "AbstractCache.createElement", "start - cache: [{}]", (Object)this.getCacheName());
        long ttl = this.cacheEntryTTL;
        long expirationTime = ttl > 0L ? this.getCurrentTimeMS() + this.cacheEntryTTL : -1L;
        CacheElement element = new CacheElement().setKey(k).setCreationTime(this.getCurrentTimeMS()).setValue(v).setLastAccessedTime(this.getCurrentTimeMS()).setExpirationTime(expirationTime).setTtl(ttl);
        if (v != null && v.getValue() != null && v.getValue() instanceof DME2ServiceEndpointData) {
            DME2ServiceEndpointData data = (DME2ServiceEndpointData)v.getValue();
            element.setExpirationTime(data.getExpirationTime());
            element.setTtl(data.getCacheTTL());
        }
        LOGGER.debug((URI)null, "AbstractCache.createElement", "completed - cache: [{}], element: [{}]", (Object)this.getCacheName(), (Object)element);
        return element;
    }

    protected long getCurrentTimeMS() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownTimerTask() {
        LOGGER.debug((URI)null, "AbstractCache.shutdownTimerTask", "start - cache: [{}]", (Object)this.getCacheName());
        byte[] byArray = this.hashlock;
        synchronized (this.hashlock) {
            for (CacheTaskScheduler scheduler : this.cacheScheduleTaskRegister.values()) {
                LOGGER.debug((URI)null, "AbstractCache.shutdownTimerTask", "invoking cancel for the cache level timer task [{}]", (Object)scheduler.getTaskName());
                scheduler.cancel();
            }
            this.cacheScheduleTaskRegister.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LOGGER.debug((URI)null, "AbstractCache.shutdownTimerTask", "completed - cache: [{}]", (Object)this.getCacheName());
            return;
        }
    }

    @Override
    public CacheElement.Value refreshEntry(CacheElement.Key key) throws CacheException {
        LOGGER.debug((URI)null, "AbstractCache.refresh key", "start - cache: [{}]", (Object)this.getCacheName());
        HashSet<CacheElement.Key> keySet = new HashSet<CacheElement.Key>();
        keySet.add(key);
        this.refreshKeys(this.getKeySet());
        LOGGER.debug((URI)null, "AbstractCache.refresh key", "completed - cache: [{}]", (Object)this.getCacheName());
        return this.get(key);
    }

    private Set<CacheElement.Key> removeCacheKeysNotExpired(Set<CacheElement.Key> keySet) {
        HashSet<CacheElement.Key> returnKeySet = new HashSet<CacheElement.Key>();
        if (this.getKeySet() != null && !this.getKeySet().isEmpty()) {
            for (CacheElement.Key k : keySet) {
                if (this.getExpirationTime(k.getString()) > System.currentTimeMillis()) continue;
                returnKeySet.add(k);
            }
        }
        return returnKeySet;
    }

    private Set<CacheElement.Key> removeCacheKeysContainingGroupRouteOffer(Set<CacheElement.Key> keySet) {
        HashSet<CacheElement.Key> returnKeySet = new HashSet<CacheElement.Key>();
        if (keySet != null && !keySet.isEmpty()) {
            for (CacheElement.Key k : keySet) {
                String routeOfferVal;
                Map<String, String> map = DME2Utils.splitServiceURIString(k.getString());
                if (map != null && map.containsKey("routeOffer") && (routeOfferVal = map.get("routeOffer")) != null && routeOfferVal.contains("~")) {
                    LOGGER.debug((URI)null, "AbstractCache.refresh", LogMessage.SKIP_REFRESH_ENDPOINTS, (Object)k.getString());
                    continue;
                }
                returnKeySet.add(k);
            }
        }
        return returnKeySet;
    }

    private Set<CacheElement.Key> randomizeKeySet(Set<CacheElement.Key> keySet) {
        HashSet<CacheElement.Key> returnKeySet = new HashSet<CacheElement.Key>();
        if (keySet != null) {
            ArrayList<CacheElement.Key> serviceURIList = new ArrayList<CacheElement.Key>();
            serviceURIList.addAll(keySet);
            Collections.shuffle(serviceURIList);
            for (CacheElement.Key k : serviceURIList) {
                returnKeySet.add(k);
            }
        }
        return returnKeySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshEndpointKeys(Set<CacheElement.Key> keySet) {
        long startTime = 0L;
        this.setRefreshInProgress(true);
        try {
            if (this.getCacheConfig().getDataLoader() != null) {
                if (this.getCacheConfig().getCacheDataSource() != null) {
                    if (keySet != null && !keySet.isEmpty()) {
                        keySet = this.removeCacheKeysNotExpired(keySet);
                        keySet = this.removeCacheKeysContainingGroupRouteOffer(keySet);
                        if ((keySet = this.randomizeKeySet(keySet)) != null && !keySet.isEmpty()) {
                            startTime = System.currentTimeMillis();
                            Map<CacheElement.Key, Pair<CacheElement, Exception>> data = this.getCacheConfig().getDataLoader().getDataForAllKeys(keySet, this.getCacheConfig().getCacheDataSource());
                            if (data != null) {
                                this.processCacheSourceData(keySet, data, startTime);
                                LOGGER.debug((URI)null, "AbstractCache.refreshEndpointKeys", "completed putting all data in the cache: [{}]", (Object)this.getCacheName());
                            } else {
                                LOGGER.debug((URI)null, "AbstractCache.refreshEndpointKeys", "completed; but no data found to refresh the cache: [{}]", (Object)this.getCacheName());
                            }
                        } else {
                            LOGGER.debug((URI)null, "AbstractCache.refreshEndpointKeys", "completed; but no data are found as stale to refresh the cache: [{}]", (Object)this.getCacheName());
                        }
                    } else {
                        LOGGER.debug((URI)null, "AbstractCache.refreshEndpointKeys", "completed; but no key found to refresh the cache: [{}]", (Object)this.getCacheName());
                    }
                } else {
                    LOGGER.debug((URI)null, "AbstractCache.refreshEndpointKeys", "completed; but no data cache data source to refresh the cache: [{}]", (Object)this.getCacheName());
                }
            } else {
                LOGGER.debug((URI)null, "AbstractCache.refreshEndpointKeys", "completed; but no data loader added to refresh the cache: [{}]", (Object)this.getCacheName());
            }
        }
        catch (CacheException ce) {
            LOGGER.debug((URI)null, "AbstractCache.refreshEndpointKeys", "completed - cache: [{}], Exception: [{}]", (Object)this.getCacheName(), (Object)ce.getErrorMessage());
        }
        catch (HazelcastInstanceNotActiveException hze) {
            LOGGER.debug(null, "AbstractCache.refreshEndpointKeys", "hazelcast is probably down!!!");
        }
        finally {
            this.setRefreshInProgress(false);
        }
    }

    private void refreshKeys(Set<CacheElement.Key> keySet) {
        if (AbstractCache.isEndpointCache(this)) {
            this.refreshEndpointKeys(keySet);
        } else {
            this.refreshRouteInfoKeys(keySet);
        }
    }

    @Override
    public void refresh() {
        LOGGER.debug((URI)null, "AbstractCache.refresh", "start - cache: [{}]", (Object)this.getCacheName());
        this.getCacheConfig().getCacheDataSource().refresh();
        LOGGER.debug((URI)null, "AbstractCache.refresh", "completed - cache: [{}]", (Object)this.getCacheName());
    }

    private DME2CacheStatsHolder initCacheStatHolder(String uriStr) throws MalformedURLException, URISyntaxException {
        DmeUniformResource uniformResource = new DmeUniformResource(this.getConfig(), new URI("http://DME3LOCAL/" + uriStr));
        String service = uniformResource.getService();
        String version = uniformResource.getVersion();
        String env = uniformResource.getEnvContext();
        String cacheStatsURI = "/service=" + service + "/version=" + version + "/envContext=" + env;
        DME2CacheStatsHolder statsHolder = null;
        statsHolder = this.cacheStats.get(cacheStatsURI);
        if (statsHolder == null) {
            statsHolder = new DME2CacheStatsHolder(cacheStatsURI, this.getConfig());
            this.cacheStats.put(cacheStatsURI, statsHolder);
        }
        long startTime = System.currentTimeMillis();
        return statsHolder;
    }

    @Override
    public boolean isCacheStatsEnabled() {
        return this.enableCacheStats;
    }

    @Override
    public void disableCacheStats() {
        this.enableCacheStats = false;
    }

    @Override
    public void enableCacheStats() {
        this.enableCacheStats = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void refreshRouteInfoKeys(Set<CacheElement.Key> keySet) {
        block24: {
            Iterator<CacheElement.Key> iterator;
            Map data;
            long startTime;
            block23: {
                LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "start - cache: [{}]", (Object)this.getCacheName());
                this.setRefreshInProgress(true);
                startTime = 0L;
                try {
                    if (this.getCacheConfig().getDataLoader() != null) {
                        if (this.getCacheConfig().getCacheDataSource() != null) {
                            if (keySet != null && !keySet.isEmpty()) {
                                if ((keySet = this.removeCacheKeysNotExpired(keySet)) != null && !keySet.isEmpty()) {
                                    startTime = System.currentTimeMillis();
                                    data = this.getCacheConfig().getDataLoader().getDataForAllKeys(keySet, this.getCacheConfig().getCacheDataSource());
                                    if (data != null) {
                                        iterator = keySet.iterator();
                                        break block23;
                                    }
                                    LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed; but no data found to refresh the cache: [{}]", (Object)this.getCacheName());
                                    break block24;
                                }
                                LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed; but no data are found as stale to refresh the cache: [{}]", (Object)this.getCacheName());
                                break block24;
                            }
                            LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed; but no key found to refresh the cache: [{}]", (Object)this.getCacheName());
                            break block24;
                        }
                        LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed; but no data cache data source to refresh the cache: [{}]", (Object)this.getCacheName());
                        break block24;
                    }
                    LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed; but no data loader added to refresh the cache: [{}]", (Object)this.getCacheName());
                    break block24;
                }
                catch (CacheException ce) {
                    LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed - cache: [{}], Exception: [{}]", (Object)this.getCacheName(), (Object)ce.getErrorMessage());
                    break block24;
                }
                catch (HazelcastInstanceNotActiveException hze) {
                    LOGGER.debug(null, "AbstractCache.refreshRouteInfo", "hazelcast is probably down!!!");
                    break block24;
                }
                finally {
                    this.setRefreshInProgress(false);
                }
            }
            while (iterator.hasNext()) {
                CacheElement.Key key = iterator.next();
                if (data.get(key) != null) {
                    CacheElement v = data.get(key).getLeft();
                    Exception e = data.get(key).getRight();
                    if (e == null && v != null) {
                        byte[] byArray = this.lock;
                        // MONITORENTER : this.lock
                        this.put(key, v);
                        LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", LogMessage.REFRESH_SERVICE, (Object)key);
                        try {
                            this.initCacheStatHolder(key.getString()).recordRefreshSuccess(System.currentTimeMillis() - startTime, this.isCacheStatsEnabled());
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                        continue;
                    }
                    if (e == null) continue;
                    try {
                        LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", LogMessage.REFRESH_SVC_FAILED, (Object)key);
                        this.initCacheStatHolder(key.getString()).recordRefreshFailure(System.currentTimeMillis() - startTime, this.isCacheStatsEnabled());
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    continue;
                }
                LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", LogMessage.REFRESH_SVC_FAILED, (Object)key);
            }
            LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed putting all data in the cache: [{}]", (Object)this.getCacheName());
        }
        LOGGER.debug((URI)null, "AbstractCache.refreshRouteInfo", "completed - cache: [{}]", (Object)this.getCacheName());
    }

    @Override
    public String getKeys() {
        LOGGER.debug((URI)null, "AbstractCache.getKeys", "start - cache: [{}]", (Object)this.getCacheName());
        StringBuffer buffer = new StringBuffer();
        if (this.getKeySet() != null) {
            buffer.append("[");
            for (CacheElement.Key key : this.getKeySet()) {
                buffer.append(key.getString());
                buffer.append(",");
            }
            buffer.append("]");
        } else {
            buffer.append("Ugh! seems some difficulty in getting the keys now!");
        }
        LOGGER.debug((URI)null, "AbstractCache.getKeys", "end - cache: [{}], cache keys: []", (Object)this.getCacheName(), (Object)buffer.toString());
        return buffer.toString();
    }

    protected void processCacheSourceData(Set<CacheElement.Key> keySet, Map<CacheElement.Key, Pair<CacheElement, Exception>> dataFromSource, long startTime) {
        LOGGER.debug((URI)null, "processCacheSourceData", "start - cache: [{}]", (Object)this.getCacheName());
        CacheElement v = null;
        Exception e = null;
        CacheElement cacheElement = null;
        CacheEntryView cacheEntryView = this.getEntryView();
        long ttl = 0L;
        if (dataFromSource != null && !dataFromSource.isEmpty()) {
            for (CacheElement.Key serviceKey : keySet) {
                Pair<CacheElement, Exception> entry = dataFromSource.get(serviceKey);
                if (entry != null && entry.getLeft() != null && entry.getRight() == null) {
                    v = entry.getLeft();
                    e = entry.getRight();
                    cacheElement = v;
                    if (!this.isPutAllow(serviceKey, v.getValue())) continue;
                    long lastQueriedAt = 0L;
                    if (cacheEntryView != null && cacheEntryView.getEntry(serviceKey) != null) {
                        lastQueriedAt = cacheEntryView.getEntry(serviceKey).getLastAccessedTime();
                    }
                    ttl = lastQueriedAt > 0L && this.config.getBoolean("AFT_DME2_ENABLE_SELECTIVE_REFRESH", false) ? (System.currentTimeMillis() - lastQueriedAt >= this.endpointLastQueriedInterval ? this.infrequentEndpointCacheTTL : this.cacheEntryTTL) : this.cacheEntryTTL;
                    cacheElement = cacheElement.setTtl(ttl);
                    this.put(serviceKey, cacheElement);
                    try {
                        this.initCacheStatHolder(serviceKey.getString()).recordRefreshSuccess(System.currentTimeMillis() - startTime, this.isCacheStatsEnabled());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                this.revalidateEntryOnFailedRefresh(serviceKey);
            }
        } else {
            for (CacheElement.Key serviceKey : keySet) {
                this.revalidateEntryOnFailedRefresh(serviceKey);
            }
        }
        LOGGER.debug((URI)null, "processCacheSourceData", "completed - processCacheSourceData: [{}]", (Object)this.getCacheName());
    }

    @Override
    public DME2CacheStats getStats(String serviceName, Integer hourOfDay) {
        LOGGER.info(null, "getStats ", "serviceName :" + serviceName + " hourOfDay : " + hourOfDay);
        LOGGER.info(null, "getStats ", "cacheStats :" + this.cacheStats);
        if (serviceName != null && this.cacheStats.get(serviceName) != null) {
            DME2CacheStatsHolder stats = this.cacheStats.get(serviceName);
            if (hourOfDay >= 0 && hourOfDay <= 23) {
                return stats.getHourlyStats(hourOfDay);
            }
            return this.cacheStats.get(serviceName).getStats();
        }
        return null;
    }

    private void revalidateEntryOnFailedRefresh(CacheElement.Key serviceKey) {
        DME2ServiceEndpointData value;
        CacheElement element;
        LOGGER.warn((URI)null, "revalidateEntryOnFailedRefresh", LogMessage.REFRESH_DEFERRED, (Object)serviceKey);
        long ttl = this.endpointCacheEmptyTTL;
        if (this.get(serviceKey) != null) {
            String msg;
            int emptyCacheRefreshAttemptCount = this.getEntryView().getEntry(serviceKey).getEmptyCacheRefreshAttemptCount();
            if (emptyCacheRefreshAttemptCount == this.emptyCacheTTLRefreshIntervals.length - 1) {
                ttl = this.emptyCacheTTLRefreshIntervals[this.emptyCacheTTLRefreshIntervals.length - 1];
                msg = String.format("SEP Empty Cache TTL has already reached the last interval for service %s. TTL value will remain at: %s. Current empty cache refresh attempt count: %s ", serviceKey, ttl, emptyCacheRefreshAttemptCount);
                LOGGER.debug((URI)null, "revalidateEntryOnFailedRefresh", LogMessage.DEBUG_MESSAGE, (Object)msg);
            } else if (this.emptyCacheTTLRefreshIntervals.length == 1) {
                ttl = this.emptyCacheTTLRefreshIntervals[0];
            } else {
                ttl = this.emptyCacheTTLRefreshIntervals[++emptyCacheRefreshAttemptCount];
                this.getEntryView().getEntry(serviceKey).setEmptyCacheRefreshAttemptCount(emptyCacheRefreshAttemptCount);
                msg = String.format("Advancing to next Emtpy Cache TTL interval value for service %s. New value: %s", serviceKey, ttl);
                LOGGER.debug((URI)null, "revalidateEntryOnFailedRefresh", LogMessage.DEBUG_MESSAGE, (Object)("New empty cache refresh attempt count: " + emptyCacheRefreshAttemptCount));
                LOGGER.debug((URI)null, "revalidateEntryOnFailedRefresh", LogMessage.DEBUG_MESSAGE, (Object)msg);
            }
        }
        if ((element = this.getEntryView().getEntry(serviceKey)) != null && element.getValue() != null && (value = (DME2ServiceEndpointData)element.getValue().getValue()) != null) {
            value.setCacheTTL(ttl);
            element.setTtl(ttl);
        }
    }

    private long[] getEmptyCacheTTLIntervalsFromProperties(String property, long[] defaultValue) {
        long[] emptyCacheTTLIntervals = null;
        if (property == null) {
            return defaultValue;
        }
        try {
            String[] tokens;
            for (String token : tokens = property.split(",")) {
                if (!DME2Utils.isParseable(token.trim(), Long.class)) {
                    return defaultValue;
                }
                boolean enforceMinEmptyCacheTTLIntervalValue = this.config.getBoolean("DME2_ENFORCE_MIN_EMPTY_CACHE_TTL_INTERVAL_VALUE", true);
                if (!enforceMinEmptyCacheTTLIntervalValue || Long.parseLong(token) >= 300000L) continue;
                String msg = String.format("Interval values cannot be less than 5 minutes. Value provided: %s. Using default interval values of: %s", token, Arrays.asList(new long[][]{this.emptyCacheTTLRefreshDefaultIntervals}));
                LOGGER.warn((URI)null, "getEmptyCacheTTLIntervalsFromProperties", LogMessage.DEBUG_MESSAGE, (Object)msg);
                return defaultValue;
            }
            emptyCacheTTLIntervals = new long[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                emptyCacheTTLIntervals[i] = Long.parseLong(tokens[i].trim());
            }
        }
        catch (Exception e) {
            LOGGER.debug((URI)null, "getEmptyCacheTTLIntervalsFromProperties", LogMessage.DEBUG_MESSAGE, (Object)"Error occurred while attempting while resolving Empty SEP Cache TTL Intervals. Using default.", (Object)e);
            return defaultValue;
        }
        LOGGER.debug((URI)null, "getEmptyCacheTTLIntervalsFromProperties", LogMessage.DEBUG_MESSAGE, (Object)("Empty SEP Cache TTL Intervals resolved from properties: " + property));
        return emptyCacheTTLIntervals;
    }

    @Override
    public void run() {
        this.shutdownTimerTask();
    }

    public abstract void lock(CacheElement.Key var1);

    public abstract void unlock(CacheElement.Key var1);

    public abstract void put(CacheElement.Key var1, CacheElement var2);

    public abstract M getCacheMap();

    public abstract boolean isPutAllow(CacheElement.Key var1, CacheElement.Value var2);

    public abstract void setRefreshInProgress(boolean var1);
}

