/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.domain;

import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.io.Serializable;

public class CacheElement
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(CacheElement.class);
    private static final long serialVersionUID = -6305361521575262096L;
    private boolean markedForRemoval = false;
    private long lastAccessedTime = 0L;
    private long expirationTime = 0L;
    private long creationTime = 0L;
    private long ttl = 0L;
    private Key key;
    private Value value;
    private int emptyCacheRefreshAttemptCount = -1;

    public boolean isMarkedForRemoval() {
        return this.markedForRemoval;
    }

    public void setMarkedForRemoval(boolean markedForRemoval) {
        this.markedForRemoval = markedForRemoval;
    }

    public int getEmptyCacheRefreshAttemptCount() {
        return this.emptyCacheRefreshAttemptCount;
    }

    public void setEmptyCacheRefreshAttemptCount(int emptyCacheRefreshAttemptCount) {
        this.emptyCacheRefreshAttemptCount = emptyCacheRefreshAttemptCount;
    }

    public long getTtl() {
        return this.ttl;
    }

    public CacheElement setTtl(long ttl) {
        this.ttl = ttl;
        this.setExpirationTime(System.currentTimeMillis() + this.getTtl());
        return this;
    }

    public Value getValue() {
        return this.value;
    }

    public CacheElement setValue(Value value) {
        this.value = value;
        return this;
    }

    public Key getKey() {
        return this.key;
    }

    public CacheElement setKey(Key key) {
        this.key = key;
        return this;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public CacheElement setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        return this;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public CacheElement setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public CacheElement setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public String toString() {
        return "CacheElement [markedForRemoval=" + this.markedForRemoval + ", lastAccessedTime=" + this.lastAccessedTime + ", expirationTime=" + this.expirationTime + ", creationTime=" + this.creationTime + ", ttl=" + this.ttl + ", key=" + this.key + ", value=" + this.value + ", emptyCacheRefreshAttemptCount=" + this.emptyCacheRefreshAttemptCount + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.markedForRemoval) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheElement other = (CacheElement)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static class Value<V>
    implements Serializable {
        private static final long serialVersionUID = -8835066406701834360L;
        private V value;

        public Value() {
        }

        public Value(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Value [value=");
            builder.append(this.value);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class Key<K>
    implements Serializable {
        private static final long serialVersionUID = 8000655792870489708L;
        private K key;

        public Key() {
        }

        public Key(K key) {
            this.key = key;
        }

        public K getKey() {
            return this.key;
        }

        public String getString() {
            if (this.key instanceof String) {
                return (String)this.key;
            }
            return this.key.toString();
        }

        public void setKey(K key) {
            this.key = key;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("key [key=");
            builder.append(this.key);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            if (this.key.toString().equals("")) {
                // empty if block
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

