/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.domain;

import com.att.aft.dme2.cache.domain.CacheTypeElement;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="CacheTypes", namespace="CacheTypes")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CacheTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheTypes.class.getName());
    private static final Map<String, CacheTypeElement> cacheTypeMap = new HashMap<String, CacheTypeElement>();
    @XmlElement(name="CacheType")
    private List<CacheTypeElement> typeList;
    private DME2Configuration config = null;

    private CacheTypes() {
    }

    public static CacheTypes getInstance(DME2Configuration config) {
        return CacheTypesLoader.loadCacheTypesConfigXML(config);
    }

    public static CacheTypeElement getType(String typeName, DME2Configuration config) {
        for (CacheTypeElement type : CacheTypes.getCacheTypes(config)) {
            if (typeName == null || !typeName.equalsIgnoreCase(type.getName())) continue;
            return type;
        }
        return null;
    }

    public static List<CacheTypeElement> getCacheTypes(DME2Configuration config) {
        return CacheTypes.getInstance((DME2Configuration)config).typeList;
    }

    public static List<String> getCacheTypeNames(DME2Configuration config) {
        ArrayList<String> keys = new ArrayList<String>();
        for (CacheTypeElement type : CacheTypes.getCacheTypes(config)) {
            keys.add(type.getName());
        }
        return keys;
    }

    static class CacheTypesLoader {
        CacheTypesLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static CacheTypes loadCacheTypesConfigXML(DME2Configuration config) {
            CacheTypes cacheTypes;
            block23: {
                cacheTypes = null;
                try {
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{CacheTypes.class});
                    Unmarshaller unmarshaller = jc.createUnmarshaller();
                    File cacheTypeConfigXmlFile = null;
                    try {
                        LOGGER.debug(null, "loadCacheTypesConfigXML", "loading cache type config file from dme2configuration setup");
                        cacheTypeConfigXmlFile = new File(config.getProperty("CACHE_TYPE_CONFIG_FILE_PATH"));
                        LOGGER.debug((URI)null, "loadCacheTypesConfigXML", "loaded cache type config file from dme2configuration setup: [{}]", (Object)cacheTypeConfigXmlFile.getAbsoluteFile());
                    }
                    catch (NullPointerException npe) {
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_020, new Object[0]);
                    }
                    if (cacheTypeConfigXmlFile != null && !cacheTypeConfigXmlFile.isFile()) {
                        LOGGER.debug((URI)null, "loadCacheTypesConfigXML", "cache type config file is not available through the dme2configuration setup; loading cache type config file [{}] from classpath", (Object)config.getProperty("CACHE_TYPE_CONFIG_FILE_NAME"));
                        URL cacheTypeConfigFileUrl = CacheTypesLoader.class.getResource(config.getProperty("CACHE_TYPE_CONFIG_FILE_NAME"));
                        if (cacheTypeConfigFileUrl != null) {
                            try {
                                cacheTypeConfigXmlFile = new File(cacheTypeConfigFileUrl.getFile());
                                LOGGER.debug((URI)null, "loadCacheTypesConfigXML", "successfully loaded cache type config file from classpath location [{}] ", (Object)cacheTypeConfigFileUrl.getFile());
                            }
                            catch (NullPointerException npe) {
                                LOGGER.debug((URI)null, "loadCacheTypesConfigXML", "failed to load cache type config file from classpath; path [{}] of the resource [{}] has some issue", (Object)cacheTypeConfigFileUrl.getFile(), (Object)config.getProperty("CACHE_TYPE_CONFIG_FILE_NAME"));
                                throw new CacheException(CacheException.ErrorCatalogue.CACHE_020, new Object[0]);
                            }
                        } else {
                            LOGGER.debug(null, "loadCacheTypesConfigXML", "failed to load cache type config file from classpath");
                        }
                    } else {
                        LOGGER.debug(null, "loadCacheTypesConfigXML", "successfully loaded cache type config file from dme2configuration setup");
                    }
                    if (cacheTypeConfigXmlFile != null) {
                        cacheTypes = (CacheTypes)unmarshaller.unmarshal(CacheTypesLoader.class.getResourceAsStream(config.getProperty("CACHE_TYPE_CONFIG_FILE_NAME")));
                        Marshaller marshaller = jc.createMarshaller();
                        marshaller.setProperty("jaxb.formatted.output", (Object)true);
                        marshaller.setProperty("jaxb.schemaLocation", (Object)"CacheTypes.xsd");
                        break block23;
                    }
                    if (!cacheTypeConfigXmlFile.isFile()) {
                        InputStream in = null;
                        BufferedReader reader = null;
                        try {
                            in = CacheTypes.class.getResourceAsStream("/conf/cache-types.xml");
                            reader = new BufferedReader(new InputStreamReader(in));
                            cacheTypes = (CacheTypes)unmarshaller.unmarshal((Reader)reader);
                            Marshaller marshaller = jc.createMarshaller();
                            marshaller.setProperty("jaxb.formatted.output", (Object)true);
                            marshaller.setProperty("jaxb.schemaLocation", (Object)"CacheTypes.xsd");
                            break block23;
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                            try {
                                reader.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    throw new CacheException(CacheException.ErrorCatalogue.CACHE_019, new Object[0]);
                }
                catch (JAXBException jAXBException) {
                    // empty catch block
                }
            }
            return cacheTypes;
        }
    }
}

