/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.handler.cacheabledata;

import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.handler.service.CacheableDataHandler;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.internal.apache.commons.lang3.tuple.Pair;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCacheDataHandler<K, V>
implements CacheableDataHandler<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheDataHandler.class.getName());

    @Override
    public Map<CacheElement.Key<K>, Pair<CacheElement, Exception>> getDataForAllKeys(Set<CacheElement.Key> keySet, DME2CacheableCallback source) {
        LOGGER.debug(null, "AbstractCacheDataHandler.getDataForAllKeys", "start");
        long start = System.currentTimeMillis();
        Map<CacheElement.Key<K>, Pair<CacheElement, Exception>> dataMap = this.getFreshDataToReloadAllEntries(keySet, source);
        LOGGER.debug((URI)null, "AbstractCacheDataHandler.getDataForAllKeys", "end - retreving data by endpointdatahandler for all serviceUris; time taken [{}]", (Object)(System.currentTimeMillis() - start));
        return dataMap;
    }

    @Override
    public CacheElement getData(CacheElement.Key<K> key, DME2CacheableCallback source) throws CacheException {
        LOGGER.debug(null, "AbstractCacheDataHandler.getData", "start");
        long start = System.currentTimeMillis();
        CacheElement data = this.getFreshDataToReloadCacheEntry(key, source);
        LOGGER.debug((URI)null, "AbstractCacheDataHandler.getDataForAllKeys", "end - retreving data by endpointdatahandler for all serviceUris; time taken [{}]", (Object)(System.currentTimeMillis() - start));
        return data;
    }

    public abstract CacheElement getFreshDataToReloadCacheEntry(CacheElement.Key var1, DME2CacheableCallback var2) throws CacheException;

    public abstract Map<CacheElement.Key<K>, Pair<CacheElement, Exception>> getFreshDataToReloadAllEntries(Set<CacheElement.Key> var1, DME2CacheableCallback var2) throws CacheException;
}

