/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.handler.event;

import com.att.aft.dme2.cache.AbstractCache;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.domain.CacheEvent;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.handler.service.CacheEventHandler;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.cache.service.Fork;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;

public class DefaultEventProcessingHandler
implements CacheEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEventProcessingHandler.class.getName());
    private static final String GET_DATA_THREAD_NAME = "DME2_CACHE_GET_DATA";
    private static transient boolean GET_CACHE_DATA_ASYNC;
    private static final ExecutorService CacheableDataAsyncService;

    public DefaultEventProcessingHandler(DME2Configuration config) {
        GET_CACHE_DATA_ASYNC = config.getBoolean("GET_CACHE_DATA_ASYNC");
    }

    @Override
    public void onPut(DME2Cache cache, CacheEvent cacheEvent) {
    }

    @Override
    public void onGet(DME2Cache cache, CacheEvent cacheEvent) {
    }

    @Override
    public void onUpdate(DME2Cache cache, CacheEvent cacheEvent) {
    }

    @Override
    public void onRemove(DME2Cache cache, CacheEvent cacheEvent) {
    }

    @Override
    public void onBeforeRemove(DME2Cache cache, CacheEvent cacheEvent) {
    }

    @Override
    public void onEviction(DME2Cache cache, CacheEvent cacheEvent) {
        LOGGER.info((URI)null, "onEviction", "Processing EVENT: [{}] ", (Object)cacheEvent.getCacheEventType().toString());
        throw new CacheException(CacheException.ErrorCatalogue.CACHE_013, ((AbstractCache)cache).getCacheName());
    }

    @Override
    public void onRefresh(DME2Cache cache, CacheEvent cacheEvent) {
    }

    private CacheElement.Value populateData(DME2Cache cache, CacheEvent cacheEvent) {
        CacheElement.Key key = cacheEvent.getCacheOldElement().getKey();
        CacheElement.Value value = null;
        try {
            LOGGER.info(null, "populateData", "trying to get cacheable data {} for cache:{}, {}", GET_CACHE_DATA_ASYNC ? "asynchronously" : "synchronously", ((AbstractCache)cache).getCacheName(), key);
            value = cache.refreshEntry(key);
        }
        catch (CacheException ce) {
            LOGGER.error((URI)null, "populateData", "cannot get cacheable data: [{}], keeping the old value {}=[{}]", (Object)ce.getErrorMessage(), (Object)cacheEvent.getCacheOldElement().getValue());
        }
        return value;
    }

    private CacheElement.Value populateDataAsync(final DME2Cache cache, final CacheEvent cacheEvent) {
        CacheElement.Value newValue = null;
        final CacheElement.Key key = cacheEvent.getCacheOldElement().getKey();
        LOGGER.info((URI)null, "populateDataAsync", "requesting to load cacheable data asynchronously {}, {}", (Object)((AbstractCache)cache).getCacheName(), (Object)key);
        FutureTask<CacheElement.Value> getDataAsyncTask = new FutureTask<CacheElement.Value>(new Callable<CacheElement.Value>(){

            @Override
            public CacheElement.Value call() {
                CacheElement.Value v = DefaultEventProcessingHandler.this.populateData(cache, cacheEvent);
                LOGGER.info((URI)null, "populateDataAsync-call", "completed request for loading of cacheable data asynchronously {}, {}", (Object)((AbstractCache)cache).getCacheName(), (Object)key);
                return v;
            }
        });
        CacheableDataAsyncService.execute(getDataAsyncTask);
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDataAndLoad(DME2Cache cache, CacheEvent cacheEvent) {
        block8: {
            LOGGER.info((URI)null, "fetchDataAndLoad", "EVENT: [{}]", (Object)cacheEvent.getCacheEventType().toString());
            CacheElement.Value newValue = null;
            CacheElement.Key key = cacheEvent.getCacheOldElement().getKey();
            if (GET_CACHE_DATA_ASYNC) {
                LOGGER.info(null, "fetchDataAndLoad", "asynchronous data retreival; setting the old value by default");
                this.populateDataAsync(cache, cacheEvent);
            } else {
                try {
                    newValue = this.populateData(cache, cacheEvent);
                    if (newValue == null) {
                        LOGGER.info((URI)null, "fetchDataAndLoad", "cannot get fresh cache data for cache {}, {}", (Object)((AbstractCache)cache).getCacheName(), (Object)key);
                        throw new RuntimeException("cannot remove data");
                    }
                    LOGGER.info(null, "fetchDataAndLoad", "fresh cache data reloaded for cache {}, {}, {}", ((AbstractCache)cache).getCacheName(), key, newValue);
                }
                catch (CacheException ce) {
                    if (ce.getErrorCode().equals((Object)CacheException.ErrorCatalogue.CACHE_005)) {
                        LOGGER.warn((URI)null, "fetchDataAndLoad", "fetchDataAndLoad exception: [{}]", (Object)ce.getErrorMessage());
                        break block8;
                    }
                    throw ce;
                }
            }
        }
        LOGGER.info((URI)null, "fetchDataAndLoad", "End fetchDataAndLoad EVENT: [{}]", (Object)cacheEvent.getCacheEventType().toString());
    }

    static {
        CacheableDataAsyncService = Fork.createFixedThreadExecutorPool(GET_DATA_THREAD_NAME, 50);
    }
}

