/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.hz;

import com.att.aft.dme2.cache.AbstractCache;
import com.att.aft.dme2.cache.domain.CacheConfiguration;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.domain.CacheEvent;
import com.att.aft.dme2.cache.domain.CacheEventType;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.handler.service.CacheEventHandler;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.hazelcast.core.EntryEvent;
import com.att.aft.dme2.hazelcast.core.MapEvent;
import com.att.aft.dme2.hazelcast.map.MapInterceptor;
import com.att.aft.dme2.hazelcast.map.listener.EntryAddedListener;
import com.att.aft.dme2.hazelcast.map.listener.EntryEvictedListener;
import com.att.aft.dme2.hazelcast.map.listener.EntryRemovedListener;
import com.att.aft.dme2.hazelcast.map.listener.EntryUpdatedListener;
import com.att.aft.dme2.hazelcast.map.listener.MapClearedListener;
import com.att.aft.dme2.hazelcast.map.listener.MapEvictedListener;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;

public class HzEventDelegator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HzEventDelegator.class.getName());
    public DME2Cache cache;
    private CacheEventHandler eventHandler;

    public HzEventDelegator(DME2Cache cache, CacheConfiguration cacheConfig) {
        this.cache = cache;
        this.eventHandler = cacheConfig.getEventHandler();
    }

    public void delegateEvent(CacheEvent cacheEvent) {
        LOGGER.debug((URI)null, "delegateEvent", "Delegate Cache EVENT: [{}]", (Object)cacheEvent.getCacheEventType().toString());
        CacheEventType eventType = cacheEvent.getCacheEventType();
        switch (eventType) {
            case EVICT: {
                this.eventHandler.onEviction(this.cache, cacheEvent);
                break;
            }
            default: {
                throw new CacheException(CacheException.ErrorCatalogue.CACHE_003, new Object[]{((AbstractCache)this.cache).getCacheName(), eventType});
            }
        }
    }

    public class Listener
    implements EntryAddedListener<Object, CacheElement>,
    EntryRemovedListener<Object, CacheElement>,
    EntryUpdatedListener<Object, CacheElement>,
    EntryEvictedListener<Object, CacheElement>,
    MapEvictedListener,
    MapClearedListener {
        private void delegateMapEvent(MapEvent event) {
        }

        private void convertToCacheEvent(EntryEvent<Object, CacheElement> event) {
            LOGGER.debug(null, "convertToCacheEvent", "Listen EVENT [{}]: preparing cache event; Existing value: [{}], New Value: [{}]", event.getEventType().toString(), event.getOldValue(), event.getValue());
            CacheEvent cacheEvent = new CacheEvent();
            cacheEvent.setCacheNewElement(event.getValue());
            cacheEvent.setCacheOldElement(event.getOldValue());
            switch (event.getEventType()) {
                case EVICTED: {
                    cacheEvent.setCacheEventType(CacheEventType.EVICT);
                    break;
                }
                default: {
                    throw new CacheException(CacheException.ErrorCatalogue.CACHE_003, new Object[]{((AbstractCache)HzEventDelegator.this.cache).getCacheName(), event.getEventType()});
                }
            }
            HzEventDelegator.this.delegateEvent(cacheEvent);
        }

        @Override
        public void mapCleared(MapEvent event) {
            this.delegateMapEvent(event);
        }

        @Override
        public void mapEvicted(MapEvent event) {
            this.delegateMapEvent(event);
        }

        @Override
        public void entryEvicted(EntryEvent<Object, CacheElement> event) {
        }

        @Override
        public void entryUpdated(EntryEvent<Object, CacheElement> event) {
        }

        @Override
        public void entryRemoved(EntryEvent<Object, CacheElement> event) {
        }

        @Override
        public void entryAdded(EntryEvent<Object, CacheElement> event) {
        }
    }

    class Interceptor
    implements MapInterceptor,
    Serializable {
        private static final long serialVersionUID = 5521073120342397279L;
        private final AtomicLong AL_number = new AtomicLong(Math.round(Math.random()));
        private String randomId = String.valueOf(this.AL_number.incrementAndGet()).concat("-DME2ElementInterceptor");

        private void convertToCacheEvent(CacheEventType event, Object oldValue, Object newValue) {
            LOGGER.debug((URI)null, "convertToCacheEvent", "Event [{}]", (Object)event.toString());
            CacheEvent cacheEvent = new CacheEvent();
            cacheEvent.setCacheOldElement((CacheElement)oldValue);
            cacheEvent.setCacheNewElement((CacheElement)newValue);
            cacheEvent.setCacheEventType(event);
            HzEventDelegator.this.delegateEvent(cacheEvent);
        }

        @Override
        public Object interceptGet(Object value) {
            return null;
        }

        @Override
        public void afterGet(Object value) {
        }

        @Override
        public Object interceptPut(Object oldValue, Object newValue) {
            return null;
        }

        @Override
        public void afterPut(Object value) {
        }

        @Override
        public Object interceptRemove(Object removedValue) {
            LOGGER.info((URI)null, "interceptRemove", "removingValue - [{}]", (Object)removedValue.toString());
            try {
                this.convertToCacheEvent(CacheEventType.EVICT, removedValue, removedValue);
            }
            catch (Exception e) {
                LOGGER.info((URI)null, "interceptRemove", "exception - [{}]", (Object)e.getMessage());
                throw e;
            }
            return removedValue;
        }

        @Override
        public void afterRemove(Object value) {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.randomId == null ? 0 : this.randomId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interceptor other = (Interceptor)obj;
            return !(this.randomId == null ? other.randomId != null : !this.randomId.equals(other.randomId));
        }
    }
}

