/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.legacy;

import com.att.aft.dme2.cache.AbstractCache;
import com.att.aft.dme2.cache.domain.CacheConfiguration;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.legacy.DefaultCacheEntryView;
import com.att.aft.dme2.cache.service.CacheEntryView;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.Fork;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public class DME2DefaultCache
extends AbstractCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DME2DefaultCache.class.getName());
    private final Map<CacheElement.Key, CacheElement> cache = new ConcurrentHashMap<CacheElement.Key, CacheElement>(16, 0.9f, 1);
    private boolean isRefreshInProgress = false;
    private String cacheName = null;
    private CacheEntryView cacheEntryView = null;
    private ExecutorService PUT_ASYNC_SERVICE = Fork.createFixedThreadExecutorPool("PUT_ASYNC_SERVICE", 10);
    private ExecutorService REMOVE_ASYNC_SERVICE = Fork.createFixedThreadExecutorPool("REMOVE_ASYNC_SERVICE", 10);

    public DME2DefaultCache(String cacheName, String cacheType, DME2CacheableCallback source, DME2Configuration config) {
        super(cacheName, cacheType, source, config);
        this.cacheName = cacheName;
        this.initialize();
    }

    public DME2DefaultCache(CacheConfiguration cacheConfig) {
        super(cacheConfig);
        this.cacheConfig = cacheConfig;
        this.initialize();
    }

    public void initialize() {
        LOGGER.debug((URI)null, "DME2DefaultCache.initialize", "start - cache: {}", (Object)this.getCacheName());
        this.cacheEntryView = new DefaultCacheEntryView(this.cache);
        super.init();
        LOGGER.debug((URI)null, "DME2DefaultCache.initialize", "completed - cache: [{}]", (Object)this.getCacheName());
    }

    @Override
    public CacheEntryView getEntryView() {
        return this.cacheEntryView;
    }

    @Override
    public void put(CacheElement.Key k, CacheElement element) {
        block2: {
            LOGGER.debug((URI)null, "DME2DefaultCache.put(k,element)", "start - cache: [{}]", (Object)this.getCacheName());
            try {
                this.getCacheMap().put(k, element);
            }
            catch (Exception e) {
                if (!(e instanceof CacheException)) break block2;
                LOGGER.debug((URI)null, "DME2DefaultCache.put(k,element)", "exception in put - cache: [{}]", (Object)this.getCacheName());
            }
        }
        LOGGER.debug((URI)null, "DME2DefaultCache.put(k,element)", "completed - cache: [{}]", (Object)this.getCacheName());
    }

    @Override
    public void clear() {
        LOGGER.debug((URI)null, "DME2DefaultCache.clear", "start - cache: [{}]", (Object)this.getCacheName());
        this.getCacheMap().clear();
        LOGGER.debug((URI)null, "DME2DefaultCache.clear", "end - cache: [{}]", (Object)this.getCacheName());
    }

    private void putAsync(final CacheElement.Key k, final CacheElement element) {
        this.PUT_ASYNC_SERVICE.execute(new Runnable(){

            @Override
            public void run() {
                DME2DefaultCache.this.put(k, element);
            }
        });
    }

    private void updateLastAccessedTime(CacheElement.Key key, CacheElement element) {
        element.setLastAccessedTime(this.getCurrentTimeMS());
        this.putAsync(key, element);
    }

    private CacheElement.Value get(CacheElement.Key key, boolean updateLastAccess) {
        LOGGER.debug((URI)null, "DME2DefaultCache.get", "start - cache: [{}] ,[{}]", (Object)this.getCacheName(), (Object)key);
        CacheElement.Value v = null;
        CacheElement element = null;
        element = (CacheElement)this.getCacheMap().get(key);
        if (updateLastAccess && element != null && !element.isMarkedForRemoval()) {
            this.updateLastAccessedTime(key, element);
        }
        if (element != null && !element.isMarkedForRemoval()) {
            v = element.getValue();
        }
        LOGGER.debug(null, "DME2DefaultCache.get", "completed - cache: [{}] ,[{}], [{}]", this.getCacheName(), key, v);
        return v;
    }

    @Override
    public CacheElement.Value get(CacheElement.Key key) {
        return this.get(key, true);
    }

    @Override
    public void remove(CacheElement.Key key) {
        LOGGER.debug((URI)null, "DME2DefaultCache.remove(k,element)", "start - cache: [{}], key[{}]", (Object)this.getCacheName(), (Object)key);
        try {
            this.getCacheMap().remove(key);
        }
        catch (Exception e) {
            LOGGER.error((URI)null, "DME2DefaultCache.remove", "key: [{}] not removed, error: [{}]", (Object)key, (Object)e.getMessage());
        }
        LOGGER.debug((URI)null, "DME2DefaultCache.remove(k,element)", "completed - cache: [{}], key[{}]", (Object)this.getCacheName(), (Object)key);
    }

    @Override
    public int getCurrentSize() {
        LOGGER.debug((URI)null, "DME2DefaultCache.getCurrentSize", "start - cache: [{}]", (Object)this.getCacheName());
        int size = 0;
        for (CacheElement.Key key : this.getCacheMap().keySet()) {
            if (((CacheElement)this.getCacheMap().get(key)).isMarkedForRemoval()) continue;
            ++size;
        }
        LOGGER.debug((URI)null, "DME2DefaultCache.getCurrentSize", "end - cache: [{}]", (Object)this.getCacheName());
        return size;
    }

    @Override
    public long getCacheTTLValue(String key) {
        LOGGER.info(null, "DME2DefaultCache.getCacheTTLValue ", key);
        return this.getCacheTTLValue(new CacheElement.Key<String>(key));
    }

    public long getCacheTTLValue(CacheElement.Key key) {
        LOGGER.debug((URI)null, "DME2DefaultCache.getCacheEntryTTLValue", "start - cache: [{}]", (Object)this.getCacheName());
        long ttl = -1L;
        if (this.cacheEntryView != null && this.getCacheMap() != null) {
            if (this.cacheEntryView.getEntry(key) != null) {
                ttl = this.cacheEntryView.getEntry(key).getTtl();
            } else {
                LOGGER.warn(null, "DME2DefaultCache.getCacheEntryTTLValue", "key: {} does not exist");
            }
        }
        LOGGER.debug((URI)null, "DME2DefaultCache.getCacheEntryTTLValue", "end - cache: [{}], cache entry ttl: [{}]", (Object)this.getCacheName(), (Object)ttl);
        return ttl;
    }

    @Override
    public long getExpirationTime(String key) {
        return this.getExpirationTime(new CacheElement.Key<String>(key));
    }

    public long getExpirationTime(CacheElement.Key key) {
        LOGGER.debug((URI)null, "DME2DefaultCache.getCacheEntryExpirationTime", "start - cache: [{}]", (Object)this.getCacheName());
        long expirationTime = -1L;
        if (this.cacheEntryView != null && this.getCacheMap() != null) {
            if (this.cacheEntryView.getEntry(key) != null) {
                expirationTime = this.cacheEntryView.getEntry(key).getExpirationTime();
            } else {
                LOGGER.warn(null, "DME2DefaultCache.getExpirationTime", "key: {} does not exist");
            }
        }
        LOGGER.debug((URI)null, "DME2DefaultCache.getCacheEntryExpirationTime", "end - cache: [{}], cache entry expiration time: [{}]", (Object)this.getCacheName(), (Object)expirationTime);
        return expirationTime;
    }

    @Override
    public Set<CacheElement.Key> getKeySet() {
        HashSet<CacheElement.Key> keys = new HashSet<CacheElement.Key>();
        try {
            for (CacheElement.Key k : this.getCacheMap().keySet()) {
                if (this.cacheEntryView.getEntry(k) == null || this.cacheEntryView.getEntry(k).isMarkedForRemoval()) continue;
                keys.add(k);
            }
        }
        catch (Exception e) {
            LOGGER.warn(null, "DME2DefaultCache.getKeySet", "error while getting keyset");
        }
        return keys;
    }

    public Map<CacheElement.Key, CacheElement> getCacheMap() {
        return this.cache;
    }

    @Override
    public void lock(CacheElement.Key k) {
    }

    @Override
    public void unlock(CacheElement.Key k) {
    }

    @Override
    public boolean isPutAllow(CacheElement.Key key, CacheElement.Value value) {
        return true;
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public void checkNRemoveUnusedEndpoints() {
        super.checkNRemoveUnusedEndpoints();
    }

    @Override
    public boolean isRefreshing() {
        return this.isRefreshInProgress;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void setRefreshInProgress(boolean refreshInProgress) {
        this.isRefreshInProgress = refreshInProgress;
    }
}

