/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.service;

import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Timer;
import java.util.TimerTask;

public class CacheTaskScheduler
extends Timer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheTaskScheduler.class.getName());
    private String taskName;

    public CacheTaskScheduler(String taskName, boolean isDaemon) {
        super(taskName, isDaemon);
    }

    public String getTaskName() {
        return this.taskName;
    }

    private static Method getMethodInstance(Object classObject, String method, Object[] objs) {
        LOGGER.debug(null, "CacheTaskScheduler.getMethodInstance", "start");
        Method methodInvoke = null;
        if (classObject != null) {
            Method[] allMethods;
            Class<?> c = classObject.getClass();
            LOGGER.debug(null, "{}", c.getSimpleName());
            for (Method m : allMethods = c.getDeclaredMethods()) {
                String mname = m.getName();
                if (!mname.equalsIgnoreCase(method) || (objs != null || m.getParameterTypes().length != 0) && objs == null) continue;
                LOGGER.debug((URI)null, "CacheTaskScheduler.getMethodInstance", "found method [{}] as requested", (Object)method);
                m.setAccessible(true);
                methodInvoke = m;
                break;
            }
        } else {
            LOGGER.warn(null, "CacheTaskScheduler.getMethodInstance", "warn - classObject is not initialized");
        }
        LOGGER.debug(null, "CacheTaskScheduler.getMethodInstance", "complete");
        return methodInvoke;
    }

    public static CacheTaskScheduler scheduleAtFixedRate(String taskName, boolean isDaemon, long interval, Object classObject, String method) {
        Object[] objs = null;
        return CacheTaskScheduler.scheduleAtFixedRate(taskName, isDaemon, interval, classObject, method, objs);
    }

    public static CacheTaskScheduler scheduleAtFixedRate(final String taskName, boolean isDaemon, long interval, final Object classObject, final String method, final Object ... objs) {
        LOGGER.debug(null, "CacheTaskScheduler.scheduleAtFixedRate", "start");
        CacheTaskScheduler schedule = null;
        final Method methodToInvoke = CacheTaskScheduler.getMethodInstance(classObject, method, objs);
        if (methodToInvoke == null) {
            LOGGER.debug(null, "CacheTaskScheduler.scheduleAtFixedRate", "exception - method not found");
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_009, (Throwable)new Exception("method not found"), classObject != null ? classObject.getClass().getSimpleName() : null, method);
        }
        LOGGER.debug((URI)null, "scheduleAtFixedRate", "invoking method:{}, Object params: [{}]", (Object)methodToInvoke.getName(), (Object)objs);
        schedule = new CacheTaskScheduler(taskName, isDaemon);
        schedule.taskName = taskName;
        schedule.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (methodToInvoke.getParameterTypes().length == 0) {
                            LOGGER.debug((URI)null, "scheduleAtFixedRate", "taskname {} method with no param", (Object)taskName);
                            methodToInvoke.invoke(classObject, new Object[0]);
                        } else {
                            LOGGER.debug((URI)null, "scheduleAtFixedRate", "taskname {} objs is not null; param size:{}", (Object)taskName, (Object)objs.length);
                            methodToInvoke.invoke(classObject, objs);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.debug(null, "CacheTaskScheduler.scheduleAtFixedRate", "exception - {}, {}, {}", e.getMessage(), methodToInvoke, classObject);
                        if (e.getCause() instanceof CacheException) break block4;
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_009, (Throwable)e, classObject.getClass().getSimpleName(), method);
                    }
                }
            }
        }, interval, interval);
        LOGGER.debug(null, "CacheTaskScheduler.scheduleAtFixedRate", "completed");
        return schedule;
    }
}

