/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2ServiceStatManager;
import com.att.aft.dme2.event.DME2ServiceStats;
import com.att.aft.dme2.event.EventProcessingException;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Utils;
import java.net.URI;

public class DME2CancelRequestEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DME2CancelRequestEventProcessor.class.getName());
    private DME2Configuration config;

    public DME2CancelRequestEventProcessor(DME2Configuration config) {
        this.config = config;
    }

    @Override
    public void handleEvent(DME2Event event) throws EventProcessingException {
        logger.info(null, null, "enter method - handleEvent");
        try {
            if (!EventType.CANCEL_REQUEST_EVENT.equals((Object)event.getType())) {
                return;
            }
            logger.info(null, null, "inside handleEvent of CancelRequest Type");
            this.addCancelRequestEvent(event);
        }
        catch (Throwable e) {
            logger.error((URI)null, (String)null, "error inside CancelRequest event handler", (Object)e);
        }
        logger.info(null, null, "exit method - handleEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancelRequestEvent(DME2Event event) {
        String queueName = event.getQueueName();
        logger.info((URI)null, "addCancelRequestEvent", "enter method - addCancelRequestEvent : {}", (Object)queueName);
        if (!DME2Utils.isInIgnoreList(this.config, queueName)) {
            long eventTime = event.getEventTime();
            String msgId = event.getMessageId();
            DME2ServiceStats ss = DME2ServiceStatManager.getInstance(this.config).getServiceStats(event.getQueueName());
            logger.info((URI)null, "addCancelRequestEvent", " inside method addCancelRequestEvent - msgid : {}", (Object)msgId);
            byte[] byArray = DME2ServiceStatManager.getInstance(this.config).getStatsObjLock();
            synchronized (byArray) {
                logger.info((URI)null, "addCancelRequestEvent", " inside method addCancelRequestEvent - cancel request map msgid : {}", (Object)msgId);
                DME2ServiceStatManager.getInstance(this.config).getRequestmap().remove(msgId);
                ss.lastTouchedTime = eventTime;
            }
            logger.debug((URI)null, "addCancelRequestEvent", "DME2ServiceStats addCancelRequestEvent {}; hashCode={}", (Object)DME2ServiceStatManager.getInstance(this.config).getRequestmap().size(), (Object)DME2ServiceStatManager.getInstance(this.config).getRequestmap().hashCode());
        }
        logger.info(null, "addCancelRequestEvent", "exit method - addCancelRequestEvent");
    }
}

