/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2EventManager;
import com.att.aft.dme2.event.EventProcessingException;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.event.EventQueue;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.ThreadFactory;

public class DME2EventDispatcher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DME2EventDispatcher.class.getName());
    private DME2Configuration config;
    int maxPoolSize;
    public static boolean stopThreads;
    private final transient EventQueue eventQueue;
    private transient ThreadFactory threadFactory;
    private transient DME2EventManager eventManager;

    public static boolean isStopThreads() {
        return stopThreads;
    }

    public static void setStopThreads(boolean stopThreads) {
        DME2EventDispatcher.stopThreads = stopThreads;
    }

    public DME2EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(DME2EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public DME2EventDispatcher(DME2Configuration config, EventQueue queue) {
        this.config = config;
        stopThreads = false;
        this.eventQueue = queue;
        this.threadFactory = new DefaultThreadFactory();
        this.maxPoolSize = config.getInt("AFT_DME2_EVENT_PROCESSOR_THREADS");
        logger.debug((URI)null, (String)null, "inside DME2EventDispatcher() - maxPoolSize : {}", (Object)this.maxPoolSize);
        for (int i = 0; i < this.maxPoolSize; ++i) {
            Thread workerThread = this.threadFactory.newThread(new Worker());
            workerThread.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    @Override
    public void run() {
        stopThreads = true;
    }

    class DefaultThreadFactory
    implements ThreadFactory {
        int count = 0;
        final String namePrefix;

        public DefaultThreadFactory() {
            this.namePrefix = "pool--thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(Thread.currentThread().getThreadGroup(), r, "DME2::EventWorkerThread-" + this.count, 0L);
            ++this.count;
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            t.setUncaughtExceptionHandler(new UEHLogger());
            logger.debug(null, "newThread", "inside DefaultThreadFactory -  method newThread");
            return t;
        }
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        @Override
        public void run() {
            while (!stopThreads) {
                try {
                    ArrayList<EventProcessor> procesorsList;
                    DME2Event event = DME2EventDispatcher.this.eventQueue.pollEvent();
                    if (event == null || (procesorsList = DME2EventDispatcher.this.eventManager.getListeners(event.getType().getName())) == null) continue;
                    for (EventProcessor processor : procesorsList) {
                        processor.handleEvent(event);
                    }
                }
                catch (EventProcessingException ex) {
                    logger.error((URI)null, (String)null, "exception in worker thread - method run ", (Object)ex);
                }
                catch (Throwable e) {
                    logger.error((URI)null, (String)null, "exception in worker thread - method run ", (Object)e);
                }
            }
        }
    }

    class UEHLogger
    implements Thread.UncaughtExceptionHandler {
        UEHLogger() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            logger.error((URI)null, "uncaughtException", "inside UEHLogger - uncaughtException method {} threw exception: ", (Object)t, (Object)e);
        }
    }
}

