/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.BaseMetricsPublisher;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2ServiceStatManager;
import com.att.aft.dme2.event.DME2ServiceStats;
import com.att.aft.dme2.event.EventProcessingException;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.event.MetricsPublisherFactory;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2Utils;
import java.net.URI;

public class DME2ReplyEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DME2ReplyEventProcessor.class.getName());
    private DME2Configuration config;

    public DME2ReplyEventProcessor(DME2Configuration config) {
        this.config = config;
    }

    @Override
    public void handleEvent(DME2Event event) throws EventProcessingException {
        logger.info(null, null, "enter method - handleEvent");
        try {
            if (!EventType.REPLY_EVENT.equals((Object)event.getType())) {
                return;
            }
            logger.info(null, null, "inside handleEvent of ReplyEvent Type");
            this.addReplyEvent(event);
        }
        catch (Throwable e) {
            logger.error((URI)null, (String)null, "error inside ReplyEvent Handler", (Object)e);
        }
        logger.info(null, null, "exit method - handleEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplyEvent(DME2Event event) throws Exception {
        String queueName = event.getQueueName();
        logger.debug((URI)null, "addReplyEvent", "enter method - addReplyEvent : {}", (Object)queueName);
        logger.debug(null, "addReplyEvent", "enter method - addReplyEvent : DME2ServiceStatManager.getInstance(config).getRequestmap() :" + DME2ServiceStatManager.getInstance(this.config).getRequestmap());
        if (!DME2Utils.isInIgnoreList(this.config, queueName)) {
            DME2Event re;
            String protocol;
            long eventTime = event.getEventTime();
            String msgId = event.getMessageId();
            long elapsed = event.getElapsedTime();
            long replyMsgSize = event.getReplyMsgSize();
            String partner = event.getPartner();
            String role = event.getRole();
            if (partner == null) {
                partner = DME2Constants.DEFAULT_NA_VALUE;
            }
            if (role == null) {
                role = this.config.getProperty("AFT_DME2_INTERFACE_SERVER_ROLE");
            }
            if ((protocol = event.getProtocol()) == null) {
                protocol = this.config.getProperty("AFT_DME2_INTERFACE_JMS_PROTOCOL");
            }
            String port = event.getInterfacePort();
            DME2ServiceStats ss = DME2ServiceStatManager.getInstance(this.config).getServiceStats(event.getQueueName());
            logger.debug((URI)null, "addReplyEvent", " inside method addReplyEvent - msgid : {}", (Object)msgId);
            if (!DME2ServiceStatManager.getInstance(this.config).isDisableMetrics()) {
                logger.debug((URI)null, "addReplyEvent", "{},{},{},{},{},{},{},{},{},{}", new Object[]{System.currentTimeMillis(), ss.service, ss.serviceVersion, role, port, protocol, EventType.REPLY_EVENT, msgId, elapsed, elapsed});
                logger.debug(null, "addReplyEvent", "MetricsCollectorFactory.getMetricsCollector containerName={},containerVersion={},containerRO={},containerEnv={},containerPlat={},containerHost={},containerPid={}", ss.containerName, ss.containerVersion, ss.containerRO, ss.containerEnv, ss.containerPlat, ss.containerHost, ss.containerPid);
                MetricsPublisherFactory.getInstance();
                BaseMetricsPublisher metricsPublisher = MetricsPublisherFactory.getBaseMetricsPublisherHandlerInstance(this.config);
                metricsPublisher.publishEvent(event, ss);
            }
            byte[] byArray = DME2ServiceStatManager.getInstance(this.config).getStatsObjLock();
            synchronized (byArray) {
                logger.debug(null, null, " inside method addReplyEvent - removing message from requestmap msgid : " + msgId);
                re = DME2ServiceStatManager.getInstance(this.config).getRequestmap().remove(msgId);
            }
            logger.debug(null, "addReplyEvent", "DME2ServiceStats.addReplyEvent {}; hashCode {};props=", DME2ServiceStatManager.getInstance(this.config).getRequestmap().size(), DME2ServiceStatManager.getInstance(this.config).getRequestmap().hashCode(), event);
            if (re != null && role.equals(this.config.getProperty("AFT_DME2_INTERFACE_SERVER_ROLE"))) {
                logger.debug(null, null, "inside method - addReplyEvent : DME2_INTERFACE_SERVER_ROLE ");
                ss.setLastRequestElapsed(elapsed);
                ++ss.replyCount;
                ss.setLastTouchedTime(eventTime);
                ss.setLastReplyMsgSize(replyMsgSize);
                ss.totalElapsed = ss.totalElapsed == -1L ? elapsed : (ss.totalElapsed += elapsed);
                if (ss.minElapsed == -1L) {
                    ss.minElapsed = elapsed;
                }
                if (ss.maxElapsed == -1L) {
                    ss.maxElapsed = elapsed;
                }
                if (elapsed > ss.maxElapsed) {
                    ss.maxElapsed = elapsed;
                }
                if (elapsed < ss.minElapsed) {
                    ss.minElapsed = elapsed;
                }
            }
        }
        logger.debug(null, null, "exit method - addReplyEvent");
    }
}

