/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2ServiceStatManager;
import com.att.aft.dme2.event.DME2ServiceStats;
import com.att.aft.dme2.event.EventProcessingException;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Utils;
import java.net.URI;

public class DME2RequestEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DME2RequestEventProcessor.class.getName());
    private DME2Configuration config;

    public DME2RequestEventProcessor(DME2Configuration config) {
        this.config = config;
    }

    @Override
    public void handleEvent(DME2Event event) throws EventProcessingException {
        logger.info(null, "handleEvent", "enter method - handleEvent");
        try {
            if (!EventType.REQUEST_EVENT.equals((Object)event.getType())) {
                return;
            }
            logger.info(null, "handleEvent", "inside handleEvent of Request Type");
            this.addRequestEvent(event);
        }
        catch (Throwable e) {
            logger.error((URI)null, "handleEvent", "error inside Request event handler", (Object)e);
        }
        logger.info(null, "handleEvent", "exit method - handleEvent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestEvent(DME2Event event) {
        String queueName = event.getQueueName();
        logger.info((URI)null, "addRequestEvent", "enter method - addRequestEvent : {}", (Object)queueName);
        if (!DME2Utils.isInIgnoreList(this.config, queueName)) {
            long eventTime = event.getEventTime();
            long reqMsgSize = event.getReqMsgSize();
            String msgId = event.getMessageId();
            DME2ServiceStats ss = DME2ServiceStatManager.getInstance(this.config).getServiceStats(event.getQueueName());
            logger.info((URI)null, "addRequestEvent", " inside method addRequestEvent - msgid : {}", (Object)msgId);
            byte[] byArray = DME2ServiceStatManager.getInstance(this.config).getStatsObjLock();
            synchronized (byArray) {
                logger.info((URI)null, "addRequestEvent", " inside method addRequestEvent - add event in request map msgid : {}", (Object)msgId);
                DME2ServiceStatManager.getInstance(this.config).getRequestmap().put(msgId, event);
                ss.lastTouchedTime = eventTime;
                ++ss.requestCount;
                ss.currentHourRequestCount = DME2Utils.isCurrentHourMillis(eventTime) ? ++ss.currentHourRequestCount : 0L;
                ss.lastRequestMsgSize = reqMsgSize;
            }
            logger.debug((URI)null, "addRequestEvent", "DME2ServiceStats addRequestEvent {}; hashCode={}", (Object)DME2ServiceStatManager.getInstance(this.config).getRequestmap().size(), (Object)DME2ServiceStatManager.getInstance(this.config).getRequestmap().hashCode());
        }
        logger.info(null, "addRequestEvent", "exit method - addRequestEvent");
    }
}

