/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.ErrorContext;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.URI;
import java.util.Date;

public class DME2ServiceStats {
    private byte[] statsObjLock = new byte[0];
    private Logger logger = LoggerFactory.getLogger(DME2ServiceStats.class.getName());
    private long createTime = 0L;
    long lastTouchedTime = 0L;
    long requestCount = 0L;
    long currentHourRequestCount = 0L;
    long replyCount = 0L;
    long failoverCount = 0L;
    long maxElapsed = -1L;
    long minElapsed = -1L;
    private long lastRequestElapsed = -1L;
    long lastRequestMsgSize = -1L;
    private long lastReplyMsgSize = -1L;
    private String queueName;
    long totalElapsed = -1L;
    private long expiredCount = 0L;
    private DME2Configuration config;
    String service;
    String serviceVersion;
    String serviceEnv;
    String containerName;
    String containerVersion;
    String containerEnv;
    String containerPlat;
    String containerHost;
    String containerPid;
    String containerRO;

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getServiceEnv() {
        return this.serviceEnv;
    }

    public void setServiceEnv(String serviceEnv) {
        this.serviceEnv = serviceEnv;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getContainerVersion() {
        return this.containerVersion;
    }

    public void setContainerVersion(String containerVersion) {
        this.containerVersion = containerVersion;
    }

    public String getContainerEnv() {
        return this.containerEnv;
    }

    public void setContainerEnv(String containerEnv) {
        this.containerEnv = containerEnv;
    }

    public String getContainerPlat() {
        return this.containerPlat;
    }

    public void setContainerPlat(String containerPlat) {
        this.containerPlat = containerPlat;
    }

    public String getContainerHost() {
        return this.containerHost;
    }

    public void setContainerHost(String containerHost) {
        this.containerHost = containerHost;
    }

    public String getContainerPid() {
        return this.containerPid;
    }

    public void setContainerPid(String containerPid) {
        this.containerPid = containerPid;
    }

    public String getContainerRO() {
        return this.containerRO;
    }

    public void setContainerRO(String containerRO) {
        this.containerRO = containerRO;
    }

    public DME2ServiceStats(DME2Configuration config, String queueName) {
        this.config = config;
        this.queueName = queueName;
        this.createTime = System.currentTimeMillis();
        System.setProperty("metrics.publish.interval", "" + config.getLong("AFT_DME2_PUBLISH_METRICS_INTERVAL"));
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.logger.debug((URI)null, "DME2ServiceStats", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
        }
        this.containerName = config.getProperty(config.getProperty("AFT_DME2_CONTAINER_NAME_KEY"), System.getProperty(config.getProperty("AFT_DME2_CONTAINER_NAME_KEY")));
        if (this.containerName == null) {
            this.containerName = DME2Constants.DEFAULT_NA_VALUE;
        }
        this.containerVersion = config.getProperty(config.getProperty("AFT_DME2_CONTAINER_VERSION_KEY"), System.getProperty(config.getProperty("AFT_DME2_CONTAINER_VERSION_KEY")));
        if (this.containerVersion == null) {
            this.containerVersion = DME2Constants.DEFAULT_NA_VALUE;
        }
        this.containerRO = config.getProperty(config.getProperty("AFT_DME2_CONTAINER_ROUTEOFFER_KEY"), System.getProperty(config.getProperty("AFT_DME2_CONTAINER_ROUTEOFFER_KEY")));
        if (this.containerRO == null) {
            this.containerRO = DME2Constants.DEFAULT_NA_VALUE;
        }
        this.containerEnv = config.getProperty(config.getProperty("AFT_DME2_CONTAINER_ENV_KEY"), System.getProperty(config.getProperty("AFT_DME2_CONTAINER_ENV_KEY")));
        if (this.containerEnv == null) {
            this.containerEnv = DME2Constants.DEFAULT_NA_VALUE;
        }
        this.containerPlat = config.getProperty(config.getProperty("AFT_DME2_CONTAINER_SCLD_PLATFORM_KEY"), System.getProperty(config.getProperty("AFT_DME2_CONTAINER_SCLD_PLATFORM_KEY")));
        if (this.containerPlat == null) {
            this.containerPlat = config.getProperty(config.getProperty("AFT_DME2_CONTAINER_PLATFORM_KEY"), System.getProperty(config.getProperty("AFT_DME2_CONTAINER_PLATFORM_KEY")));
        }
        if (this.containerPlat == null) {
            this.containerPlat = DME2Constants.DEFAULT_NA_VALUE;
        }
        this.containerHost = config.getProperty("AFT_DME2_CONTAINER_HOST_KEY");
        if (this.containerHost == null) {
            this.containerHost = host;
        }
        String pid = null;
        try {
            RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
            String temp = rmxb.getName();
            if (temp != null && temp.contains("@")) {
                String[] temps = temp.split("@");
                pid = temps[0];
            }
        }
        catch (Throwable e) {
            this.logger.debug((URI)null, "DME2ServiceStats", LogMessage.DEBUG_MESSAGE, (Object)"Throwable", (Object)e);
        }
        if (pid == null) {
            pid = DME2Constants.DEFAULT_NA_VALUE;
        }
        this.containerPid = config.getProperty("AFT_DME2_CONTAINER_PID_KEY");
        if (this.containerPid == null) {
            this.containerPid = DME2Constants.DEFAULT_NA_VALUE;
        }
        if (this.containerRO != null) {
            this.containerRO = this.containerRO.replaceAll("'", "");
        }
        this.logger.debug(null, "ctor(String)", "containerName={},containerVersion={},containerRO={},containerEnv={},containerPlat={},containerHost={},containerPid={}", this.containerName, this.containerVersion, this.containerRO, this.containerEnv, this.containerPlat, this.containerHost, this.containerPid);
        try {
            String urlStr = DME2Utils.formatClientURIString(queueName);
            DmeUniformResource uniformResource = new DmeUniformResource(config, new URI(urlStr));
            this.service = uniformResource.getService();
            this.serviceVersion = uniformResource.getVersion();
            this.serviceEnv = uniformResource.getEnvContext();
        }
        catch (Exception e) {
            this.logger.debug((URI)null, "DME2ServiceStats", LogMessage.DEBUG_MESSAGE, (Object)"error inside Service Stats Initialization metod DME2ServiceStats(String queueName", (Object)e);
        }
    }

    public String[] getStats() {
        BigDecimal tpsValue = null;
        BigDecimal avgEl = null;
        try {
            tpsValue = new BigDecimal((double)this.currentHourRequestCount / 300.0);
            tpsValue = tpsValue.setScale(4, 4);
            avgEl = this.replyCount == 0L ? new BigDecimal(0) : new BigDecimal(this.totalElapsed / this.replyCount);
            avgEl = avgEl.setScale(4, 4);
        }
        catch (Exception e) {
            this.logger.error((URI)null, "getStats", "AFT-DME2-1901", (Object)new ErrorContext().add("queueName", this.queueName).add("extendedMessage", e.getMessage()), (Object)e);
        }
        String[] retString = new String[]{"Statistics for", "DME2 Queue=" + this.queueName, "\tCreate Date=" + new Date(this.createTime), "\tLast Touched=" + (this.lastTouchedTime == 0L ? new Date(this.createTime) : new Date(this.lastTouchedTime)), "\tPuts=" + this.requestCount, "\tGets=" + this.replyCount, "\tCurrentHourTPS=" + (tpsValue != null ? tpsValue : Integer.valueOf(0)), "\tCurrentHourRequestCount=" + this.currentHourRequestCount, "\tTotalRequestCount=" + this.requestCount, "\tFailoverCount=" + this.failoverCount, "\tLastRequestSize=" + this.lastRequestMsgSize, "\tLastReplySize=" + this.lastReplyMsgSize, "\tMinElapsed=" + this.minElapsed, "\tMaxElapsed=" + this.maxElapsed, "\tLastElapsed=" + this.lastRequestElapsed, "\tAverageElapsed=" + (avgEl != null ? avgEl : Integer.valueOf(0))};
        return retString;
    }

    public String toString() {
        BigDecimal tpsValue = new BigDecimal((double)this.requestCount / 300.0);
        tpsValue = tpsValue.setScale(4, 4);
        return "\tStatistics for \t\tQueue\t\t:\t" + this.queueName + "\t\tCreate Date\t\t \t\t Last Touched \t\t\t\t Current Size \t\t\t\t Puts\t\t\t\t Gets\t\t\t\t Expired\t\t\t\t RequestCount\t\t" + this.requestCount + "\t\t Average TPS\t\t" + tpsValue + "\t\t Max ElapsedTime\t\t\t\t Min ElapsedTime\t\t\t\t Avg RequestMsg Size \t\t\t\t Avg ResponseMsg Size\t\t";
    }

    public void setLastTouchedTime(long lastTouchedTime) {
        this.lastTouchedTime = lastTouchedTime;
    }

    public byte[] getStatsObjLock() {
        return this.statsObjLock;
    }

    public long getCurrentHourRequestCount() {
        return this.currentHourRequestCount;
    }

    public void setCurrentHourRequestCount(long currentHourRequestCount) {
        this.currentHourRequestCount = currentHourRequestCount;
    }

    public void setStatsObjLock(byte[] statsObjLock) {
        this.statsObjLock = statsObjLock;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(long requestCount) {
        this.requestCount = requestCount;
    }

    public long getReplyCount() {
        return this.replyCount;
    }

    public void setReplyCount(long replyCount) {
        this.replyCount = replyCount;
    }

    public long getFailoverCount() {
        return this.failoverCount;
    }

    public void setFailoverCount(long failoverCount) {
        this.failoverCount = failoverCount;
    }

    public long getMaxElapsed() {
        return this.maxElapsed;
    }

    public void setMaxElapsed(long maxElapsed) {
        this.maxElapsed = maxElapsed;
    }

    public long getMinElapsed() {
        return this.minElapsed;
    }

    public void setMinElapsed(long minElapsed) {
        this.minElapsed = minElapsed;
    }

    public long getLastRequestElapsed() {
        return this.lastRequestElapsed;
    }

    public void setLastRequestElapsed(long lastRequestElapsed) {
        this.lastRequestElapsed = lastRequestElapsed;
    }

    public long getLastRequestMsgSize() {
        return this.lastRequestMsgSize;
    }

    public void setLastRequestMsgSize(long lastRequestMsgSize) {
        this.lastRequestMsgSize = lastRequestMsgSize;
    }

    public long getLastReplyMsgSize() {
        return this.lastReplyMsgSize;
    }

    public void setLastReplyMsgSize(long lastReplyMsgSize) {
        this.lastReplyMsgSize = lastReplyMsgSize;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public long getTotalElapsed() {
        return this.totalElapsed;
    }

    public void setTotalElapsed(long totalElapsed) {
        this.totalElapsed = totalElapsed;
    }

    public long getExpiredCount() {
        return this.expiredCount;
    }

    public void setExpiredCount(long expiredCount) {
        this.expiredCount = expiredCount;
    }

    public long getLastTouchedTime() {
        return this.lastTouchedTime;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }
}

