/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.EventQueueException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class EventQueue {
    private final BlockingQueue<DME2Event> eventQueue;

    public EventQueue() {
        this.eventQueue = new LinkedBlockingQueue<DME2Event>();
    }

    public EventQueue(int capacity) {
        this.eventQueue = new LinkedBlockingQueue<DME2Event>(capacity);
    }

    public DME2Event getEvent() throws EventQueueException {
        try {
            return this.eventQueue.take();
        }
        catch (InterruptedException e) {
            throw new EventQueueException(e);
        }
    }

    public DME2Event pollEvent() throws EventQueueException {
        try {
            return this.eventQueue.poll(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new EventQueueException(e);
        }
    }

    public void addEvent(DME2Event event) throws EventQueueException {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            EventQueueException we = new EventQueueException(e.getMessage());
            throw we;
        }
    }

    public int getSize() {
        return this.eventQueue.size();
    }
}

