/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.handler;

import com.att.aft.dme2.api.DME2Client;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DME2Payload;
import com.att.aft.dme2.util.ErrorContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DME2RestfulHandler
implements AsyncResponseHandlerIntf {
    private String service = null;
    private Throwable e = null;
    private final byte[] waiter = new byte[0];
    private final ResponseInfo rinfo = new ResponseInfo();
    private static final Logger logger = LoggerFactory.getLogger(DME2RestfulHandler.class.getName());

    public DME2RestfulHandler(String service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Map<String, String> requestHeaders, Throwable e) {
        this.e = e;
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            this.waiter.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ResponseInfo getResponse(long timeoutMs) throws Exception {
        logger.debug(null, "getResponse", LogMessage.METHOD_ENTER);
        long start = System.currentTimeMillis();
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            block11: {
                if (this.rinfo.body != null) {
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    return this.rinfo;
                }
                if (this.e != null) {
                    if (!(this.e instanceof Exception)) {
                        throw new RuntimeException(this.e);
                    }
                    throw (Exception)this.e;
                }
                try {
                    logger.debug((URI)null, "getResponse", "Waiting {} ms", (Object)timeoutMs);
                    this.waiter.wait(timeoutMs);
                }
                catch (InterruptedException ie) {
                    long elapsed = System.currentTimeMillis() - start;
                    logger.debug((URI)null, "getResponse", "DME2RestfulHandler interruptedException. ElapsedTime={}; timeoutMs={}", (Object)elapsed, (Object)timeoutMs);
                    if (elapsed >= timeoutMs) break block11;
                    this.waiter.wait(timeoutMs - elapsed);
                }
            }
            if (this.rinfo.body != null) {
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return this.rinfo;
            }
            if (this.e != null) {
                if (!(this.e instanceof Exception)) {
                    throw new RuntimeException(this.e);
                }
                throw (Exception)this.e;
            }
            logger.error(null, "getResponse", "Timeout");
            throw new DME2Exception("AFT-DME2-0999", new ErrorContext().add("service", this.service).add("timeoutMs", timeoutMs + ""), (Throwable)new Exception("Service call timedout"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReply(int responseCode, String responseMessage, InputStream in, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        this.rinfo.code = responseCode;
        if (responseHeaders != null) {
            this.rinfo.headers = new HashMap(responseHeaders.size());
            for (Map.Entry<String, String> eSet : responseHeaders.entrySet()) {
                this.rinfo.headers.put(eSet.getKey(), eSet.getValue());
            }
        }
        StringBuilder output = new StringBuilder();
        try {
            String line;
            String charset = this.findCharSet(responseHeaders);
            BufferedReader br = charset != null ? new BufferedReader(new InputStreamReader(in, charset)) : new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                output.append(line);
                output.append("\n");
            }
        }
        catch (IOException io) {
            this.e = new Exception("UNABLE TO READ RESPONSE MESSAGE");
            this.e.initCause(io);
        }
        if (responseMessage != null) {
            output.append(responseMessage);
        }
        this.rinfo.body = output.toString().trim().replaceAll("Error 401", "Error 401 Unauthorized");
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            this.waiter.notify();
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    private String findCharSet(Map<String, String> parameterMap) {
        if (parameterMap == null) {
            return null;
        }
        String charset = parameterMap.get("Content-Type");
        if (charset == null) {
            charset = parameterMap.get("content-type");
        }
        if (charset != null) {
            String[] toks = charset.split(";");
            if (toks.length > 1) {
                charset = toks[1];
                String[] toks2 = toks[1].split("=");
                charset = toks2.length > 1 ? toks2[1] : null;
            } else {
                charset = null;
            }
        }
        return charset;
    }

    public static ResponseInfo callService(String service, Integer timeoutMs, String httpMethod, String urlContext, Map<String, String> queryParams, Map<String, String> requestHeaders, String requestPayload) throws Exception {
        DME2RestfulHandler replyHandler = new DME2RestfulHandler(service);
        DME2Client sender = new DME2Client(new URI(service), timeoutMs.intValue());
        sender.setAllowAllHttpReturnCodes(true);
        sender.setMethod(httpMethod);
        sender.setSubContext(urlContext);
        sender.setQueryParams(queryParams, true);
        sender.setHeaders(requestHeaders);
        sender.setPayload(requestPayload);
        sender.setReplyHandler(replyHandler);
        sender.send();
        ResponseInfo reply = replyHandler.getResponse(timeoutMs.intValue());
        return reply;
    }

    public static ResponseInfo callService(String service, Integer timeoutMs, String httpMethod, String urlContext, Map<String, String> queryParams, Map<String, String> requestHeaders, DME2Payload requestPayload) throws Exception {
        return DME2RestfulHandler.callService_mod(service, timeoutMs, httpMethod, urlContext, queryParams, requestHeaders, requestPayload, null, null);
    }

    public static ResponseInfo callService(String service, Integer timeoutMs, String httpMethod, String urlContext, Map<String, String> queryParams, Map<String, String> requestHeaders, DME2Payload requestPayload, String username, String password) throws Exception {
        return DME2RestfulHandler.callService_mod(service, timeoutMs, httpMethod, urlContext, queryParams, requestHeaders, requestPayload, username, password);
    }

    private static ResponseInfo callService_mod(String service, Integer timeoutMs, String httpMethod, String urlContext, Map<String, String> queryParams, Map<String, String> requestHeaders, DME2Payload requestPayload, String username, String password) throws Exception {
        DME2RestfulHandler replyHandler = new DME2RestfulHandler(service);
        DME2Client sender = new DME2Client(new URI(service), timeoutMs.intValue());
        sender.setAllowAllHttpReturnCodes(true);
        sender.setMethod(httpMethod);
        sender.setSubContext(urlContext);
        sender.setDME2Payload(requestPayload);
        sender.setReplyHandler(replyHandler);
        if (requestHeaders != null) {
            sender.setHeaders(requestHeaders);
        }
        if (queryParams != null) {
            sender.setQueryParams(queryParams, true);
        }
        if (username != null && password != null) {
            sender.setCredentials(username, password);
        }
        sender.send();
        ResponseInfo reply = replyHandler.getResponse(timeoutMs.intValue());
        return reply;
    }

    public class ResponseInfo {
        private String body;
        private Integer code;
        private Map<String, String> headers;

        public String header(String name) {
            return this.headers.get(name);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.code).append("\n");
            if (this.headers != null) {
                for (Map.Entry<String, String> eSet : this.headers.entrySet()) {
                    if (eSet.getValue().contains(",<")) {
                        for (String s : eSet.getValue().split(",<")) {
                            sb.append(eSet.getKey()).append("=").append(s.charAt(0) == '<' ? "" : "<").append(s).append("\n");
                        }
                        continue;
                    }
                    sb.append(eSet.getKey()).append("=").append(eSet.getValue()).append("\n");
                }
            }
            sb.append(this.body);
            return sb.toString();
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }
    }
}

