/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.handler;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class DefaultAsyncResponseHandler
implements AsyncResponseHandlerIntf {
    private static Logger logger = LoggerFactory.getLogger(DefaultAsyncResponseHandler.class.getName());
    private DME2Configuration config;
    private Throwable e = null;
    private String response = null;
    private final byte[] waiter = new byte[0];
    private final String service;
    private boolean allowAllHttpReturnCodes = false;

    public DefaultAsyncResponseHandler(String service) {
        this.service = service;
    }

    public DefaultAsyncResponseHandler(DME2Configuration config, String service, boolean allowAllHttpReturnCodes) {
        this.config = config;
        this.service = service;
        this.allowAllHttpReturnCodes = allowAllHttpReturnCodes;
    }

    @Override
    public String getResponse(long timeoutMs) throws Exception {
        long start = System.currentTimeMillis();
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            block12: {
                if (this.response != null) {
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    return this.response;
                }
                if (this.e != null) {
                    if (!(this.e instanceof Exception)) {
                        throw new DME2Exception("AFT-DME2-0998", new ErrorContext().add("service", this.service), this.e);
                    }
                    if (this.e instanceof DME2Exception) {
                        throw new DME2Exception(((DME2Exception)this.e).getErrorCode(), ((DME2Exception)this.e).getErrorMessage(), this.e);
                    }
                    throw new DME2Exception("AFT-DME2-0998", new ErrorContext().add("service", this.service), this.e);
                }
                try {
                    this.waiter.wait(timeoutMs);
                }
                catch (InterruptedException ie) {
                    long elapsed = System.currentTimeMillis() - start;
                    logger.debug((URI)null, "getResponse", "DefaultAsyncResponseHandler interruptedException. ElapsedTime={}; timeoutMs={}", (Object)elapsed, (Object)timeoutMs);
                    if (elapsed >= timeoutMs) break block12;
                    this.waiter.wait(timeoutMs - elapsed);
                }
            }
            if (this.response != null) {
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return this.response;
            }
            if (this.e != null) {
                if (!(this.e instanceof Exception)) {
                    throw new RuntimeException(this.e);
                }
                throw (Exception)this.e;
            }
            throw new DME2Exception("AFT-DME2-0998", new ErrorContext().add("service", this.service).add("timeoutMs", timeoutMs + ""), (Throwable)new Exception("Service call timedout"));
        }
    }

    private String findCharSet(Map<String, String> parameterMap) {
        String charset = parameterMap.get("Content-Type");
        if (charset == null) {
            charset = parameterMap.get("content-type");
        }
        if (charset != null) {
            String[] toks = charset.split(";");
            if (toks.length > 1) {
                charset = toks[1];
                String[] toks2 = toks[1].split("=");
                charset = toks2.length > 1 ? toks2[1] : null;
            } else {
                charset = null;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Map<String, String> requestHeaders, Throwable e) {
        this.e = e;
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            this.waiter.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReply(int responseCode, String responseMessage, InputStream in, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        GZIPInputStream gis = null;
        if (this.allowAllHttpReturnCodes || responseCode == 200) {
            if (responseHeaders != null && responseHeaders.get(this.config.getProperty("AFT_DME2_CONTENT_ENCODING_KEY")) != null && this.config.getBoolean("AFT_DME2_ALLOW_COMPRESS_ENCODING") && responseHeaders.get(this.config.getProperty("AFT_DME2_CONTENT_ENCODING_KEY")).equalsIgnoreCase(this.config.getProperty("AFT_DME2_COMPRESS_ENCODING"))) {
                try {
                    gis = new GZIPInputStream(in);
                }
                catch (Exception e) {
                    this.e = new Exception("Content-Encoding set to gzip;UNABLE TO PARSE GZIP'D RESPONSE MESSAGE");
                    this.e.initCause(e);
                    return;
                }
            }
            BufferedReader reader = null;
            try {
                String charset = this.findCharSet(responseHeaders);
                reader = charset != null ? (gis == null ? new BufferedReader(new InputStreamReader(in, charset)) : new BufferedReader(new InputStreamReader(gis, charset))) : (gis == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(gis)));
                char[] buffer = new char[8096];
                StringBuilder inputText = new StringBuilder(8096);
                int n = -1;
                while ((n = reader.read(buffer)) != -1) {
                    inputText.append(buffer, 0, n);
                }
                this.response = inputText.toString();
            }
            catch (IOException e) {
                this.e = new Exception("UNABLE TO READ RESPONSE MESSAGE");
                this.e.initCause(e);
                return;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    logger.warn((URI)null, "handleReply", "IOException: ", (Object)e);
                }
            }
        }
        if (responseCode == 500 && responseMessage != null) {
            this.response = responseMessage;
        } else {
            this.e = new Exception("Call Failed, RC=" + responseCode + " - " + responseMessage);
        }
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            this.waiter.notify();
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return;
        }
    }
}

