/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl;

import com.att.aft.dme2.hazelcast.cache.ICache;
import com.att.aft.dme2.hazelcast.cache.impl.CacheContext;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryEventImpl;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryListenerProvider;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEventData;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEventListener;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEventSet;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEventType;
import com.att.aft.dme2.hazelcast.cache.impl.CacheService;
import com.att.aft.dme2.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.att.aft.dme2.hazelcast.core.HazelcastInstance;
import com.att.aft.dme2.hazelcast.core.HazelcastInstanceAware;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.EventRegistration;
import com.att.aft.dme2.hazelcast.spi.ListenerWrapperEventFilter;
import com.att.aft.dme2.hazelcast.spi.NotifiableEventListener;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="Class is Serializable, but doesn't define serialVersionUID")
public class CacheEventListenerAdaptor<K, V>
implements CacheEventListener,
CacheEntryListenerProvider<K, V>,
NotifiableEventListener<CacheService>,
ListenerWrapperEventFilter,
Serializable {
    private final transient CacheEntryListener<K, V> cacheEntryListener;
    private final transient CacheEntryCreatedListener cacheEntryCreatedListener;
    private final transient CacheEntryRemovedListener cacheEntryRemovedListener;
    private final transient CacheEntryUpdatedListener cacheEntryUpdatedListener;
    private final transient CacheEntryExpiredListener cacheEntryExpiredListener;
    private final transient CacheEntryEventFilter<? super K, ? super V> filter;
    private final boolean isOldValueRequired;
    private transient SerializationService serializationService;
    private transient ICache<K, V> source;

    public CacheEventListenerAdaptor(ICache<K, V> source, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, SerializationService serializationService, HazelcastInstance hazelcastInstance) {
        this.source = source;
        this.serializationService = serializationService;
        this.cacheEntryListener = this.createCacheEntryListener(cacheEntryListenerConfiguration, hazelcastInstance);
        this.cacheEntryCreatedListener = this.cacheEntryListener instanceof CacheEntryCreatedListener ? (CacheEntryCreatedListener)this.cacheEntryListener : null;
        this.cacheEntryRemovedListener = this.cacheEntryListener instanceof CacheEntryRemovedListener ? (CacheEntryRemovedListener)this.cacheEntryListener : null;
        this.cacheEntryUpdatedListener = this.cacheEntryListener instanceof CacheEntryUpdatedListener ? (CacheEntryUpdatedListener)this.cacheEntryListener : null;
        this.cacheEntryExpiredListener = this.cacheEntryListener instanceof CacheEntryExpiredListener ? (CacheEntryExpiredListener)this.cacheEntryListener : null;
        this.injectDependencies(this.cacheEntryListener, hazelcastInstance);
        Factory filterFactory = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory();
        this.filter = filterFactory != null ? (CacheEntryEventFilter)filterFactory.create() : null;
        this.injectDependencies(this.filter, hazelcastInstance);
        this.isOldValueRequired = cacheEntryListenerConfiguration.isOldValueRequired();
    }

    private CacheEntryListener<K, V> createCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, HazelcastInstance hazelcastInstance) {
        Factory cacheEntryListenerFactory = cacheEntryListenerConfiguration.getCacheEntryListenerFactory();
        this.injectDependencies(cacheEntryListenerFactory, hazelcastInstance);
        return (CacheEntryListener)cacheEntryListenerFactory.create();
    }

    private void injectDependencies(Object obj, HazelcastInstance hazelcastInstance) {
        if (obj instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)obj).setHazelcastInstance(hazelcastInstance);
        }
    }

    @Override
    public CacheEntryListener<K, V> getCacheEntryListener() {
        return this.cacheEntryListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(Object eventObject) {
        if (eventObject instanceof CacheEventSet) {
            CacheEventSet cacheEventSet = (CacheEventSet)eventObject;
            try {
                if (cacheEventSet.getEventType() != CacheEventType.COMPLETED) {
                    this.handleEvent(cacheEventSet.getEventType().getType(), cacheEventSet.getEvents());
                }
            }
            finally {
                ((CacheSyncListenerCompleter)((Object)this.source)).countDownCompletionLatch(cacheEventSet.getCompletionId());
            }
        }
    }

    private void handleEvent(int type, Collection<CacheEventData> keys) {
        Iterable<CacheEntryEvent<K, V>> cacheEntryEvent = this.createCacheEntryEvent(keys);
        CacheEventType eventType = CacheEventType.getByType(type);
        switch (eventType) {
            case CREATED: {
                if (this.cacheEntryCreatedListener == null) break;
                this.cacheEntryCreatedListener.onCreated(cacheEntryEvent);
                break;
            }
            case UPDATED: {
                if (this.cacheEntryUpdatedListener == null) break;
                this.cacheEntryUpdatedListener.onUpdated(cacheEntryEvent);
                break;
            }
            case REMOVED: {
                if (this.cacheEntryRemovedListener == null) break;
                this.cacheEntryRemovedListener.onRemoved(cacheEntryEvent);
                break;
            }
            case EXPIRED: {
                if (this.cacheEntryExpiredListener == null) break;
                this.cacheEntryExpiredListener.onExpired(cacheEntryEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type: " + eventType.name());
            }
        }
    }

    private Iterable<CacheEntryEvent<? extends K, ? extends V>> createCacheEntryEvent(Collection<CacheEventData> keys) {
        HashSet<CacheEntryEvent<K, V>> evt = new HashSet<CacheEntryEvent<K, V>>();
        for (CacheEventData cacheEventData : keys) {
            EventType eventType = CacheEventType.convertToEventType(cacheEventData.getCacheEventType());
            Object key = this.toObject(cacheEventData.getDataKey());
            Object newValue = this.toObject(cacheEventData.getDataValue());
            Object oldValue = this.isOldValueRequired ? (Object)this.toObject(cacheEventData.getDataOldValue()) : null;
            CacheEntryEventImpl<K, Object> event = new CacheEntryEventImpl<K, Object>(this.source, eventType, key, newValue, oldValue);
            if (this.filter != null && !this.filter.evaluate(event)) continue;
            evt.add(event);
        }
        return evt;
    }

    private <T> T toObject(Data data) {
        return this.serializationService.toObject(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(int type, Collection<CacheEventData> keys, int completionId) {
        try {
            if (CacheEventType.getByType(type) != CacheEventType.COMPLETED) {
                this.handleEvent(type, keys);
            }
        }
        finally {
            ((CacheSyncListenerCompleter)((Object)this.source)).countDownCompletionLatch(completionId);
        }
    }

    @Override
    public void onRegister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
        CacheContext cacheContext = cacheService.getOrCreateCacheContext(topic);
        cacheContext.increaseCacheEntryListenerCount();
    }

    @Override
    public void onDeregister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
        CacheContext cacheContext = cacheService.getOrCreateCacheContext(topic);
        cacheContext.decreaseCacheEntryListenerCount();
    }

    @Override
    public boolean eval(Object event) {
        return true;
    }

    @Override
    public Object getListener() {
        return this;
    }
}

