/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl;

import com.att.aft.dme2.hazelcast.cache.impl.AbstractCacheProxy;
import com.att.aft.dme2.hazelcast.cache.impl.AbstractCacheProxyBase;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.att.aft.dme2.hazelcast.cache.impl.CachePartitionIterator;
import com.att.aft.dme2.hazelcast.cache.impl.CacheProxyUtil;
import com.att.aft.dme2.hazelcast.cache.impl.ClusterWideIterator;
import com.att.aft.dme2.hazelcast.cache.impl.ICacheService;
import com.att.aft.dme2.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.att.aft.dme2.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.att.aft.dme2.hazelcast.cache.impl.event.InternalCachePartitionLostListenerAdapter;
import com.att.aft.dme2.hazelcast.cache.impl.operation.CacheListenerRegistrationOperation;
import com.att.aft.dme2.hazelcast.config.CacheConfig;
import com.att.aft.dme2.hazelcast.core.Member;
import com.att.aft.dme2.hazelcast.logging.ILogger;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.EventRegistration;
import com.att.aft.dme2.hazelcast.spi.InternalCompletableFuture;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.Operation;
import com.att.aft.dme2.hazelcast.spi.OperationService;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class CacheProxy<K, V>
extends AbstractCacheProxy<K, V> {
    protected final ILogger logger = this.getNodeEngine().getLogger(this.getClass());

    CacheProxy(CacheConfig cacheConfig, NodeEngine nodeEngine, ICacheService cacheService) {
        super(cacheConfig, nodeEngine, cacheService);
    }

    public V get(K key) {
        return (V)this.get((Object)key, (ExpiryPolicy)null);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll((Set)keys, (ExpiryPolicy)null);
    }

    public boolean containsKey(K key) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Object k = this.serializationService.toData(key);
        Operation operation = this.operationProvider.createContainsKeyOperation((Data)k);
        OperationService operationService = this.getNodeEngine().getOperationService();
        int partitionId = this.getPartitionId((Data)k);
        InternalCompletableFuture f = operationService.invokeOnPartition(this.getServiceName(), operation, partitionId);
        return (Boolean)f.join();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        for (K key : keys) {
            CacheProxyUtil.validateConfiguredTypes(this.cacheConfig, key);
        }
        HashSet<Data> keysData = new HashSet<Data>(keys.size());
        for (K key : keys) {
            keysData.add((Data)this.serializationService.toData(key));
        }
        AbstractCacheProxyBase.LoadAllTask loadAllTask = new AbstractCacheProxyBase.LoadAllTask(this.operationProvider, keysData, replaceExistingValues, completionListener);
        try {
            this.submitLoadAllTask(loadAllTask);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void put(K key, V value) {
        this.put((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndPut(K key, V value) {
        return (V)this.getAndPut((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll((Map)map, (ExpiryPolicy)null);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public boolean remove(K key) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, null, false, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean remove(K key, V oldValue) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, oldValue, true, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public V getAndRemove(K key) {
        InternalCompletableFuture f = this.removeAsyncInternal(key, null, false, true, true);
        try {
            return f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst(e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace((Object)key, (Object)oldValue, (Object)newValue, (ExpiryPolicy)null);
    }

    public boolean replace(K key, V value) {
        ExpiryPolicy expiryPolicy = null;
        return this.replace((Object)key, (Object)value, expiryPolicy);
    }

    public V getAndReplace(K key, V value) {
        return (V)this.getAndReplace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        this.removeAllInternal(keys);
    }

    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal(null);
    }

    public void clear() {
        this.ensureOpen();
        this.clearInternal();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(this.cacheConfig.getAsReadOnly()));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Preconditions.checkNotNull(entryProcessor, "Entry Processor is null");
        Object keyData = this.serializationService.toData(key);
        Integer completionId = this.registerCompletionLatch(1);
        Operation op = this.operationProvider.createEntryProcessorOperation((Data)keyData, completionId, (EntryProcessor)entryProcessor, arguments);
        try {
            OperationService operationService = this.getNodeEngine().getOperationService();
            int partitionId = this.getPartitionId((Data)keyData);
            InternalCompletableFuture f = operationService.invokeOnPartition(this.getServiceName(), op, partitionId);
            Object safely = f.join();
            this.waitCompletionLatch(completionId);
            return (T)safely;
        }
        catch (CacheException ce) {
            this.deregisterCompletionLatch(completionId);
            throw ce;
        }
        catch (Exception e) {
            this.deregisterCompletionLatch(completionId);
            throw new EntryProcessorException((Throwable)e);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        Preconditions.checkNotNull(entryProcessor, "Entry Processor is null");
        HashMap<K, CacheEntryProcessorResult<T>> allResult = new HashMap<K, CacheEntryProcessorResult<T>>();
        for (K key : keys) {
            CacheEntryProcessorResult<T> ceResult;
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                ceResult = result != null ? new CacheEntryProcessorResult<T>(result) : null;
            }
            catch (Exception e) {
                ceResult = new CacheEntryProcessorResult<T>(e);
            }
            if (ceResult == null) continue;
            allResult.put(key, ceResult);
        }
        return allResult;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.ensureOpen();
        Preconditions.checkNotNull(cacheEntryListenerConfiguration, "CacheEntryListenerConfiguration can't be null");
        ICacheService service = (ICacheService)this.getService();
        CacheEventListenerAdaptor<K, V> entryListener = new CacheEventListenerAdaptor<K, V>(this, cacheEntryListenerConfiguration, this.getNodeEngine().getSerializationService(), this.getNodeEngine().getHazelcastInstance());
        String regId = service.registerListener(this.getDistributedObjectName(), entryListener, entryListener, false);
        if (regId != null) {
            this.cacheConfig.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)cacheEntryListenerConfiguration);
            this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        Preconditions.checkNotNull(cacheEntryListenerConfiguration, "CacheEntryListenerConfiguration can't be null");
        ICacheService service = (ICacheService)this.getService();
        String regId = this.getListenerIdLocal(cacheEntryListenerConfiguration);
        if (regId != null && service.deregisterListener(this.getDistributedObjectName(), regId)) {
            this.removeListenerLocally(cacheEntryListenerConfiguration);
            this.cacheConfig.removeCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Set<Member> members = this.getNodeEngine().getClusterService().getMembers();
        ArrayList futures = new ArrayList();
        for (Member member : members) {
            if (member.localMember()) continue;
            CacheListenerRegistrationOperation op = new CacheListenerRegistrationOperation(this.getDistributedObjectName(), cacheEntryListenerConfiguration, isRegister);
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new ClusterWideIterator(this, false);
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize) {
        this.ensureOpen();
        return new ClusterWideIterator(this, fetchSize, false);
    }

    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        this.ensureOpen();
        return new CachePartitionIterator(this, fetchSize, partitionId, prefetchValues);
    }

    @Override
    public String addPartitionLostListener(CachePartitionLostListener listener) {
        Preconditions.checkNotNull(listener, "CachePartitionLostListener can't be null");
        InternalCachePartitionLostListenerAdapter listenerAdapter = new InternalCachePartitionLostListenerAdapter(listener);
        CachePartitionLostEventFilter filter = new CachePartitionLostEventFilter();
        ICacheService service = (ICacheService)this.getService();
        this.injectDependencies(listener);
        EventRegistration registration = service.getNodeEngine().getEventService().registerListener("hz:impl:cacheService", this.name, filter, listenerAdapter);
        return registration.getId();
    }

    @Override
    public boolean removePartitionLostListener(String id) {
        Preconditions.checkNotNull(id, "Listener id should not be null!");
        ICacheService service = (ICacheService)this.getService();
        return service.getNodeEngine().getEventService().deregisterListener("hz:impl:cacheService", this.name, id);
    }
}

