/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl;

import com.att.aft.dme2.hazelcast.cache.CacheEntryView;
import com.att.aft.dme2.hazelcast.cache.CacheMergePolicy;
import com.att.aft.dme2.hazelcast.cache.StorageTypeAwareCacheMergePolicy;
import com.att.aft.dme2.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.AbstractCacheService;
import com.att.aft.dme2.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.att.aft.dme2.hazelcast.cache.impl.SplitBrainAwareCacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.maxsize.MaxSizeChecker;
import com.att.aft.dme2.hazelcast.cache.impl.merge.entry.LazyCacheEntryView;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecord;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecordFactory;
import com.att.aft.dme2.hazelcast.cache.impl.record.CacheRecordHashMap;
import com.att.aft.dme2.hazelcast.config.EvictionConfig;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Clock;

public class CacheRecordStore
extends AbstractCacheRecordStore<CacheRecord, CacheRecordHashMap>
implements SplitBrainAwareCacheRecordStore {
    protected SerializationService serializationService;
    protected CacheRecordFactory cacheRecordFactory;

    public CacheRecordStore(String name, int partitionId, NodeEngine nodeEngine, AbstractCacheService cacheService) {
        super(name, partitionId, nodeEngine, cacheService);
        this.serializationService = nodeEngine.getSerializationService();
        this.cacheRecordFactory = this.createCacheRecordFactory();
    }

    @Override
    protected MaxSizeChecker createCacheMaxSizeChecker(int size, EvictionConfig.MaxSizePolicy maxSizePolicy) {
        if (maxSizePolicy == null) {
            throw new IllegalArgumentException("Max-Size policy cannot be null");
        }
        if (maxSizePolicy != EvictionConfig.MaxSizePolicy.ENTRY_COUNT) {
            throw new IllegalArgumentException("Invalid max-size policy (" + (Object)((Object)maxSizePolicy) + ") for " + this.getClass().getName() + "! Only " + (Object)((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT) + " is supported.");
        }
        return super.createCacheMaxSizeChecker(size, maxSizePolicy);
    }

    @Override
    protected CacheRecordHashMap createRecordCacheMap() {
        return new CacheRecordHashMap(this.nodeEngine.getSerializationService(), 256, this.cacheContext);
    }

    @Override
    protected CacheEntryProcessorEntry createCacheEntryProcessorEntry(Data key, CacheRecord record, long now, int completionId) {
        return new CacheEntryProcessorEntry(key, record, this, now, completionId);
    }

    protected CacheRecordFactory createCacheRecordFactory() {
        return new CacheRecordFactory(this.cacheConfig.getInMemoryFormat(), this.nodeEngine.getSerializationService());
    }

    @Override
    protected CacheRecord createRecord(Object value, long creationTime, long expiryTime) {
        this.evictIfRequired();
        return this.cacheRecordFactory.newRecordWithExpiry(value, creationTime, expiryTime);
    }

    @Override
    protected Data valueToData(Object value) {
        return this.cacheService.toData(value);
    }

    @Override
    protected Object dataToValue(Data data) {
        return this.serializationService.toObject(data);
    }

    @Override
    protected Object recordToValue(CacheRecord record) {
        Object value = record.getValue();
        if (value instanceof Data) {
            switch (this.cacheConfig.getInMemoryFormat()) {
                case BINARY: {
                    return value;
                }
                case OBJECT: {
                    return this.dataToValue((Data)value);
                }
            }
            throw new IllegalStateException("Unsupported in-memory format: " + (Object)((Object)this.cacheConfig.getInMemoryFormat()));
        }
        return value;
    }

    @Override
    protected Data recordToData(CacheRecord record) {
        Object value = this.recordToValue(record);
        if (value == null) {
            return null;
        }
        if (value instanceof Data) {
            return (Data)value;
        }
        return this.valueToData(value);
    }

    @Override
    protected Data toHeapData(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        if (obj instanceof CacheRecord) {
            CacheRecord record = (CacheRecord)obj;
            Object value = record.getValue();
            return this.toHeapData(value);
        }
        return this.serializationService.toData(obj);
    }

    private CacheEntryView createCacheEntryView(Object key, Object value, long creationTime, long expirationTime, long lastAccessTime, long accessHit, CacheMergePolicy mergePolicy) {
        SerializationService ss = mergePolicy instanceof StorageTypeAwareCacheMergePolicy ? null : this.serializationService;
        return new LazyCacheEntryView(key, value, creationTime, expirationTime, lastAccessTime, accessHit, ss);
    }

    @Override
    public CacheRecord merge(CacheEntryView<Data, Data> cacheEntryView, CacheMergePolicy mergePolicy) {
        long now = Clock.currentTimeMillis();
        long start = this.isStatisticsEnabled() ? System.nanoTime() : 0L;
        boolean merged = false;
        Data key = cacheEntryView.getKey();
        Data value = cacheEntryView.getValue();
        long expiryTime = cacheEntryView.getExpirationTime();
        CacheRecord<Object> record = (CacheRecord<Object>)((CacheRecordHashMap)this.records).get(key);
        boolean isExpired = this.processExpiredEntry(key, record, now);
        if (record == null || isExpired) {
            Object newValue = mergePolicy.merge(this.name, this.createCacheEntryView(key, value, cacheEntryView.getCreationTime(), cacheEntryView.getExpirationTime(), cacheEntryView.getLastAccessTime(), cacheEntryView.getAccessHit(), mergePolicy), null);
            if (newValue != null) {
                record = this.createRecordWithExpiry(key, newValue, expiryTime, now, true, -1);
                merged = record != null;
            }
        } else {
            Object newValue;
            Object existingValue = record.getValue();
            if (existingValue != (newValue = mergePolicy.merge(this.name, this.createCacheEntryView(key, value, cacheEntryView.getCreationTime(), cacheEntryView.getExpirationTime(), cacheEntryView.getLastAccessTime(), cacheEntryView.getAccessHit(), mergePolicy), this.createCacheEntryView(key, existingValue, cacheEntryView.getCreationTime(), record.getExpirationTime(), record.getLastAccessTime(), record.getAccessHit(), mergePolicy)))) {
                merged = this.updateRecordWithExpiry(key, newValue, record, expiryTime, now, true, -1);
            }
        }
        if (merged && this.isStatisticsEnabled()) {
            this.statistics.increaseCachePuts(1L);
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        }
        return merged ? record : null;
    }
}

