/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.client;

import com.att.aft.dme2.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.att.aft.dme2.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CacheBatchInvalidationMessage
extends CacheInvalidationMessage {
    private List<CacheSingleInvalidationMessage> invalidationMessages;

    public CacheBatchInvalidationMessage() {
    }

    public CacheBatchInvalidationMessage(String name) {
        super(name);
        this.invalidationMessages = new ArrayList<CacheSingleInvalidationMessage>();
    }

    public CacheBatchInvalidationMessage(String name, int expectedMessageCount) {
        super(name);
        this.invalidationMessages = new ArrayList<CacheSingleInvalidationMessage>(expectedMessageCount);
    }

    public CacheBatchInvalidationMessage(String name, List<CacheSingleInvalidationMessage> invalidationMessages) {
        super(name);
        this.invalidationMessages = invalidationMessages;
    }

    public CacheBatchInvalidationMessage addInvalidationMessage(CacheSingleInvalidationMessage invalidationMessage) {
        this.invalidationMessages.add(invalidationMessage);
        return this;
    }

    public List<CacheSingleInvalidationMessage> getInvalidationMessages() {
        return this.invalidationMessages;
    }

    @Override
    public int getId() {
        return 40;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        boolean hasInvalidationMessages = this.invalidationMessages != null;
        out.writeBoolean(hasInvalidationMessages);
        if (hasInvalidationMessages) {
            out.writeInt(this.invalidationMessages.size());
            for (CacheSingleInvalidationMessage invalidationMessage : this.invalidationMessages) {
                out.writeObject(invalidationMessage);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        if (in.readBoolean()) {
            int size = in.readInt();
            this.invalidationMessages = new ArrayList<CacheSingleInvalidationMessage>(size);
            for (int i = 0; i < size; ++i) {
                this.invalidationMessages.add((CacheSingleInvalidationMessage)in.readObject());
            }
        }
    }

    public String toString() {
        return "CacheBatchInvalidationMessage{name='" + this.name + '\'' + ", invalidationMessages=" + this.invalidationMessages + '}';
    }
}

