/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.client;

import com.att.aft.dme2.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.att.aft.dme2.hazelcast.nio.ObjectDataInput;
import com.att.aft.dme2.hazelcast.nio.ObjectDataOutput;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class CacheSingleInvalidationMessage
extends CacheInvalidationMessage {
    private Data key;
    private String sourceUuid;

    public CacheSingleInvalidationMessage() {
    }

    public CacheSingleInvalidationMessage(String name, Data key, String sourceUuid) {
        super(name);
        this.key = key;
        this.sourceUuid = sourceUuid;
    }

    @Override
    public Data getKey() {
        return this.key;
    }

    @Override
    public String getSourceUuid() {
        return this.sourceUuid;
    }

    @Override
    public int getId() {
        return 39;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeUTF(this.sourceUuid);
        boolean hasKey = this.key != null;
        out.writeBoolean(hasKey);
        if (hasKey) {
            out.writeData(this.key);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.sourceUuid = in.readUTF();
        if (in.readBoolean()) {
            this.key = in.readData();
        }
    }

    public String toString() {
        return "CacheSingleInvalidationMessage{name='" + this.name + '\'' + ", key=" + this.key + ", sourceUuid='" + this.sourceUuid + '\'' + '}';
    }
}

