/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.maxsize.impl;

import com.att.aft.dme2.hazelcast.cache.impl.maxsize.MaxSizeChecker;
import com.att.aft.dme2.hazelcast.util.Preconditions;

public abstract class CompositeMaxSizeChecker
implements MaxSizeChecker {
    protected final MaxSizeChecker[] maxSizeCheckers;

    protected CompositeMaxSizeChecker(MaxSizeChecker ... maxSizeCheckers) {
        this.maxSizeCheckers = maxSizeCheckers;
    }

    public static CompositeMaxSizeChecker newCompositeMaxSizeChecker(CompositionOperator compositionOperator, MaxSizeChecker ... maxSizeCheckers) {
        Preconditions.isNotNull(compositionOperator, "Composition operator cannot be null!");
        Preconditions.isNotNull(maxSizeCheckers, "MaxSizeChecker's cannot be null!");
        if (maxSizeCheckers.length == 0) {
            throw new IllegalArgumentException("MaxSizeChecker's cannot be empty!");
        }
        switch (compositionOperator) {
            case AND: {
                return new CompositeMaxSizeCheckerWithAndComposition(maxSizeCheckers);
            }
            case OR: {
                return new CompositeMaxSizeCheckerWithOrComposition(maxSizeCheckers);
            }
        }
        throw new IllegalArgumentException("Invalid composition operator: " + (Object)((Object)compositionOperator));
    }

    private static final class CompositeMaxSizeCheckerWithOrComposition
    extends CompositeMaxSizeChecker {
        private CompositeMaxSizeCheckerWithOrComposition(MaxSizeChecker ... maxSizeCheckers) {
            super(maxSizeCheckers);
        }

        @Override
        public boolean isReachedToMaxSize() {
            for (MaxSizeChecker maxSizeChecker : this.maxSizeCheckers) {
                if (!maxSizeChecker.isReachedToMaxSize()) continue;
                return true;
            }
            return false;
        }
    }

    private static final class CompositeMaxSizeCheckerWithAndComposition
    extends CompositeMaxSizeChecker {
        private CompositeMaxSizeCheckerWithAndComposition(MaxSizeChecker ... maxSizeCheckers) {
            super(maxSizeCheckers);
        }

        @Override
        public boolean isReachedToMaxSize() {
            for (MaxSizeChecker maxSizeChecker : this.maxSizeCheckers) {
                if (maxSizeChecker.isReachedToMaxSize()) continue;
                return false;
            }
            return true;
        }
    }

    public static enum CompositionOperator {
        AND,
        OR;

    }
}

