/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.merge.policy;

import com.att.aft.dme2.hazelcast.cache.BuiltInCacheMergePolicies;
import com.att.aft.dme2.hazelcast.cache.CacheMergePolicy;
import com.att.aft.dme2.hazelcast.config.InvalidConfigurationException;
import com.att.aft.dme2.hazelcast.nio.ClassLoaderUtil;
import com.att.aft.dme2.hazelcast.spi.NodeEngine;
import com.att.aft.dme2.hazelcast.util.ConcurrencyUtil;
import com.att.aft.dme2.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CacheMergePolicyProvider {
    private final ConcurrentMap<String, CacheMergePolicy> mergePolicyMap;
    private final NodeEngine nodeEngine;
    private final ConstructorFunction<String, CacheMergePolicy> policyConstructorFunction = new ConstructorFunction<String, CacheMergePolicy>(){

        @Override
        public CacheMergePolicy createNew(String className) {
            try {
                return (CacheMergePolicy)ClassLoaderUtil.newInstance(CacheMergePolicyProvider.this.nodeEngine.getConfigClassLoader(), className);
            }
            catch (Exception e) {
                CacheMergePolicyProvider.this.nodeEngine.getLogger(this.getClass()).severe(e);
                throw new InvalidConfigurationException("Invalid cache merge policy: " + className, e);
            }
        }
    };

    public CacheMergePolicyProvider(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.mergePolicyMap = new ConcurrentHashMap<String, CacheMergePolicy>();
        this.addOutOfBoxPolicies();
    }

    private void addOutOfBoxPolicies() {
        for (BuiltInCacheMergePolicies mergePolicy : BuiltInCacheMergePolicies.values()) {
            CacheMergePolicy cacheMergePolicy = mergePolicy.newInstance();
            this.mergePolicyMap.put(mergePolicy.name(), cacheMergePolicy);
            this.mergePolicyMap.put(mergePolicy.getImplementationClassName(), cacheMergePolicy);
        }
    }

    public CacheMergePolicy getMergePolicy(String className) {
        if (className == null) {
            throw new InvalidConfigurationException("Class name is mandatory!");
        }
        return ConcurrencyUtil.getOrPutIfAbsent(this.mergePolicyMap, className, this.policyConstructorFunction);
    }
}

