/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl;

import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCache;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheExecutor;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.store.NearCacheDataRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.store.NearCacheObjectRecordStore;
import com.att.aft.dme2.hazelcast.config.InMemoryFormat;
import com.att.aft.dme2.hazelcast.config.NearCacheConfig;
import com.att.aft.dme2.hazelcast.monitor.NearCacheStats;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Preconditions;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultNearCache<K, V>
implements NearCache<K, V> {
    protected final String name;
    protected final NearCacheConfig nearCacheConfig;
    protected final NearCacheContext nearCacheContext;
    protected final SerializationService serializationService;
    protected NearCacheRecordStore<K, V> nearCacheRecordStore;
    protected ScheduledFuture expirationTaskFuture;

    public DefaultNearCache(String name, NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        this.name = name;
        this.nearCacheConfig = nearCacheConfig;
        this.nearCacheContext = nearCacheContext;
        this.serializationService = nearCacheContext.getSerializationService();
        this.nearCacheRecordStore = this.createNearCacheRecordStore(nearCacheConfig, nearCacheContext);
        this.init();
    }

    public DefaultNearCache(String name, NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext, NearCacheRecordStore<K, V> nearCacheRecordStore) {
        this.name = name;
        this.nearCacheConfig = nearCacheConfig;
        this.nearCacheContext = nearCacheContext;
        this.serializationService = nearCacheContext.getSerializationService();
        this.nearCacheRecordStore = nearCacheRecordStore;
        this.init();
    }

    protected void init() {
        this.startExpirationTask();
    }

    protected void startExpirationTask() {
        if (this.isExpirationAvailable()) {
            NearCacheExecutor nearCacheExecutor = this.nearCacheContext.getNearCacheExecutor();
            ExpirationTask expirationTask = this.createExpirationTask();
            if (expirationTask != null) {
                this.expirationTaskFuture = this.scheduleExpirationTask(nearCacheExecutor, expirationTask);
            }
        }
    }

    protected boolean isExpirationAvailable() {
        return (long)this.nearCacheConfig.getMaxIdleSeconds() > 0L || (long)this.nearCacheConfig.getTimeToLiveSeconds() > 0L;
    }

    protected ExpirationTask createExpirationTask() {
        return new ExpirationTask();
    }

    protected ScheduledFuture scheduleExpirationTask(NearCacheExecutor nearCacheExecutor, ExpirationTask expirationTask) {
        return nearCacheExecutor.scheduleWithRepetition(expirationTask, 5L, 5L, TimeUnit.SECONDS);
    }

    protected NearCacheRecordStore<K, V> createNearCacheRecordStore(NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (inMemoryFormat == null) {
            inMemoryFormat = NearCacheConfig.DEFAULT_MEMORY_FORMAT;
        }
        switch (inMemoryFormat) {
            case BINARY: {
                return new NearCacheDataRecordStore(nearCacheConfig, nearCacheContext);
            }
            case OBJECT: {
                return new NearCacheObjectRecordStore(nearCacheConfig, nearCacheContext);
            }
        }
        throw new IllegalArgumentException("Invalid in memory format: " + (Object)((Object)inMemoryFormat));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public V get(K key) {
        Preconditions.checkNotNull(key, "key cannot be null on get!");
        return this.nearCacheRecordStore.get(key);
    }

    @Override
    public void put(K key, V value) {
        Preconditions.checkNotNull(key, "key cannot be null on put!");
        this.nearCacheRecordStore.doEvictionIfRequired();
        this.nearCacheRecordStore.put(key, value);
    }

    @Override
    public boolean remove(K key) {
        Preconditions.checkNotNull(key, "key cannot be null on remove!");
        return this.nearCacheRecordStore.remove(key);
    }

    @Override
    public boolean isInvalidateOnChange() {
        return this.nearCacheConfig.isInvalidateOnChange();
    }

    @Override
    public void clear() {
        this.nearCacheRecordStore.clear();
    }

    @Override
    public void destroy() {
        if (this.expirationTaskFuture != null) {
            this.expirationTaskFuture.cancel(true);
        }
        this.nearCacheRecordStore.destroy();
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.nearCacheConfig.getInMemoryFormat();
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        return this.nearCacheRecordStore.getNearCacheStats();
    }

    @Override
    public Object selectToSave(Object ... candidates) {
        return this.nearCacheRecordStore.selectToSave(candidates);
    }

    @Override
    public int size() {
        return this.nearCacheRecordStore.size();
    }

    protected class ExpirationTask
    implements Runnable {
        protected AtomicBoolean expirationInProgress = new AtomicBoolean(false);

        protected ExpirationTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.expirationInProgress.compareAndSet(false, true)) {
                try {
                    DefaultNearCache.this.nearCacheRecordStore.doExpiration();
                }
                finally {
                    this.expirationInProgress.set(false);
                }
            }
        }
    }
}

