/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.store;

import com.att.aft.dme2.hazelcast.cache.impl.maxsize.MaxSizeChecker;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheRecord;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.NearCacheRecordMap;
import com.att.aft.dme2.hazelcast.config.EvictionConfig;
import com.att.aft.dme2.hazelcast.config.NearCacheConfig;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionChecker;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionListener;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionPolicyEvaluatorProvider;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionPolicyType;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionStrategy;
import com.att.aft.dme2.hazelcast.internal.eviction.EvictionStrategyProvider;
import com.att.aft.dme2.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.att.aft.dme2.hazelcast.monitor.NearCacheStats;
import com.att.aft.dme2.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.att.aft.dme2.hazelcast.nio.serialization.Data;
import com.att.aft.dme2.hazelcast.spi.serialization.SerializationService;
import com.att.aft.dme2.hazelcast.util.Clock;
import com.att.aft.dme2.hazelcast.util.ExceptionUtil;

public abstract class AbstractNearCacheRecordStore<K, V, KS, R extends NearCacheRecord, NCRM extends NearCacheRecordMap<KS, R>>
implements NearCacheRecordStore<K, V>,
EvictionListener<KS, R> {
    protected static final int REFERENCE_SIZE = GlobalMemoryAccessorRegistry.MEM_AVAILABLE ? GlobalMemoryAccessorRegistry.MEM.arrayIndexScale(Object[].class) : 4;
    private static final int MILLI_SECONDS_IN_A_SECOND = 1000;
    protected final long timeToLiveMillis;
    protected final long maxIdleMillis;
    protected final NearCacheConfig nearCacheConfig;
    protected final SerializationService serializationService;
    protected final ClassLoader classLoader;
    protected final NearCacheStatsImpl nearCacheStats;
    protected NCRM records;
    protected final MaxSizeChecker maxSizeChecker;
    protected final EvictionPolicyEvaluator<KS, R> evictionPolicyEvaluator;
    protected final EvictionChecker evictionChecker;
    protected final EvictionStrategy<KS, R, NCRM> evictionStrategy;

    public AbstractNearCacheRecordStore(NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        this(nearCacheConfig, nearCacheContext, new NearCacheStatsImpl());
    }

    public AbstractNearCacheRecordStore(NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext, NearCacheStatsImpl nearCacheStats) {
        this.nearCacheConfig = nearCacheConfig;
        this.timeToLiveMillis = nearCacheConfig.getTimeToLiveSeconds() * 1000;
        this.maxIdleMillis = nearCacheConfig.getMaxIdleSeconds() * 1000;
        this.serializationService = nearCacheContext.getSerializationService();
        this.classLoader = nearCacheContext.getClassLoader();
        this.nearCacheStats = nearCacheStats;
        this.records = this.createNearCacheRecordMap(nearCacheConfig, nearCacheContext);
        EvictionConfig evictionConfig = nearCacheConfig.getEvictionConfig();
        if (evictionConfig != null) {
            this.maxSizeChecker = this.createNearCacheMaxSizeChecker(evictionConfig, nearCacheConfig, nearCacheContext);
            this.evictionPolicyEvaluator = this.createEvictionPolicyEvaluator(evictionConfig);
            this.evictionChecker = this.createEvictionChecker(nearCacheConfig);
            this.evictionStrategy = this.createEvictionStrategy(evictionConfig);
        } else {
            this.maxSizeChecker = null;
            this.evictionPolicyEvaluator = null;
            this.evictionChecker = null;
            this.evictionStrategy = null;
        }
    }

    protected abstract MaxSizeChecker createNearCacheMaxSizeChecker(EvictionConfig var1, NearCacheConfig var2, NearCacheContext var3);

    protected abstract NCRM createNearCacheRecordMap(NearCacheConfig var1, NearCacheContext var2);

    protected abstract long getKeyStorageMemoryCost(K var1);

    protected abstract long getRecordStorageMemoryCost(R var1);

    protected abstract R valueToRecord(V var1);

    protected abstract V recordToValue(R var1);

    protected abstract R getRecord(K var1);

    protected abstract R putRecord(K var1, R var2);

    protected abstract void putToRecord(R var1, V var2);

    protected abstract R removeRecord(K var1);

    protected void checkAvailable() {
        if (!this.isAvailable()) {
            throw new IllegalStateException(this.nearCacheConfig.getName() + " named near cache record store is not available");
        }
    }

    protected EvictionPolicyEvaluator<KS, R> createEvictionPolicyEvaluator(EvictionConfig evictionConfig) {
        EvictionPolicyType evictionPolicyType = evictionConfig.getEvictionPolicyType();
        if (evictionPolicyType == null) {
            throw new IllegalArgumentException("Eviction policy cannot be null");
        }
        return EvictionPolicyEvaluatorProvider.getEvictionPolicyEvaluator(evictionConfig, this.classLoader);
    }

    protected EvictionChecker createEvictionChecker(NearCacheConfig nearCacheConfig) {
        return new MaxSizeEvictionChecker();
    }

    protected EvictionStrategy<KS, R, NCRM> createEvictionStrategy(EvictionConfig evictionConfig) {
        return EvictionStrategyProvider.getEvictionStrategy(evictionConfig);
    }

    protected boolean isAvailable() {
        return this.records != null;
    }

    protected Data valueToData(V value) {
        if (value instanceof Data) {
            return (Data)value;
        }
        if (value != null) {
            return this.serializationService.toData(value);
        }
        return null;
    }

    protected V dataToValue(Data data) {
        if (data != null) {
            return (V)this.serializationService.toObject(data);
        }
        return null;
    }

    protected Data toData(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        return this.valueToData(obj);
    }

    protected V toValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return this.dataToValue((Data)obj);
        }
        return (V)obj;
    }

    protected long getTotalStorageMemoryCost(K key, R record) {
        return this.getKeyStorageMemoryCost(key) + this.getRecordStorageMemoryCost(record);
    }

    protected boolean isRecordExpired(R record) {
        long now = Clock.currentTimeMillis();
        if (record.isExpiredAt(now)) {
            return true;
        }
        return record.isIdleAt(this.maxIdleMillis, now);
    }

    protected void onRecordCreate(R record) {
        record.setCreationTime(Clock.currentTimeMillis());
    }

    protected void onRecordAccess(R record) {
        record.setAccessTime(Clock.currentTimeMillis());
        record.incrementAccessHit();
    }

    protected void onGet(K key, V value, R record) {
    }

    protected void onGetError(K key, V value, R record, Throwable error) {
    }

    protected void onPut(K key, V value, R record, R oldRecord) {
    }

    protected void onPutError(K key, V value, R record, R oldRecord, Throwable error) {
    }

    protected void onRemove(K key, R record, boolean removed) {
    }

    protected void onRemoveError(K key, R record, boolean removed, Throwable error) {
    }

    protected boolean isEvictionEnabled() {
        return this.evictionStrategy != null && this.evictionPolicyEvaluator != null;
    }

    @Override
    public void onEvict(KS key, R record) {
        this.nearCacheStats.decrementOwnedEntryCount();
    }

    @Override
    public V get(K key) {
        this.checkAvailable();
        R record = null;
        V value = null;
        try {
            record = this.getRecord(key);
            if (record != null) {
                if (this.isRecordExpired(record)) {
                    this.remove(key);
                    return null;
                }
                this.onRecordAccess(record);
                this.nearCacheStats.incrementHits();
                value = this.recordToValue(record);
                this.onGet(key, value, record);
                return value;
            }
            this.nearCacheStats.incrementMisses();
            return null;
        }
        catch (Throwable error) {
            this.onGetError(key, value, record, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public void put(K key, V value) {
        this.checkAvailable();
        R record = null;
        R oldRecord = null;
        try {
            record = this.valueToRecord(value);
            this.onRecordCreate(record);
            oldRecord = this.putRecord(key, record);
            if (oldRecord == null) {
                this.nearCacheStats.incrementOwnedEntryCount();
            } else {
                long oldRecordMemoryCost = this.getRecordStorageMemoryCost(oldRecord);
                this.nearCacheStats.decrementOwnedEntryMemoryCost(oldRecordMemoryCost);
            }
            this.onPut(key, value, record, oldRecord);
        }
        catch (Throwable error) {
            this.onPutError(key, value, record, oldRecord, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean remove(K key) {
        this.checkAvailable();
        R record = null;
        boolean removed = false;
        try {
            record = this.removeRecord(key);
            if (record != null) {
                removed = true;
                this.nearCacheStats.decrementOwnedEntryCount();
            }
            this.onRemove(key, record, removed);
            return record != null;
        }
        catch (Throwable error) {
            this.onRemoveError(key, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected void clearRecords() {
        this.records.clear();
    }

    @Override
    public void clear() {
        this.checkAvailable();
        this.clearRecords();
        this.nearCacheStats.setOwnedEntryCount(0L);
        this.nearCacheStats.setOwnedEntryMemoryCost(0L);
    }

    protected void destroyStore() {
        this.clearRecords();
        this.records = null;
    }

    @Override
    public void destroy() {
        this.checkAvailable();
        this.destroyStore();
        this.nearCacheStats.setOwnedEntryCount(0L);
        this.nearCacheStats.setOwnedEntryMemoryCost(0L);
    }

    @Override
    public int size() {
        this.checkAvailable();
        return this.records.size();
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        this.checkAvailable();
        return this.nearCacheStats;
    }

    @Override
    public void doEvictionIfRequired() {
        this.checkAvailable();
        if (this.isEvictionEnabled()) {
            this.evictionStrategy.evict(this.records, this.evictionPolicyEvaluator, this.evictionChecker, this);
        }
    }

    @Override
    public void doEviction() {
        this.checkAvailable();
        if (this.isEvictionEnabled()) {
            this.evictionStrategy.evict(this.records, this.evictionPolicyEvaluator, null, this);
        }
    }

    protected class MaxSizeEvictionChecker
    implements EvictionChecker {
        protected MaxSizeEvictionChecker() {
        }

        @Override
        public boolean isEvictionRequired() {
            if (AbstractNearCacheRecordStore.this.maxSizeChecker != null) {
                return AbstractNearCacheRecordStore.this.maxSizeChecker.isReachedToMaxSize();
            }
            return false;
        }
    }
}

