/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.store;

import com.att.aft.dme2.hazelcast.cache.impl.maxsize.MaxSizeChecker;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheContext;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.NearCacheRecord;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.maxsize.EntryCountNearCacheMaxSizeChecker;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.store.AbstractNearCacheRecordStore;
import com.att.aft.dme2.hazelcast.cache.impl.nearcache.impl.store.HeapNearCacheRecordMap;
import com.att.aft.dme2.hazelcast.config.EvictionConfig;
import com.att.aft.dme2.hazelcast.config.NearCacheConfig;
import java.util.Map;

public abstract class BaseHeapNearCacheRecordStore<K, V, R extends NearCacheRecord>
extends AbstractNearCacheRecordStore<K, V, K, R, HeapNearCacheRecordMap<K, R>> {
    protected static final int DEFAULT_INITIAL_CAPACITY = 1000;

    public BaseHeapNearCacheRecordStore(NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        super(nearCacheConfig, nearCacheContext);
    }

    @Override
    protected MaxSizeChecker createNearCacheMaxSizeChecker(EvictionConfig evictionConfig, NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        EvictionConfig.MaxSizePolicy maxSizePolicy = evictionConfig.getMaximumSizePolicy();
        if (maxSizePolicy == null) {
            throw new IllegalArgumentException("Max-Size policy cannot be null");
        }
        if (maxSizePolicy == EvictionConfig.MaxSizePolicy.ENTRY_COUNT) {
            return new EntryCountNearCacheMaxSizeChecker(evictionConfig.getSize(), this.records);
        }
        throw new IllegalArgumentException("Invalid max-size policy (" + (Object)((Object)maxSizePolicy) + ") for " + this.getClass().getName() + "! Only " + (Object)((Object)EvictionConfig.MaxSizePolicy.ENTRY_COUNT) + " is supported.");
    }

    @Override
    protected HeapNearCacheRecordMap<K, R> createNearCacheRecordMap(NearCacheConfig nearCacheConfig, NearCacheContext nearCacheContext) {
        return new HeapNearCacheRecordMap(nearCacheContext.getSerializationService(), 1000);
    }

    @Override
    protected R getRecord(K key) {
        return (R)((NearCacheRecord)((HeapNearCacheRecordMap)this.records).get(key));
    }

    @Override
    protected R putRecord(K key, R record) {
        NearCacheRecord oldRecord = (NearCacheRecord)((HeapNearCacheRecordMap)this.records).put(key, record);
        this.nearCacheStats.incrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, record));
        return (R)oldRecord;
    }

    @Override
    protected R removeRecord(K key) {
        NearCacheRecord removedRecord = (NearCacheRecord)((HeapNearCacheRecordMap)this.records).remove(key);
        if (removedRecord != null) {
            this.nearCacheStats.decrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, removedRecord));
        }
        return (R)removedRecord;
    }

    @Override
    public void onEvict(K key, R record) {
        super.onEvict(key, record);
        this.nearCacheStats.decrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, record));
    }

    @Override
    public void doExpiration() {
        for (Map.Entry entry : ((HeapNearCacheRecordMap)this.records).entrySet()) {
            Object key = entry.getKey();
            NearCacheRecord value = (NearCacheRecord)entry.getValue();
            if (!this.isRecordExpired(value)) continue;
            this.remove(key);
        }
    }
}

